/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.commons.io.FileUtils;
import org.gvsig.scripting.ExecuteErrorException;
import org.gvsig.scripting.ScriptingDialog;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.impl.DefaultScriptingScript;
import org.gvsig.scripting.swing.api.JThinlet;
import org.gvsig.scripting.swing.api.ScriptingSwingLocator;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.ini4j.Ini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScriptingDialog
extends DefaultScriptingScript
implements ScriptingDialog,
ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultScriptingDialog.class);
    private int showMode;

    public DefaultScriptingDialog(ScriptingFolder parent, ScriptingManager manager, String id) {
        super(parent, "Dialog", manager, id);
        this.setMainName("onload");
        this.showMode = 2;
    }

    @Override
    public void runAsTask(Object[] args) {
        this.run(args);
    }

    @Override
    public Object run(Object[] args) {
        ScriptingUIManager uimanager = ScriptingSwingLocator.getUIManager();
        JThinlet thinlet = uimanager.createJThinlet();
        thinlet.addActionListener((ActionListener)this);
        thinlet.load(this.getFileResource(".dlg"));
        this.put("dialog", thinlet.getThinlet());
        this.compile();
        try {
            this.invokeFunction(this.getMainName(), args);
        }
        catch (ExecuteErrorException ex) {
            Throwable e = ex.getCause();
            if (e instanceof NoSuchMethodException) {
                System.out.println("Code of dialog do not has function '" + this.getMainName() + "'.");
            }
            throw ex;
        }
        switch (this.getShowMode()) {
            case 2: {
                System.out.println("Showing dialog as window " + this.getName() + ".");
                uimanager.showWindow((JComponent)thinlet, this.getName());
                break;
            }
            case 3: {
                System.out.println("Showing dialog as tool " + this.getName() + ".");
                uimanager.showTool((JComponent)thinlet, this.getName());
                break;
            }
            default: {
                System.out.println("Showing dialog as dialog " + this.getName() + ".");
                uimanager.showDialog((JComponent)thinlet, this.getName());
            }
        }
        return null;
    }

    @Override
    protected void loadInf(Ini prefs) {
        super.loadInf(prefs);
        this.showMode = Integer.parseInt(this.getInfValue(prefs, "Dialog", "showMode", 2).toString());
    }

    @Override
    protected void save(Ini prefs) {
        super.save(prefs);
        prefs.put("Dialog", "showMode", (Object)this.showMode);
    }

    @Override
    public String[] getIconNames() {
        return new String[]{"scripting-icon-dialog", "scripting-icon-dialog"};
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            this.invokeFunction(arg0.getActionCommand(), null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public File getDialogFile() {
        return this.getFileResource(".dlg");
    }

    @Override
    public List<File> getFiles() {
        ArrayList<File> l = new ArrayList<File>();
        l.add(this.getResource(".dlg"));
        l.add(this.getResource(this.getExtension()));
        return l;
    }

    public int getShowMode() {
        return this.showMode;
    }

    public void setShowMode(int mode) {
        this.showMode = mode;
    }

    @Override
    public boolean remove() {
        boolean r = super.remove();
        File folder = this.getParent().getFile();
        File f = new File(folder, this.getId() + ".dlg");
        try {
            FileUtils.forceDelete((File)f);
        }
        catch (IOException e) {
            logger.warn("Can't remove dialog file '" + f.getAbsolutePath() + "'.", (Throwable)e);
            r = false;
        }
        return r;
    }

    @Override
    public void create(ScriptingFolder folder, String id, String language) {
        super.create(folder, id, language);
        File fileDlg = this.getResource(this.getId() + ".dlg");
        try {
            fileDlg.createNewFile();
        }
        catch (IOException e) {
            logger.warn("Can't create the dialog in '" + fileDlg.getAbsolutePath() + "'.", (Throwable)e);
        }
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(fileDlg));
            output.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<panel/>");
            ((Writer)output).close();
        }
        catch (IOException e) {
            logger.warn("Can't write xml code of the dialog to '" + fileDlg.getAbsolutePath() + "'.", (Throwable)e);
        }
        this.save();
    }

    @Override
    public String getMimeType() {
        return "text";
    }

    @Override
    public boolean move(ScriptingFolder target) {
        File dlgfile = this.getFileResource(".dlg");
        if (!super.move(target)) {
            return false;
        }
        try {
            FileUtils.moveFileToDirectory((File)dlgfile, (File)target.getFile(), (boolean)true);
        }
        catch (IOException ex) {
            logger.info("Can't move script '" + this.getId() + "' to '" + target.getFile().getAbsolutePath() + "', " + ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    @Override
    public boolean rename(String newId) {
        File dlgfile = this.getFileResource(".dlg");
        if (!super.rename(newId)) {
            return false;
        }
        try {
            ScriptingFolder target = this.getParent();
            FileUtils.moveFile((File)dlgfile, (File)new File(target.getFile(), newId + ".dlg"));
        }
        catch (IOException ex) {
            logger.info("Can't rename script '" + this.getId() + "' to '" + newId + "', " + ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }
}

