/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.xyshift;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.geoprocess.algorithm.xyshift.XYShiftOperation;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.task.SimpleTaskStatus;

public class XYShiftAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String RESULT_POL = "RESULT_POL";
    public static final String RESULT_POINT = "RESULT_POINT";
    public static final String RESULT_LINE = "RESULT_LINE";
    public static final String LAYER = "LAYER";
    public static final String CHECK = "CHECK";
    public static final String X = "X";
    public static final String Y = "Y";

    public void defineCharacteristics() {
        this.setName(this.getTranslation("XYShift"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, this.getTranslation("Input_layer"), -1, true);
            this.m_Parameters.addBoolean(CHECK, this.getTranslation("Selected_geometries_xy"), false);
            this.m_Parameters.addNumericalValue(X, this.getTranslation("X_traslation"), 0.0, 2);
            this.m_Parameters.addNumericalValue(Y, this.getTranslation("Y_traslation"), 0.0, 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.addOutputVectorLayer(RESULT_POL, this.getTranslation("XYShift_polygon"), 2);
        this.addOutputVectorLayer(RESULT_LINE, this.getTranslation("XYShift_line"), 1);
        this.addOutputVectorLayer(RESULT_POINT, this.getTranslation("XYShift_point"), 0);
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT_POL, 0) || this.existsOutPutFile(RESULT_LINE, 0) || this.existsOutPutFile(RESULT_POINT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        boolean selectedGeom = this.m_Parameters.getParameter(CHECK).getParameterValueAsBoolean();
        double x = this.m_Parameters.getParameterValueAsDouble(X);
        double y = this.m_Parameters.getParameterValueAsDouble(Y);
        FeatureStore storeLayer = null;
        if (!(layer instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        storeLayer = ((FlyrVectIVectorLayer)layer).getFeatureStore();
        try {
            XYShiftOperation operation;
            FeatureStore outFeatStore;
            FeatureSet features = null;
            features = storeLayer.getFeatureSet();
            FeatureType featureType = features.getDefaultFeatureType();
            if (this.isPolygon(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStore = this.buildOutPutStore(featureType, 6, this.getTranslation("XYShift_polygon"), RESULT_POL);
                operation = new XYShiftOperation(x, y, this);
                operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
                operation.computesFeatureOperation(storeLayer, outFeatStore, this.attrNames, selectedGeom, false, true);
            } else {
                this.buildOutPutStore(featureType, 6, this.getTranslation("Null_polygon"), RESULT_POL);
            }
            if (this.isLine(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStore = this.buildOutPutStore(featureType, 5, this.getTranslation("XYShift_line"), RESULT_LINE);
                operation = new XYShiftOperation(x, y, this);
                operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
                operation.computesFeatureOperation(storeLayer, outFeatStore, this.attrNames, selectedGeom, false, true);
            } else {
                this.buildOutPutStore(featureType.getCopy(), 5, this.getTranslation("Null_line"), RESULT_LINE);
            }
            if (this.isPoint(storeLayer) || this.isUndefined(storeLayer)) {
                outFeatStore = this.buildOutPutStore(featureType.getCopy(), 0, this.getTranslation("XYShift_point"), RESULT_POINT);
                operation = new XYShiftOperation(x, y, this);
                operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
                operation.computesFeatureOperation(storeLayer, outFeatStore, this.attrNames, selectedGeom, false, true);
            } else {
                this.buildOutPutStore(featureType.getCopy(), 0, this.getTranslation("Null_point"), RESULT_POINT);
            }
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return !this.getTaskMonitor().isCanceled();
    }
}

