/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.app.extension;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.UIManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FileUtils;
import org.gvsig.about.AboutLocator;
import org.gvsig.about.AboutManager;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.app.extension.ScriptingUtils;
import org.gvsig.scripting.swing.api.ScriptingSwingLocator;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.library.impl.DefaultLibrariesInitializer;
import org.gvsig.tools.packageutils.PackageInfo;
import org.gvsig.tools.packageutils.PackageManager;
import org.gvsig.tools.packageutils.Version;

public class ScriptingMain {
    private File applicationFolder = null;
    private Version applicacionVersion = null;
    private List<File> pluginsFolder = null;
    private File applicationHomeFolder;
    private File installFolder;
    private int applicacionBuildNumber;
    private ScriptingUtils utils;

    public static void main(String[] args) throws Exception {
        ScriptingMain main = new ScriptingMain();
        main.doMain(args);
    }

    public File getApplicationFolder() {
        if (this.applicationFolder == null) {
            this.applicationFolder = new File(System.getProperty("user.dir"));
        }
        return this.applicationFolder;
    }

    public File getApplicationHomeFolder() {
        if (this.applicationHomeFolder == null) {
            this.applicationHomeFolder = new File(System.getProperty("user.home"));
        }
        return this.applicationHomeFolder;
    }

    public File getInstallFolder() {
        if (this.installFolder == null) {
            this.installFolder = FileUtils.getFile((File)this.getApplicationFolder(), (String[])new String[]{"install"});
        }
        return this.installFolder;
    }

    public Version getApplicationVersion() throws BaseException {
        if (this.applicacionVersion == null) {
            PackageManager packageManager = ToolsLocator.getPackageManager();
            PackageInfo packageInfo = packageManager.createPackageInfo(new File(this.applicationFolder, "package.info"));
            this.applicacionVersion = (Version)packageInfo.getVersion();
        }
        return this.applicacionVersion;
    }

    public int getApplicationBuildNumber() throws BaseException {
        if (this.applicacionBuildNumber == 0) {
            this.applicacionBuildNumber = this.getApplicationVersion().getBuild();
        }
        return this.applicacionBuildNumber;
    }

    public List<File> getPluginsFolder() {
        ArrayList<File> folders = new ArrayList<File>();
        folders.add(FileUtils.getFile((File)this.getApplicationFolder(), (String[])new String[]{"gvSIG", "extensiones"}));
        folders.add(FileUtils.getFile((File)this.getApplicationHomeFolder(), (String[])new String[]{"gvSIG", "installation", "gvSIG", "extensiones"}));
        return folders;
    }

    public File getPluginHomeFolder() {
        File f = this.getApplicationHomeFolder();
        f = FileUtils.getFile((File)f, (String[])new String[]{"gvSIG", "plugins", "org.gvsig.scripting.app.mainplugin"});
        return f;
    }

    private void initializeAbout() throws Exception {
        AboutManager aboutManager = AboutLocator.getManager();
        String build = String.valueOf(this.getApplicationBuildNumber());
        String version = this.getApplicationVersion().toString();
        HashMap<String, String> gvsig_vars = new HashMap<String, String>();
        gvsig_vars.put("version", version);
        gvsig_vars.put("build", build);
        aboutManager.setProject("gvSIG Desktop", this.getResource("gvsig.html"), null, gvsig_vars);
        aboutManager.getProject().set("build", build);
        aboutManager.addSponsor("Generalitat Valenciana", this.getResource("gva.html"), 1);
        aboutManager.addDeveloper("gvSIG Asocicion", this.getResource("gvSIG-asociacion.html"), 2);
    }

    public void doMain(String[] args) throws Exception {
        String lookAndFeel = "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        new DefaultLibrariesInitializer().fullInitialize();
        this.initializeAbout();
        this.utils = new ScriptingUtils();
        this.utils.initializaPaths(this.getPluginsFolder(), this.getInstallFolder(), this.getPluginHomeFolder(), this.getApplicationVersion().format("%M.%m.%r"));
        ScriptingUIManager uimanager = ScriptingSwingLocator.getUIManager();
        ScriptingManager manager = uimanager.getManager();
        Options options = new Options();
        options.addOption("d", "debug", false, "");
        options.addOption("p", "pause", false, "");
        options.addOption("l", "launcher", false, "Show the launcher window");
        options.addOption("c", "composer", false, "Show the composer window");
        options.addOption("r", "run", true, "Run the specified script");
        options.addOption("h", "home", true, "Specify for the home of the script framework");
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        boolean runLauncherAtEnd = true;
        line = parser.parse(options, args);
        if (line.hasOption("home")) {
            manager.setHomeFolder(new File(line.getOptionValue("home")));
        }
        if (line.hasOption("composer")) {
            runLauncherAtEnd = false;
            this.utils.runComposer();
        }
        if (line.hasOption("run")) {
            runLauncherAtEnd = false;
            this.utils.runScript(line.getOptionValue("run"), line.getArgs());
        }
        if (runLauncherAtEnd) {
            this.utils.runLauncher();
        }
    }

    private URL getResource(String name) {
        URL resource = this.getClass().getResource(name);
        return resource;
    }
}

