/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.app.extension;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.scripting.DataFolderFound;
import org.gvsig.scripting.ScriptingBaseScript;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingLocator;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingScript;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.app.extension.DataFoldersRecoverPanel;
import org.gvsig.scripting.app.extension.ScriptingExtension;
import org.gvsig.scripting.app.extension.messagewait.MessageWait;
import org.gvsig.scripting.swing.api.JScriptingComposer;
import org.gvsig.scripting.swing.api.ScriptingSwingLocator;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.packageutils.PackageManager;
import org.gvsig.tools.packageutils.Version;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.impl.windowmanager.DefaultWindowManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.FolderSet;
import org.gvsig.tools.util.impl.DefaultFolderSet;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingUtils {
    public static final String SKIP_AUTORUNS = "skipAutoruns";
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptingExtension.class);
    private boolean executingAutorunScripts = false;
    private static boolean composer_initialized = false;
    private final MessageWait message = new MessageWait();
    public static final int INFO = 0;
    public static final int TRACE = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    private String appversion;
    private File pluginHomeFolder;

    public static void log(String message) {
        ScriptingUtils.log(0, message, null);
    }

    public static void log(int level, String message) {
        ScriptingUtils.log(level, message, null);
    }

    public static void log(int level, String message, Throwable th) {
        switch (level) {
            case 1: {
                LOGGER.trace(message, th);
                break;
            }
            case 3: {
                LOGGER.error(message, th);
                break;
            }
            case 2: {
                LOGGER.warn(message, th);
                break;
            }
            default: {
                LOGGER.info(message, th);
            }
        }
    }

    public static File getScriptsHomeFolder(File pluginHomeFolder, String appversion) {
        File scriptsHomeFolder;
        File f = FileUtils.getFile((File)pluginHomeFolder, (String[])new String[]{"scripts-folder.txt"});
        if (f.exists()) {
            try {
                List lines = FileUtils.readLines((File)f);
                for (String line : lines) {
                    if ((line = line.trim()).startsWith("#")) continue;
                    scriptsHomeFolder = new File(line);
                    if (!scriptsHomeFolder.isAbsolute()) {
                        scriptsHomeFolder = new File(pluginHomeFolder, line);
                    }
                    if (!(scriptsHomeFolder = new File(FilenameUtils.normalizeNoEndSeparator((String)scriptsHomeFolder.getAbsolutePath(), (boolean)true))).exists()) continue;
                    return scriptsHomeFolder;
                }
            }
            catch (IOException iOException) {}
        } else {
            try {
                FileUtils.touch((File)f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        scriptsHomeFolder = FileUtils.getFile((File)pluginHomeFolder, (String[])new String[]{appversion});
        return scriptsHomeFolder;
    }

    public void initializaPaths(List<File> pluginsFolder, File installFolder, File pluginHoneFolder, String appversion) {
        File initAddonFile;
        this.appversion = appversion;
        this.pluginHomeFolder = pluginHoneFolder;
        ScriptingManager manager = ScriptingLocator.getManager();
        manager.setHomeFolder(ScriptingUtils.getScriptsHomeFolder(pluginHoneFolder, appversion));
        try {
            ScriptingFolder folder = manager.createLink("Common", manager.getUserFolder(), "../../scripts");
            folder.setProperty(SKIP_AUTORUNS, BooleanUtils.toStringTrueFalse((boolean)true));
            folder.save();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't create Common folder", (Throwable)ex);
        }
        ArrayList<File> pluginsFolders = new ArrayList<File>();
        for (File f : pluginsFolder) {
            pluginsFolders.addAll(Arrays.asList(f.listFiles()));
        }
        for (File pluginFolder : pluginsFolders) {
            File libFolder;
            File scriptsFolder = new File(pluginFolder, "scripting/scripts");
            if (scriptsFolder.exists()) {
                manager.registerSystemFolder(pluginFolder.getName(), scriptsFolder);
            }
            if (!(libFolder = new File(pluginFolder, "scripting/lib")).exists()) continue;
            manager.addLibFolder(libFolder);
        }
        manager.setPackagesFolder(installFolder);
        File localAddonRepositoryFolder = new File(manager.getRootUserFolder(), "addons");
        if (!localAddonRepositoryFolder.exists()) {
            try {
                FileUtils.forceMkdir((File)localAddonRepositoryFolder);
            }
            catch (IOException ex) {
                LOGGER.info("Can't create addons folder in '" + localAddonRepositoryFolder.getAbsolutePath() + "'.", (Throwable)ex);
            }
        }
        if (!(initAddonFile = new File(localAddonRepositoryFolder, "__init__.py")).exists()) {
            try {
                FileUtils.touch((File)initAddonFile);
            }
            catch (IOException ex) {
                LOGGER.info("Can't create addons __init__ file in '" + localAddonRepositoryFolder.getAbsolutePath() + "'.", (Throwable)ex);
            }
        }
    }

    public void runScript(String name, Object[] args) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        String method = null;
        if (name.contains(".")) {
            String[] ss = StringUtils.split((String)name, (char)'.');
            name = ss[0];
            if (StringUtils.isAlphanumeric((CharSequence)ss[1])) {
                method = ss[1];
            } else {
                try {
                    Code.Callable code = (Code.Callable)ExpressionUtils.compile((String)ss[1]);
                    method = code.name();
                    try {
                        code.link();
                        ArrayList<Object> args2 = new ArrayList<Object>();
                        for (Code param : code.parameters()) {
                            args2.add(((Code.Constant)param).value());
                        }
                        if (!CollectionUtils.isEmpty(args2)) {
                            args = args2.toArray(new Object[args2.size()]);
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Can't process command args (" + name + ").", t);
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("Can't process command (" + name + ").", t);
                    method = StringUtils.left((String)ss[1], (int)(this.indexOfNonAlphanumeric(ss[1]) + 1));
                }
            }
        }
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        ScriptingUIManager uimanager = ScriptingSwingLocator.getUIManager();
        ScriptingBaseScript script = uimanager.getManager().getScript(name);
        if (script != null) {
            if (StringUtils.isNotBlank(method) && script instanceof ScriptingScript) {
                try {
                    ((ScriptingScript)script).invokeFunction(method, args);
                }
                catch (NoSuchMethodException ex) {
                    LOGGER.warn("Can't call method '" + method + "' of script '" + name + "'.", (Throwable)ex);
                    dialogs.messageDialog("Can't call method '" + method + "' of script '" + name + "'.", "ScriptLaunch", 0);
                }
            } else {
                script.run(args);
            }
        } else {
            dialogs.messageDialog("Can't locate script '" + name + "'.", "ScriptLaunch", 0);
        }
    }

    public void runLauncher() {
        ScriptingUIManager uimanager = ScriptingSwingLocator.getUIManager();
        WindowManager winmanager = ToolsSwingLocator.getWindowManager();
        winmanager.showWindow(uimanager.createLauncher().asJComponent(), uimanager.getTranslation("Scripting_Launcher"), WindowManager.MODE.TOOL);
    }

    public void runComposer() {
        Boolean composerUseHisWindowManager;
        DynObject preferences;
        PluginsManager pluginsManager = PluginsLocator.getPluginsManager();
        PluginServices plugin = pluginsManager.getPlugin(ScriptingExtension.class);
        if (plugin != null && (preferences = plugin.getPluginProperties()) != null && (composerUseHisWindowManager = (Boolean)preferences.getDynValue("ComposerUseHisWindowManager")) != null && composerUseHisWindowManager.booleanValue()) {
            DefaultWindowManager winmanager = new DefaultWindowManager();
            ScriptingUIManager uimanager = ScriptingSwingLocator.getUIManager();
            uimanager.setWindowManager((WindowManager)winmanager);
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.message.showMessage(i18n.getTranslation("_notice"), i18n.getTranslation("_Initializing_the_scripting_plugin_Xhorizontal_ellipsisX") + "\n" + i18n.getTranslation("_Waiting_to_terminate"), new MessageWait.WaitingCondition(){
            private Thread th = null;

            @Override
            public boolean stopWaiting() {
                if (ScriptingUtils.this.executingAutorunScripts) {
                    return false;
                }
                if (composer_initialized) {
                    return true;
                }
                if (this.th == null) {
                    this.th = new Thread((Runnable)new ExecuteScriptsFromScriptingFolders(null, "scautorun", "scautorun"), "StartupScriptingComposer");
                    this.th.start();
                }
                return false;
            }
        }, new Runnable(){

            @Override
            public void run() {
                ScriptingUtils.this.showScriptingComposer();
            }
        });
    }

    public Runnable getAutorunScriptsOnStartup(List<File> pluginsFolders) {
        return new ExecuteAutorunScriptsOnStartup(pluginsFolders);
    }

    private void showScriptingComposer() {
        ScriptingUIManager uimanager = ScriptingSwingLocator.getUIManager();
        JScriptingComposer composer = uimanager.createComposer();
        uimanager.showWindow(composer.asJComponent(), uimanager.getTranslation("Scripting_Composer"));
    }

    private void checkDataFoldersVersions() {
        ScriptingManager manager = ScriptingLocator.getManager();
        PackageManager versionFactory = ToolsLocator.getPackageManager();
        Version currentVersion = versionFactory.createVersion(this.appversion);
        DefaultFolderSet folders = new DefaultFolderSet();
        folders.add(this.pluginHomeFolder);
        final List dataFoldersFound = manager.searchOldVersions(currentVersion, (FolderSet)folders);
        if (dataFoldersFound == null || dataFoldersFound.isEmpty()) {
            return;
        }
        Runnable askUser = new Runnable(){

            @Override
            public void run() {
                WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
                final DataFoldersRecoverPanel panel = new DataFoldersRecoverPanel(dataFoldersFound);
                final Dialog dialog = winManager.createDialog((JComponent)panel, "Recuperacion de preferencias", null, 3);
                dialog.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (dialog.getAction() == 1) {
                            List<DataFolderFound> toRestore = panel.getSelectedDataFolders();
                            for (DataFolderFound dataFolderFound : dataFoldersFound) {
                                if (toRestore.contains(dataFolderFound)) {
                                    dataFolderFound.restore();
                                    continue;
                                }
                                dataFolderFound.leave();
                            }
                        }
                    }
                });
                dialog.show(WindowManager.MODE.WINDOW);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            askUser.run();
        } else {
            SwingUtilities.invokeLater(askUser);
        }
    }

    private int indexOfNonAlphanumeric(String s) {
        int i;
        if (StringUtils.isBlank((CharSequence)s)) {
            return -1;
        }
        char ch = s.charAt(0);
        if (!Character.isJavaIdentifierStart(ch)) {
            return -1;
        }
        for (i = 0; i < s.length(); ++i) {
            ch = s.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            return i - 1;
        }
        return i - 1;
    }

    private class ExecuteScriptsFromFilesystem
    extends AbstractExecuteScripts {
        public ExecuteScriptsFromFilesystem(List<File> pluginsFolder, String title, String patternName) {
            super(pluginsFolder, title, patternName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            ScriptingUtils.this.executingAutorunScripts = true;
            try {
                final ScriptingManager manager = ScriptingLocator.getManager();
                manager.loadEngines();
                I18nManager i18nManager = ToolsLocator.getI18nManager();
                final ArrayList<ScriptingScript> scripts = new ArrayList<ScriptingScript>();
                ArrayList<File> pluginsFolders = new ArrayList<File>();
                for (File pluginsFolders2 : this.getPluginsFolders()) {
                    for (File pluginFolder : pluginsFolders2.listFiles()) {
                        File f = FileUtils.getFile((File)pluginFolder, (String[])new String[]{"scripting", "scripts"});
                        if (!f.exists()) continue;
                        pluginsFolders.add(f);
                    }
                }
                dialogs.message(i18nManager.getTranslation("_Searching_autorun_scripts_Xhorizontal_ellipsisX"), 1);
                SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes bfa) throws IOException {
                        File file = path.toFile();
                        if (FilenameUtils.wildcardMatch((String)file.getName(), (String)ExecuteScriptsFromFilesystem.this.patternName, (IOCase)IOCase.INSENSITIVE) && file.exists()) {
                            ScriptingScript script = (ScriptingScript)manager.getScript(file);
                            if (script.isEnabled()) {
                                scripts.add(script);
                            } else {
                                LOGGER.info("Skip " + ExecuteScriptsFromFilesystem.this.title + " script '" + file.getAbsolutePath() + "'.");
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                };
                try {
                    EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
                    for (File pluginFolder : pluginsFolders) {
                        Files.walkFileTree(Paths.get(pluginFolder.toURI()), opts, Integer.MAX_VALUE, (FileVisitor<? super Path>)visitor);
                    }
                    Files.walkFileTree(Paths.get(manager.getRootUserFolder().toURI()), opts, Integer.MAX_VALUE, (FileVisitor<? super Path>)visitor);
                    List folders = manager.getAlternativeUserFolders();
                    for (ScriptingFolder folder : folders) {
                        Files.walkFileTree(Paths.get(folder.getFile().toURI()), opts, Integer.MAX_VALUE, (FileVisitor<? super Path>)visitor);
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't execute " + this.title + " in home.", (Throwable)ex);
                }
                this.sortScripts(scripts);
                this.executeScripts(scripts, null);
            }
            finally {
                LOGGER.info("Running " + this.title + " scripts terminated.");
                dialogs.message("", 1);
                ScriptingUtils.this.executingAutorunScripts = false;
            }
            ScriptingUtils.this.checkDataFoldersVersions();
        }
    }

    private abstract class AbstractExecuteScripts
    implements Runnable {
        protected String patternName;
        protected String title;
        private final List<File> pluginsFolders;

        public AbstractExecuteScripts(List<File> pluginsFolders, String title, String patternName) {
            this.pluginsFolders = pluginsFolders == null ? Collections.EMPTY_LIST : pluginsFolders;
            this.patternName = patternName;
            this.title = title;
        }

        protected List<File> getPluginsFolders() {
            return this.pluginsFolders;
        }

        private String getScriptOrderKey(ScriptingBaseScript o) {
            int groupOrder = 500;
            String groupName = "default";
            int scriptOrder = 500;
            String s = o.getProperty("autorun.group.order");
            if (s != null) {
                try {
                    groupOrder = Integer.parseInt(s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((s = o.getProperty("autorun.group.name")) != null) {
                groupName = s;
            }
            if ((s = o.getProperty("autorun.order")) != null) {
                try {
                    scriptOrder = Integer.parseInt(s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String key = MessageFormat.format("{0,number,000000}.{1}.{2,number,000000}", groupOrder, groupName, scriptOrder);
            return key;
        }

        protected void sortScripts(List<ScriptingScript> scripts) {
            Collections.sort(scripts, new Comparator<ScriptingBaseScript>(){

                @Override
                public int compare(ScriptingBaseScript o1, ScriptingBaseScript o2) {
                    return AbstractExecuteScripts.this.getScriptOrderKey(o1).compareToIgnoreCase(AbstractExecuteScripts.this.getScriptOrderKey(o2));
                }
            });
        }

        protected void executeScripts(List<ScriptingScript> scripts, SimpleTaskStatus status) {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            if (scripts != null && !scripts.isEmpty()) {
                LOGGER.info("Scripts to run:");
                for (ScriptingBaseScript scriptingBaseScript : scripts) {
                    try {
                        LOGGER.info(StringUtils.abbreviateMiddle((String)scriptingBaseScript.getFile().getParent(), (String)"...", (int)50) + " (" + this.getScriptOrderKey(scriptingBaseScript) + ", " + scriptingBaseScript.getIsolationGroup() + ")");
                    }
                    catch (Throwable throwable) {
                        LOGGER.info("...Error...");
                    }
                }
                if (status != null) {
                    status.setRangeOfValues(0L, (long)scripts.size());
                }
                int n = 0;
                for (ScriptingBaseScript scriptingBaseScript : scripts) {
                    if (status != null) {
                        status.setCurValue((long)n++);
                    }
                    try {
                        if (StringUtils.equals((CharSequence)"autorun", (CharSequence)this.title)) {
                            LOGGER.info("running '" + scriptingBaseScript.getFile().getParent() + "'.");
                        } else {
                            LOGGER.info("running " + this.title + " '" + scriptingBaseScript.getFile().getAbsolutePath() + "'.");
                        }
                        dialogs.message(i18nManager.getTranslation("_Starting_XnameX", new String[]{scriptingBaseScript.getFile().getParentFile().getName()}), 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        scriptingBaseScript.reload();
                        if (scriptingBaseScript.isEnabled()) {
                            scriptingBaseScript.run();
                            continue;
                        }
                        LOGGER.info("Skip " + this.title + " script '" + scriptingBaseScript.getFile().getAbsolutePath() + "' (" + this.getScriptOrderKey(scriptingBaseScript) + ", " + scriptingBaseScript.getIsolationGroup() + ").");
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't execute " + this.title + " from '" + scriptingBaseScript.getFile().getAbsolutePath() + "'.", (Throwable)ex);
                    }
                }
            }
        }
    }

    public class ExecuteAutorunScriptsOnStartup
    implements Runnable {
        private final List<File> pluginsFolders;

        public ExecuteAutorunScriptsOnStartup(List<File> pluginsFolders) {
            this.pluginsFolders = pluginsFolders;
        }

        @Override
        public void run() {
            try {
                ExecuteScriptsFromFilesystem process = new ExecuteScriptsFromFilesystem(this.pluginsFolders, "autorun", "autorun.inf");
                process.run();
            }
            catch (Throwable t) {
                LOGGER.error("Problems runing autorun scripts", t);
                I18nManager i18n = ToolsLocator.getI18nManager();
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                dialogs.messageDialog(i18n.getTranslation("_There_was_a_problem_starting_the_application_It_is_convenient_that_you_close_it_and_start_it_again"), "gvSIG desktop", 0);
            }
        }
    }

    private class ExecuteScriptsFromScriptingFolders
    extends AbstractExecuteScripts {
        public ExecuteScriptsFromScriptingFolders(List<File> pluginsFolders, String title, String patternName) {
            super(pluginsFolders, title, patternName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Scripts startup");
            status.setIndeterminate();
            status.setAutoremove(true);
            status.add();
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            try {
                LOGGER.info("Searching " + this.title + " scripts...");
                dialogs.message(i18nManager.getTranslation("_Searching_autorun_scripts_Xhorizontal_ellipsisX"), 1);
                ScriptingManager manager = ScriptingLocator.getManager();
                final ArrayList<ScriptingScript> scripts = new ArrayList<ScriptingScript>();
                Visitor visitor = new Visitor(){

                    public void visit(Object o) throws VisitCanceledException, BaseException {
                        ScriptingUnit unit = (ScriptingUnit)o;
                        if (unit instanceof ScriptingScript && FilenameUtils.wildcardMatch((String)unit.getName(), (String)ExecuteScriptsFromScriptingFolders.this.patternName, (IOCase)IOCase.INSENSITIVE)) {
                            ScriptingScript script = (ScriptingScript)unit;
                            if (script.isEnabled()) {
                                scripts.add(script);
                            } else {
                                LOGGER.info("Skip " + ExecuteScriptsFromScriptingFolders.this.title + " script '" + script.getFile().getAbsolutePath() + "'.");
                            }
                        }
                    }
                };
                Predicate<ScriptingUnit> includeFilter = new Predicate<ScriptingUnit>(){

                    @Override
                    public boolean test(ScriptingUnit unit) {
                        if (unit instanceof ScriptingFolder) {
                            return !BooleanUtils.toBoolean((String)unit.getProperty(ScriptingUtils.SKIP_AUTORUNS));
                        }
                        return false;
                    }
                };
                manager.getSystemFolder().accept(visitor, (Predicate)includeFilter);
                manager.getUserFolder().accept(visitor, (Predicate)includeFilter);
                this.sortScripts(scripts);
                this.executeScripts(scripts, status);
            }
            catch (Throwable throwable) {
            }
            finally {
                composer_initialized = true;
                LOGGER.info("Running " + this.title + " scripts terminated.");
                dialogs.message("", 1);
                status.terminate();
            }
        }
    }
}

