/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.accessories.bookmarks;

import com.googlecode.vfsjfilechooser2.accessories.bookmarks.Bookmarks;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.BookmarksDialog;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.TitledURLEntry;
import com.googlecode.vfsjfilechooser2.accessories.connection.Credentials;
import com.googlecode.vfsjfilechooser2.accessories.connection.Protocol;
import com.googlecode.vfsjfilechooser2.filechooser.PopupHandler;
import com.googlecode.vfsjfilechooser2.utils.VFSResources;
import com.googlecode.vfsjfilechooser2.utils.VFSURIParser;
import com.googlecode.vfsjfilechooser2.utils.VFSURIValidator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public final class BookmarksEditorPanel
extends JPanel {
    private JLabel usernameLabel;
    private JLabel passwordLabel;
    private JLabel portLabel;
    private JLabel hostnameLabel;
    private JTextField bookmarkNameTextField;
    private JTextField hostnameTextField;
    private JTextField defaultRemotePathTextField;
    private JTextField usernameTextField;
    private JPasswordField passwordTextField;
    private JFormattedTextField portTextField;
    private boolean isPortTextFieldDirty;
    private JComboBox protocolList;
    private JComponent buttonsPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JComponent centerPanel;
    private Bookmarks bookmarks;
    private int editIndex = -1;
    private BookmarksDialog parentDialog;

    public BookmarksEditorPanel(BookmarksDialog parentDialog, Bookmarks bookmarks) {
        this.parentDialog = parentDialog;
        this.bookmarks = bookmarks;
        this.setLayout(new BorderLayout());
        this.initComponents();
        this.initListeners();
    }

    public Bookmarks getBookmarks() {
        return this.bookmarks;
    }

    public void updateFieds(int editIndex) {
        this.resetFields();
        this.editIndex = editIndex;
        this.setPortTextFieldDirty(true);
        this.updateFields();
    }

    private void updateFields() {
        if (this.editIndex != -1) {
            TitledURLEntry tue = this.bookmarks.getEntry(this.editIndex);
            this.bookmarkNameTextField.setText(tue.getTitle());
            VFSURIValidator v = new VFSURIValidator();
            if (!v.isValid(tue.getURL())) {
                JOptionPane.showMessageDialog(null, VFSResources.getMessage("VFSFileChooser.errBADURI"));
            }
            VFSURIParser parser = new VFSURIParser(tue.getURL(), !this.isPortTextFieldDirty());
            this.protocolList.setSelectedItem((Object)parser.getProtocol());
            if (parser.getProtocol() != Protocol.FILE) {
                this.hostnameTextField.setText(parser.getHostname());
                if (parser.getPortnumber() != null && parser.getPortnumber().length() > 0) {
                    int test_port = -1;
                    try {
                        test_port = Integer.valueOf(parser.getPortnumber());
                        this.portTextField.setValue(test_port);
                    }
                    catch (Exception ex) {
                        this.portTextField.setValue(null);
                    }
                    if (test_port < 0 || test_port > 65535) {
                        this.portTextField.setValue(null);
                    }
                } else {
                    this.portTextField.setValue(null);
                }
                if (parser.getUsername() != null) {
                    this.usernameTextField.setText(parser.getUsername());
                }
                if (parser.getPassword() != null) {
                    this.passwordTextField.setText(parser.getPassword());
                }
            }
            this.defaultRemotePathTextField.setText(parser.getPath());
        }
    }

    private void initComponents() {
        this.initCenterPanelComponents();
        this.initBottomPanelComponents();
        this.add((Component)this.buttonsPanel, "South");
        this.add((Component)this.centerPanel, "Center");
    }

    private void initCenterPanelComponents() {
        this.centerPanel = new JPanel(new GridBagLayout());
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel bookmarkNameLabel = new JLabel(VFSResources.getMessage("VFSJFileChooser.fileNameHeaderText"));
        this.bookmarkNameTextField = new JTextField(25);
        this.hostnameLabel = new JLabel(VFSResources.getMessage("VFSJFileChooser.hostnameLabelText"));
        this.hostnameLabel.setForeground(Color.RED);
        this.hostnameTextField = new JTextField(25);
        this.portLabel = new JLabel(VFSResources.getMessage("VFSJFileChooser.portLabelText"));
        this.portTextField = new JFormattedTextField(NumberFormat.getInstance());
        this.isPortTextFieldDirty = false;
        JLabel protocolLabel = new JLabel(VFSResources.getMessage("VFSJFileChooser.protocolLabelText"));
        DefaultComboBoxModel<Protocol> protocolModel = new DefaultComboBoxModel<Protocol>(Protocol.values());
        this.protocolList = new JComboBox<Protocol>(protocolModel);
        this.protocolList.setRenderer(new ProtocolRenderer());
        this.usernameLabel = new JLabel(VFSResources.getMessage("VFSJFileChooser.usernameLabelText"));
        this.usernameTextField = new JTextField(20);
        this.passwordLabel = new JLabel(VFSResources.getMessage("VFSJFileChooser.passwordLabelText"));
        this.passwordTextField = new JPasswordField(12);
        JLabel defaultRemotePathLabel = new JLabel(VFSResources.getMessage("VFSJFileChooser.pathLabelText"));
        this.defaultRemotePathTextField = new JTextField(20);
        this.makeGridPanel(new Component[]{bookmarkNameLabel, this.bookmarkNameTextField, this.hostnameLabel, this.hostnameTextField, this.portLabel, this.portTextField, protocolLabel, this.protocolList, this.usernameLabel, this.usernameTextField, this.passwordLabel, this.passwordTextField, defaultRemotePathLabel, this.defaultRemotePathTextField});
        PopupHandler.installDefaultMouseListener(this.bookmarkNameTextField);
        PopupHandler.installDefaultMouseListener(this.hostnameTextField);
        PopupHandler.installDefaultMouseListener(this.portTextField);
        PopupHandler.installDefaultMouseListener(this.usernameTextField);
        PopupHandler.installDefaultMouseListener(this.passwordTextField);
        PopupHandler.installDefaultMouseListener(this.defaultRemotePathTextField);
    }

    private void makeGridPanel(Component[] components) {
        Insets insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        int i = 0;
        int j = 0;
        for (Component component : components) {
            gbc.gridx = i++;
            gbc.gridy = j++;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            this.centerPanel.add(component, gbc);
            if (i % 2 != 0) continue;
            i = 0;
        }
    }

    private void initListeners() {
        this.portTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                    BookmarksEditorPanel.this.getToolkit().beep();
                    e.consume();
                } else {
                    BookmarksEditorPanel.this.setPortTextFieldDirty(true);
                }
            }
        });
        this.portTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JFormattedTextField f = (JFormattedTextField)e.getSource();
                String text = f.getText();
                if (text.length() == 0) {
                    f.setValue(null);
                }
                try {
                    f.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarksEditorPanel.this.parentDialog.restoreDefaultView();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Credentials.Builder credentialsBuilder;
                Credentials credentials;
                String uri;
                VFSURIValidator v;
                String bookmarkName = BookmarksEditorPanel.this.bookmarkNameTextField.getText();
                StringBuilder errors = new StringBuilder();
                if ("".equals(bookmarkName.trim())) {
                    errors.append(VFSResources.getMessage("VFSJFileChooser.errorBookmarknameRequired")).append("\n");
                }
                String m_username = BookmarksEditorPanel.this.usernameTextField.getText();
                String m_defaultRemotePath = BookmarksEditorPanel.this.defaultRemotePathTextField.getText();
                if (!m_defaultRemotePath.startsWith("/")) {
                    m_defaultRemotePath = "/" + m_defaultRemotePath;
                }
                char[] m_password = BookmarksEditorPanel.this.passwordTextField.getPassword();
                String m_hostname = BookmarksEditorPanel.this.hostnameTextField.getText();
                String m_protocol = BookmarksEditorPanel.this.protocolList.getSelectedItem().toString().toLowerCase();
                if (!"file".equals(m_protocol) && "".equals(m_hostname.trim())) {
                    errors.append(VFSResources.getMessage("VFSJFileChooser.errorHostnameRequired")).append("\n");
                }
                if (m_username.equals("") && !m_password.equals("")) {
                    errors.append(VFSResources.getMessage("VFSJFileChooser.errorUsernameRequired")).append("\n");
                }
                if (errors.length() > 0) {
                    JOptionPane.showMessageDialog(BookmarksEditorPanel.this.parentDialog, errors.toString(), VFSResources.getMessage("VFSJFileChooser.errorLabel"), 0);
                    return;
                }
                int m_port = -1;
                if (BookmarksEditorPanel.this.portTextField.isEditValid() && BookmarksEditorPanel.this.portTextField.getValue() != null) {
                    String s = BookmarksEditorPanel.this.portTextField.getValue().toString();
                    try {
                        m_port = Integer.valueOf(s);
                    }
                    catch (Exception ex) {
                        m_port = -1;
                        BookmarksEditorPanel.this.portTextField.setValue(null);
                        s = "";
                    }
                    if (m_port < 0 || m_port > 65535) {
                        m_port = -1;
                        BookmarksEditorPanel.this.portTextField.setValue(null);
                        s = "";
                    }
                }
                if (!(v = new VFSURIValidator()).isValid(uri = (credentials = (credentialsBuilder = Credentials.newBuilder(m_hostname).defaultRemotePath(m_defaultRemotePath).username(m_username).password(m_password).protocol(m_protocol).port(m_port)).build()).toFileObjectURL())) {
                    JOptionPane.showMessageDialog(null, VFSResources.getMessage("VFSFileChooser.errBADURI"));
                }
                if (BookmarksEditorPanel.this.editIndex == -1) {
                    BookmarksEditorPanel.this.bookmarks.add(new TitledURLEntry(bookmarkName, uri));
                } else {
                    BookmarksEditorPanel.this.bookmarks.setValueAt(bookmarkName, BookmarksEditorPanel.this.editIndex, 0);
                    BookmarksEditorPanel.this.bookmarks.setValueAt(uri, BookmarksEditorPanel.this.editIndex, 1);
                }
                BookmarksEditorPanel.this.bookmarks.save();
                BookmarksEditorPanel.this.parentDialog.restoreDefaultView();
            }
        });
        this.protocolList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    BookmarksEditorPanel.this.selectPortNumber();
                }
            }
        });
        this.protocolList.setSelectedItem((Object)Protocol.FTP);
    }

    private void selectPortNumber() {
        Protocol protocol = (Protocol)((Object)this.protocolList.getSelectedItem());
        if (protocol.toString().equals("FILE")) {
            this.enableFields(false);
            this.isPortTextFieldDirty = false;
            return;
        }
        this.enableFields(true);
        if (this.isPortTextFieldDirty() && this.portTextField.isEditValid()) {
            return;
        }
        this.portTextField.setValue(protocol.getPort());
    }

    private void setPortTextFieldDirty(boolean b) {
        this.isPortTextFieldDirty = b;
    }

    private boolean isPortTextFieldDirty() {
        return this.isPortTextFieldDirty;
    }

    private void enableFields(boolean b) {
        Component[] components;
        for (Component component : components = new Component[]{this.hostnameLabel, this.hostnameTextField, this.usernameLabel, this.usernameTextField, this.passwordLabel, this.passwordTextField, this.portLabel, this.portTextField}) {
            component.setVisible(b);
        }
    }

    private void resetFields() {
        this.isPortTextFieldDirty = false;
        this.bookmarkNameTextField.setText("");
        this.hostnameTextField.setText("");
        this.protocolList.setSelectedItem((Object)Protocol.FTP);
        this.usernameTextField.setText("");
        this.passwordTextField.setText("");
        this.defaultRemotePathTextField.setText("");
    }

    private void initBottomPanelComponents() {
        this.buttonsPanel = new JPanel(new FlowLayout(1));
        this.cancelButton = new JButton(VFSResources.getMessage("VFSJFileChooser.cancelButtonText"));
        this.okButton = new JButton(VFSResources.getMessage("VFSJFileChooser.okButtonText"));
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.cancelButton);
    }

    private static class ProtocolRenderer
    extends BasicComboBoxRenderer {
        private ProtocolRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    Protocol aProtocol = (Protocol)((Object)value);
                    list.setToolTipText(aProtocol.getDescription());
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

