/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.resource.ResourceParameters;
import org.gvsig.fmap.dal.resource.db.AbstractDBResourceNoBlocker;
import org.gvsig.fmap.dal.resource.db.AbstractDBResourceParameters;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.exception.ResourceException;
import org.gvsig.fmap.dal.store.jdbc.JDBCResource;
import org.gvsig.fmap.dal.store.jdbc.JDBCResourceParametersBase;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCDriverClassNotFoundException;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCResourceBase
extends AbstractDBResourceNoBlocker
implements JDBCResource {
    private static final Logger logger = LoggerFactory.getLogger(JDBCResourceBase.class);
    public static final String NAME = "JDBCResource";
    public static final String DESCRIPTION = "JDBC Connection";
    protected DataSource dataSource = null;

    public JDBCResourceBase(JDBCResourceParametersBase parameters) throws InitializeException {
        super((AbstractDBResourceParameters)parameters);
        this.registerJDBCDriver();
    }

    protected void registerJDBCDriver() throws InitializeException {
        String className = this.getParameters().getJDBCDriverClassName();
        if (className == null) {
            return;
        }
        try {
            Class<?> theClass = Class.forName(className);
            if (theClass == null) {
                throw new JDBCDriverClassNotFoundException(this.getName(), className);
            }
        }
        catch (Exception e) {
            throw new InitializeException((Throwable)e);
        }
    }

    protected DataSource createDataSource() {
        JDBCResourceParametersBase jdbcParams = this.getParameters();
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(jdbcParams.getJDBCDriverClassName());
        dataSource.setUsername(jdbcParams.getUser());
        dataSource.setPassword(jdbcParams.getPassword());
        dataSource.setUrl(jdbcParams.getUrl());
        dataSource.setMaxWait(60000L);
        return dataSource;
    }

    public JDBCResourceParametersBase getParameters() {
        return (JDBCResourceParametersBase)super.getParameters();
    }

    public String getName() throws AccessResourceException {
        JDBCResourceParametersBase params = this.getParameters();
        return MessageFormat.format("JDBCResource({0},{1},{2},{3},{4})", params.getJDBCDriverClassName(), params.getHost(), params.getPort(), params.getUser(), params.getDBName());
    }

    public Connection getJDBCConnection() throws AccessResourceException {
        return (Connection)this.get();
    }

    public void closeConnection(Connection connection) {
        try {
            logger.trace("before-close connection" + this.getStatusInformation());
            connection.close();
            logger.trace("after close connection " + this.getStatusInformation());
        }
        catch (Exception ex) {
            logger.warn("Problems closing connection.", (Throwable)ex);
        }
    }

    protected void debugPoolStatus(String src) {
        if (logger.isTraceEnabled()) {
            logger.trace(src + "  " + this.getStatusInformation());
        }
    }

    public String getStatusInformation() {
        if (!(this.dataSource instanceof BasicDataSource)) {
            return "Connected: " + this.isConnected();
        }
        BasicDataSource ds = (BasicDataSource)this.dataSource;
        String s = MessageFormat.format("Conneted {0}, actives {1}/{2}, idle {3}/{4}", this.isConnected(), ds.getNumActive(), ds.getMaxActive(), ds.getNumIdle(), ds.getMaxIdle());
        return s;
    }

    protected synchronized Object getTheConnection() throws DataException {
        try {
            Connection conn = this.dataSource.getConnection();
            this.debugPoolStatus("getTheConnection");
            return conn;
        }
        catch (SQLException e) {
            throw new JDBCSQLException(e);
        }
    }

    public boolean isThis(ResourceParameters parameters) throws ResourceException {
        String myDriver;
        String myDbName;
        if (!super.isThis(parameters)) {
            return false;
        }
        JDBCResourceParametersBase params = (JDBCResourceParametersBase)parameters;
        String dbName = params.getDBName();
        if (!StringUtils.equals((CharSequence)dbName, (CharSequence)(myDbName = this.getParameters().getDBName()))) {
            return false;
        }
        String driver = params.getJDBCDriverClassName();
        return StringUtils.equals((CharSequence)driver, (CharSequence)(myDriver = this.getParameters().getJDBCDriverClassName()));
    }

    public boolean isConnected() {
        if (this.dataSource == null) {
            return false;
        }
        if (this.dataSource instanceof BasicDataSource) {
            return ((BasicDataSource)this.dataSource).getNumActive() > 0 || ((BasicDataSource)this.dataSource).getNumIdle() > 0;
        }
        return true;
    }

    protected void connectToDB() throws DataException {
        if (this.dataSource != null) {
            return;
        }
        this.dataSource = this.createDataSource();
    }

    public void beginUse() {
        this.executeBegins();
    }

    public void endUse() {
        this.executeEnds();
    }
}

