/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi;

import java.io.File;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.iterators.ReverseListIterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilderHelper;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.SupportTransactionsHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.SQLBuilderBase;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.spi.DataTransactionServices;
import org.gvsig.fmap.dal.store.db.DBHelper;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParametersBase;
import org.gvsig.fmap.dal.store.jdbc.JDBCResourceBase;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParametersBase;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParametersBase;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCCantFetchValueException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc2.JDBCStoreProvider;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.ResulSetControler;
import org.gvsig.fmap.dal.store.jdbc2.impl.ResulSetControlerBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.ConnectionProvider;
import org.gvsig.fmap.dal.store.jdbc2.spi.FakeConnectionProvider;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCServerExplorerBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCStoreProviderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.SRSSolver;
import org.gvsig.fmap.dal.store.jdbc2.spi.SRSSolverDumb;
import org.gvsig.fmap.dal.store.jdbc2.spi.expressionbuilder.formatters.ComputedAttribute;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.OperationsFactoryBase;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.exception.NotYetImplemented;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.util.ContainerUtils;
import org.gvsig.tools.visitor.FilteredVisitable;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCHelperBase
extends AbstractDisposable
implements ResourceConsumer,
JDBCHelper {
    private static final boolean ALLOW_AUTOMATIC_VALUES = true;
    private static final String QUOTE_FOR_USE_IN_IDENTIFIERS = "\"";
    private static final String QUOTE_FOR_USE_IN_STRINGS = "'";
    protected static final Logger LOGGER = LoggerFactory.getLogger(JDBCHelperBase.class);
    private ResulSetControler resulSetControler = null;
    private ResourceConsumer helperClient = null;
    private GeometryManager geometryManager = null;
    private JDBCConnectionParameters connectionParameters;
    private JDBCStoreProvider store;
    protected OperationsFactory operationsFactory = null;
    protected SRSSolver srssolver;
    protected FeatureType providerFeatureType = null;
    protected SupportTransactionsHelper transactionsHelper;

    public JDBCHelperBase(JDBCConnectionParameters connectionParameters) {
        if (connectionParameters == null) {
            throw new IllegalArgumentException("Connection parameters can't be null.");
        }
        this.connectionParameters = connectionParameters;
        this.transactionsHelper = new SupportTransactionsHelper();
        this.srssolver = new SRSSolverDumb(this);
    }

    protected void initialize(ResourceConsumer helperClient, JDBCConnectionParameters connectionParameters, JDBCStoreProvider store) {
        this.store = store;
        this.helperClient = helperClient;
        this.connectionParameters = connectionParameters;
        this.initializeResource(connectionParameters);
    }

    protected String getResourceType() {
        return "JDBCResource";
    }

    @Override
    public String getProviderName() {
        return "JDBC2";
    }

    @Override
    public GeometryExpressionBuilderHelper.GeometrySupportType getGeometrySupportType() {
        return GeometryExpressionBuilderHelper.GeometrySupportType.WKT;
    }

    @Override
    public FeatureType getProviderFeatureType() {
        return this.providerFeatureType;
    }

    @Override
    public void setProviderFeatureType(FeatureType providerFeatureType) {
        this.providerFeatureType = providerFeatureType;
    }

    @Override
    public boolean hasSpatialFunctions() {
        return false;
    }

    @Override
    public boolean allowNestedOperations() {
        return false;
    }

    @Override
    public boolean canWriteGeometry(int geometryType, int geometrySubtype) {
        return true;
    }

    @Override
    public JDBCSQLBuilderBase createSQLBuilder() {
        return new JDBCSQLBuilderBase(this);
    }

    @Override
    public String getQuoteForIdentifiers() {
        return QUOTE_FOR_USE_IN_IDENTIFIERS;
    }

    @Override
    public boolean allowAutomaticValues() {
        return true;
    }

    @Override
    public boolean supportOffsetInSelect() {
        return true;
    }

    @Override
    public String getQuoteForStrings() {
        return QUOTE_FOR_USE_IN_STRINGS;
    }

    protected boolean supportCaller(Code.Callable caller, FeatureType type) {
        if (StringUtils.equalsIgnoreCase((CharSequence)caller.name(), (CharSequence)"FOREING_VALUE") || StringUtils.equalsIgnoreCase((CharSequence)caller.name(), (CharSequence)"FOREIGN_VALUE")) {
            ForeingKey foreignKey = this.getForeignKey(caller, type);
            if (foreignKey == null) {
                return false;
            }
            return foreignKey.canBeOptimizedByProvider();
        }
        Function function = caller.function();
        if (function == null) {
            return false;
        }
        if (!function.isSQLCompatible()) {
            return false;
        }
        return this.hasSpatialFunctions() || !StringUtils.equalsIgnoreCase((CharSequence)function.group(), (CharSequence)"OGC");
    }

    @Override
    public boolean supportFilter(FeatureType type, Evaluator filter) {
        if (filter == null) {
            return true;
        }
        String sql = filter.getSQL();
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return false;
        }
        return this.supportExpression(type, sql);
    }

    @Override
    public boolean supportExpression(final FeatureType type, final String sql) {
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return false;
        }
        final MutableBoolean isCompatible = new MutableBoolean(true);
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        Code code = manager.compile(sql);
        MutableSymbolTable symbolTable = manager.createSymbolTable();
        code.link((SymbolTable)symbolTable);
        try {
            code.accept(new Visitor(){

                public void visit(Object code_obj) throws VisitCanceledException, BaseException {
                    Code code1 = (Code)code_obj;
                    switch (code1.code()) {
                        case 2: {
                            Code.Callable caller = (Code.Callable)code1;
                            if (JDBCHelperBase.this.supportCaller(caller, type)) break;
                            isCompatible.setValue(false);
                            LOGGER.debug("Expression not SQL compatible, use '" + caller.name() + "' (" + sql + ").");
                            throw new VisitCanceledException();
                        }
                        case 3: {
                            isCompatible.setValue(false);
                            LOGGER.debug("Expression not SQL compatible, use objects methods (" + sql + ").");
                            throw new VisitCanceledException();
                        }
                        case 1: {
                            FeatureAttributeDescriptor attrdesc;
                            Code.Identifier identifier = (Code.Identifier)code1;
                            if (type == null || (attrdesc = type.getAttributeDescriptor(identifier.name())) == null || !attrdesc.isComputed()) break;
                            FeatureAttributeEmulator emulator = attrdesc.getFeatureAttributeEmulator();
                            if (!(emulator instanceof FeatureAttributeEmulatorExpression)) {
                                LOGGER.debug("Expression not SQL compatible, use calculated field '" + attrdesc.getName() + "' (" + sql + ").");
                                isCompatible.setValue(false);
                                throw new VisitCanceledException();
                            }
                            Expression expr = ((FeatureAttributeEmulatorExpression)emulator).getExpression();
                            if (JDBCHelperBase.this.supportExpression(type, expr.getPhrase())) break;
                            LOGGER.debug("Expression not SQL compatible, use calculated field '" + attrdesc.getName() + "' (" + expr.getPhrase() + "/" + sql + ").");
                            isCompatible.setValue(false);
                            throw new VisitCanceledException();
                        }
                    }
                }
            }, (Predicate)new Predicate<FilteredVisitable>(){

                @Override
                public boolean test(FilteredVisitable code0) {
                    if (code0 instanceof Code.Callable) {
                        String name = ((Code.Callable)code0).name();
                        return StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"$CONSTANT") || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"$IDENTIFIER");
                    }
                    return false;
                }
            });
        }
        catch (VisitCanceledException visitCanceledException) {
        }
        catch (Exception ex) {
            LOGGER.warn("Can't calculate if is SQL compatible.", (Throwable)ex);
        }
        return isCompatible.booleanValue();
    }

    @Override
    public boolean supportOrder(FeatureType type, FeatureQueryOrder order) {
        if (this.useSubquery()) {
            return false;
        }
        if (order == null) {
            return true;
        }
        for (FeatureQueryOrder.FeatureQueryOrderMember member : order.members()) {
            if (!member.hasEvaluator() || this.supportFilter(type, member.getEvaluator())) continue;
            return false;
        }
        return true;
    }

    @Override
    public OperationsFactory getOperations() {
        if (this.operationsFactory == null && !this.isClosed()) {
            this.operationsFactory = new OperationsFactoryBase(this);
        }
        return this.operationsFactory;
    }

    protected void initializeResource(JDBCConnectionParameters params) {
    }

    @Override
    public String getSourceId() {
        return this.store.getSourceId();
    }

    public JDBCResourceBase getResource() {
        return null;
    }

    @Override
    public JDBCConnection getConnection() throws AccessResourceException {
        throw new NotYetImplemented();
    }

    @Override
    public JDBCConnection getConnectionWritable() throws AccessResourceException {
        return this.getConnection();
    }

    @Override
    public String getConnectionURL() {
        return null;
    }

    @Override
    public JDBCConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    protected void doDispose() throws BaseException {
        JDBCUtils.closeQuietly(this);
    }

    @Override
    public void close() throws Exception {
        JDBCUtils.closeQuietly(this.resulSetControler);
        this.resulSetControler = null;
        this.operationsFactory = null;
        this.srssolver = null;
        this.connectionParameters = null;
        this.helperClient = null;
        this.geometryManager = null;
        this.providerFeatureType = null;
        this.store = null;
        this.transactionsHelper.setTransaction(null);
    }

    public boolean isClosed() {
        return this.srssolver == null;
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return this.helperClient.closeResourceRequested(resource);
    }

    public void resourceChanged(ResourceProvider resource) {
        this.helperClient.resourceChanged(resource);
    }

    @Override
    public GeometryManager getGeometryManager() {
        if (this.geometryManager == null) {
            this.geometryManager = GeometryLocator.getGeometryManager();
        }
        return this.geometryManager;
    }

    @Override
    public ResulSetControler getResulSetControler() {
        if (this.resulSetControler == null) {
            this.resulSetControler = new ResulSetControlerBase(this);
        }
        return this.resulSetControler;
    }

    @Override
    public void fetchFeature(FeatureProvider feature, ResulSetControler.ResultSetEntry rs) throws DataException {
        this.fetchFeature(feature, rs.get(), rs.getColumns(), rs.getExtraValueNames());
    }

    @Override
    public void fetchFeature(FeatureProvider feature, ResultSet rs, FeatureAttributeDescriptor[] columns, String[] extraValueNames) throws DataException {
        try {
            Object value;
            int rsIndex = 1;
            for (FeatureAttributeDescriptor column : columns) {
                switch (column.getType()) {
                    case 66: {
                        value = this.getGeometryFromColumn(rs, rsIndex++);
                        if (value == null) break;
                        ((Geometry)value).setProjection(column.getSRS());
                        break;
                    }
                    default: {
                        value = rs.getObject(rsIndex++);
                        if (value instanceof Blob) {
                            Blob blob = (Blob)value;
                            value = blob.getBytes(1L, (int)blob.length());
                            blob.free();
                            break;
                        }
                        if (!(value instanceof Clob)) break;
                        Clob clob = (Clob)value;
                        value = new String(IOUtils.toCharArray((Reader)clob.getCharacterStream()));
                        clob.free();
                    }
                }
                feature.set(column.getIndex(), value);
            }
            if (ArrayUtils.isNotEmpty((Object[])extraValueNames)) {
                feature.setExtraValueNames(extraValueNames);
                for (int index = 0; index < extraValueNames.length; ++index) {
                    if ((value = rs.getObject(rsIndex++)) instanceof Blob) {
                        Blob blob = (Blob)value;
                        value = blob.getBytes(0L, (int)blob.length());
                        blob.free();
                    }
                    feature.setExtraValue(index, value);
                }
            }
        }
        catch (Exception ex) {
            throw new JDBCCantFetchValueException(ex);
        }
    }

    @Override
    public Geometry getGeometryFromColumn(ResulSetControler.ResultSetEntry rs, int index) throws DataException {
        return this.getGeometryFromColumn(rs.get(), index);
    }

    @Override
    public Geometry getGeometryFromColumn(ResultSet rs, int index) throws DataException {
        try {
            switch (this.getGeometrySupportType()) {
                case WKB: {
                    byte[] value = rs.getBytes(index);
                    if (value == null) {
                        return null;
                    }
                    Geometry geom = this.getGeometryManager().createFrom(value);
                    if (geom == null) {
                        LOGGER.debug("Can't get geometry from bytes of column " + index);
                    }
                    return geom;
                }
                case NATIVE: 
                case EWKB: {
                    byte[] value = rs.getBytes(index);
                    if (value == null) {
                        return null;
                    }
                    Geometry geom = this.getGeometryManager().createFrom(value);
                    if (geom == null) {
                        LOGGER.debug("Can't get geometry from bytes of column " + index);
                    }
                    return geom;
                }
            }
            String value = rs.getString(index);
            if (value == null) {
                return null;
            }
            Geometry geom = this.getGeometryManager().createFrom(value);
            if (geom == null) {
                LOGGER.debug("Can't get geometry from bytes of column " + index);
            }
            return geom;
        }
        catch (Exception ex) {
            throw new JDBCCantFetchValueException(ex);
        }
    }

    @Override
    public FeatureProvider createFeature(FeatureType featureType) throws DataException {
        return this.store.getStoreServices().createDefaultFeatureProvider(featureType);
    }

    private FeatureType getFeatureType() {
        if (this.store == null) {
            return null;
        }
        FeatureStore featureStore = this.store.getFeatureStore();
        if (featureStore == null) {
            return null;
        }
        return featureStore.getDefaultFeatureTypeQuietly();
    }

    @Override
    public boolean useSubquery() {
        if (this.store == null) {
            return false;
        }
        return !StringUtils.isEmpty((CharSequence)this.store.getParameters().getSQL());
    }

    @Override
    public SRSSolver getSRSSolver() {
        return this.srssolver;
    }

    @Override
    public JDBCStoreProvider createProvider(JDBCStoreParameters parameters, DataStoreProviderServices providerServices) throws InitializeException {
        JDBCStoreProviderBase theStore = new JDBCStoreProviderBase(parameters, providerServices, DBHelper.newMetadataContainer((String)"JDBC2"), this);
        this.initialize(theStore, (JDBCConnectionParameters)parameters, theStore);
        return theStore;
    }

    @Override
    public JDBCServerExplorer createServerExplorer(JDBCServerExplorerParameters parameters, DataServerExplorerProviderServices providerServices) throws InitializeException {
        JDBCServerExplorerBase explorer = new JDBCServerExplorerBase(parameters, providerServices, this);
        this.initialize((ResourceConsumer)explorer, (JDBCConnectionParameters)parameters, null);
        return explorer;
    }

    @Override
    public JDBCNewStoreParameters createNewStoreParameters() {
        return new JDBCNewStoreParametersBase();
    }

    @Override
    public JDBCStoreParameters createOpenStoreParameters() {
        return new JDBCStoreParametersBase();
    }

    @Override
    public JDBCStoreParameters createOpenStoreParameters(JDBCServerExplorerParameters parameters) {
        JDBCStoreParameters params = this.createOpenStoreParameters();
        params.setHost(parameters.getHost());
        params.setPort(parameters.getPort());
        params.setDBName(parameters.getDBName());
        params.setUser(parameters.getUser());
        params.setPassword(parameters.getPassword());
        params.setCatalog(parameters.getCatalog());
        params.setSchema(parameters.getSchema());
        params.setJDBCDriverClassName(parameters.getJDBCDriverClassName());
        params.setUrl(parameters.getUrl());
        if (parameters instanceof FilesystemStoreParameters) {
            File f = ((FilesystemStoreParameters)parameters).getFile();
            ((FilesystemStoreParameters)params).setFile(f);
        }
        params.setBatchSize(parameters.getBatchSize());
        return params;
    }

    @Override
    public JDBCServerExplorerParameters createServerExplorerParameters() {
        return new JDBCServerExplorerParametersBase();
    }

    @Override
    public String getSourceId(JDBCStoreParameters params) {
        StringBuilder builder = new StringBuilder();
        builder.append(params.getTable());
        builder.append("(");
        boolean needComma = false;
        if (StringUtils.isNotBlank((CharSequence)params.getHost())) {
            builder.append("host=");
            builder.append(params.getHost());
            needComma = true;
        }
        if (params.getPort() > 0) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("port=");
            builder.append(params.getPort());
            needComma = true;
        }
        if (StringUtils.isNotBlank((CharSequence)params.getDBName())) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("db=");
            builder.append(params.getDBName());
            needComma = true;
        }
        if (StringUtils.isNotBlank((CharSequence)params.getSchema())) {
            if (needComma) {
                builder.append(", ");
            }
            builder.append("schema=");
            builder.append(params.getSchema());
            needComma = true;
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public void processSpecialFunctions(SQLBuilder sqlbuilder, FeatureType type, List<String> extra_column_names, FeatureQuery query) {
        this.replaceForeingValueFunction(sqlbuilder, type, extra_column_names);
        this.replaceExistsFunction(sqlbuilder, type, extra_column_names);
        this.addTableToColumnReferences(sqlbuilder, type, query);
    }

    protected void replaceExistsFunction(final SQLBuilder sqlbuilder, FeatureType type, final List<String> extra_column_names) {
        final SQLBuilder.SelectBuilder select = sqlbuilder.select();
        GeometryExpressionBuilder where = select.where();
        if (where == null || where.isEmpty() || select.has_group_by() || select.has_aggregate_functions()) {
            return;
        }
        ArrayList value_replacements = new ArrayList();
        where.accept(new ExpressionBuilder.Visitor(){

            public void visit(ExpressionBuilder.Visitable value) {
                if (!(value instanceof ExpressionBuilder.Function)) {
                    return;
                }
                ExpressionBuilder.Function function = (ExpressionBuilder.Function)value;
                if (!StringUtils.equalsIgnoreCase((CharSequence)function.name(), (CharSequence)"EXISTS")) {
                    return;
                }
                if (function.parameters().size() != 2) {
                    return;
                }
                ExpressionBuilder.Value arg0 = (ExpressionBuilder.Value)function.parameters().get(0);
                ExpressionBuilder.Value arg1 = (ExpressionBuilder.Value)function.parameters().get(1);
                if (arg1 == null) {
                    return;
                }
                String columnName = (String)((ExpressionBuilder.Constant)arg1).value();
                SQLBuilder.SelectColumnBuilder column = select.column();
                column.value((ExpressionBuilder.Value)sqlbuilder.expression().function("EXISTS", new ExpressionBuilder.Value[]{arg0}));
                column.as(columnName);
                if (extra_column_names != null) {
                    extra_column_names.add(columnName);
                }
            }
        }, null);
        if (value_replacements.isEmpty()) {
            return;
        }
        for (ExpressionBuilder.Value[] replaceValue : value_replacements) {
            ExpressionBuilder.Value target = replaceValue[0];
            ExpressionBuilder.Value replacement = replaceValue[1];
            sqlbuilder.select().replace(target, replacement);
        }
    }

    private ForeingKey getForeignKey(Code.Callable caller, FeatureType type) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)caller.name(), (CharSequence)"FOREIGN_VALUE") && !StringUtils.equalsIgnoreCase((CharSequence)caller.name(), (CharSequence)"FOREING_VALUE")) {
            return null;
        }
        if (caller.parameters().size() != 1) {
            return null;
        }
        Code arg = (Code)caller.parameters().get(0);
        if (!(arg instanceof Code.Constant)) {
            return null;
        }
        Object arg_value = ((Code.Constant)arg).value();
        if (!(arg_value instanceof CharSequence)) {
            return null;
        }
        String foreing_value_arg = arg_value.toString();
        return this.getForeignKey_Pass2(type, foreing_value_arg);
    }

    private ForeingKey getForeignKey(ExpressionBuilder.Function function, FeatureType type) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)function.name(), (CharSequence)"FOREIGN_VALUE") && !StringUtils.equalsIgnoreCase((CharSequence)function.name(), (CharSequence)"FOREING_VALUE")) {
            return null;
        }
        if (function.parameters().size() != 1) {
            return null;
        }
        ExpressionBuilder.Value arg = (ExpressionBuilder.Value)function.parameters().get(0);
        if (!(arg instanceof ExpressionBuilder.Constant)) {
            return null;
        }
        Object arg_value = ((ExpressionBuilder.Constant)arg).value();
        if (!(arg_value instanceof CharSequence)) {
            return null;
        }
        String foreing_value_arg = arg_value.toString();
        return this.getForeignKey_Pass2(type, foreing_value_arg);
    }

    private ForeingKey getForeignKey_Pass2(FeatureType type, String foreing_value_arg) {
        String[] foreingNameParts = StringUtils.split((String)foreing_value_arg, (String)"[.]");
        if (foreingNameParts.length != 2) {
            return null;
        }
        String columnNameLocal = foreingNameParts[0];
        String columnNameForeing = foreingNameParts[1];
        FeatureAttributeDescriptor attr = type.getAttributeDescriptor(columnNameLocal);
        if (attr == null) {
            FeatureType ft = this.getFeatureType();
            if (ft == null) {
                throw new RuntimeException("Cannot find in feature type attribute:" + columnNameLocal);
            }
            attr = ft.getAttributeDescriptor(columnNameLocal);
            if (attr == null) {
                throw new RuntimeException("Cannot find in feature type attribute:" + columnNameLocal);
            }
        }
        if (!attr.isForeingKey()) {
            return null;
        }
        ForeingKey foreingKey = attr.getForeingKey();
        String foreignTableName = foreingKey.getTableName();
        DataManager dataManager = DALLocator.getDataManager();
        StoresRepository storesRepository = dataManager.getStoresRepository();
        DataStoreParameters foreignParams = (DataStoreParameters)storesRepository.get((Object)foreignTableName);
        FeatureStore myStore = type.getStore();
        if (myStore == null) {
            return foreingKey;
        }
        if (!myStore.getParameters().isTheSameExplorer(foreignParams)) {
            return null;
        }
        return foreingKey;
    }

    protected void replaceForeingValueFunction(final SQLBuilder sqlbuilder, final FeatureType type, List<String> extra_column_names) {
        try {
            GeometryExpressionBuilder where = sqlbuilder.select().where();
            final SQLBuilder.TableNameBuilder table = sqlbuilder.select().from().table();
            GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
            final List<Object> foreing_value_args = extra_column_names == null || sqlbuilder.select().has_group_by() || sqlbuilder.select().has_aggregate_functions() ? new ArrayList() : extra_column_names;
            final ArrayList<ExpressionBuilder.Value[]> value_replacements = new ArrayList<ExpressionBuilder.Value[]>();
            final MutableObject hasForeignValueFunctions = new MutableObject((Object)false);
            sqlbuilder.select().accept(new ExpressionBuilder.Visitor(){

                public void visit(ExpressionBuilder.Visitable value) {
                    ExpressionBuilder.Constant value_replacement;
                    if (!(value instanceof ExpressionBuilder.Function)) {
                        return;
                    }
                    ExpressionBuilder.Function function = (ExpressionBuilder.Function)value;
                    hasForeignValueFunctions.setValue((Object)true);
                    ForeingKey foreingKey = JDBCHelperBase.this.getForeignKey(function, type);
                    if (foreingKey == null) {
                        return;
                    }
                    ExpressionBuilder.Value arg = (ExpressionBuilder.Value)function.parameters().get(0);
                    String foreing_value_arg = Objects.toString(((ExpressionBuilder.Constant)arg).value(), null);
                    String columnNameForeing = StringUtils.split((String)foreing_value_arg, (String)"[.]")[1];
                    if (foreingKey.canBeOptimizedByProvider()) {
                        SQLBuilder.TableNameBuilder foreingTable = sqlbuilder.createTableNameBuilder().database(table.getDatabase()).schema(table.getSchema()).name(foreingKey.getTableName());
                        value_replacement = sqlbuilder.column(foreingTable, columnNameForeing);
                        if (!foreing_value_args.contains(foreing_value_arg)) {
                            foreing_value_args.add(foreing_value_arg);
                        }
                    } else {
                        value_replacement = sqlbuilder.expression().constant(null);
                    }
                    value_replacements.add(new ExpressionBuilder.Value[]{function, value_replacement});
                }
            }, null);
            if (!((Boolean)hasForeignValueFunctions.getValue()).booleanValue() || foreing_value_args.isEmpty()) {
                return;
            }
            for (ExpressionBuilder.Variable variable : sqlbuilder.variables()) {
                if (variable == null || variable instanceof SQLBuilderBase.ColumnBase || ContainerUtils.contains(extra_column_names, (Object)variable.name(), (Comparator)ContainerUtils.EQUALS_IGNORECASE_COMPARATOR)) continue;
                boolean bl = false;
                for (String string : foreing_value_args) {
                    String[] foreingNameParts = string.split("[.]");
                    if (foreingNameParts.length != 2) continue;
                    String columnNameLocal = foreingNameParts[0];
                    String columnNameForeing = foreingNameParts[1];
                    if (StringUtils.equalsIgnoreCase((CharSequence)variable.name(), (CharSequence)columnNameForeing)) {
                        if (bl) {
                            throw new RuntimeException("Column reference \"" + columnNameForeing + "\" is ambiguous");
                        }
                        bl = true;
                        FeatureAttributeDescriptor attr = type.getAttributeDescriptor(columnNameLocal);
                        if (attr == null) {
                            throw new RuntimeException("Cannot find in feature type attribute:" + columnNameLocal);
                        }
                        if (attr.isForeingKey()) {
                            ForeingKey foreingKey = attr.getForeingKey();
                            SQLBuilder.TableNameBuilder foreingTable = sqlbuilder.createTableNameBuilder().database(table.getDatabase()).schema(table.getSchema()).name(foreingKey.getTableName());
                            SQLBuilder.Column variable_replacement = sqlbuilder.column(foreingTable, variable.name());
                            value_replacements.add(new ExpressionBuilder.Value[]{variable, variable_replacement});
                        }
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)variable.name(), (CharSequence)columnNameLocal)) continue;
                    SQLBuilder.Column variable_replacement = sqlbuilder.column(table, variable.name());
                    value_replacements.add(new ExpressionBuilder.Value[]{variable, variable_replacement});
                }
            }
            for (ExpressionBuilder.Value[] replaceValue : value_replacements) {
                ExpressionBuilder.Value value = replaceValue[0];
                ExpressionBuilder.Value replacement = replaceValue[1];
                sqlbuilder.select().replace(value, replacement);
            }
            HashSet<String> usedLeftJoins = new HashSet<String>();
            for (String string : foreing_value_args) {
                String[] foreingNameParts = string.split("[.]");
                if (foreingNameParts.length != 2) continue;
                String string2 = foreingNameParts[0];
                String columnNameForeing = foreingNameParts[1];
                FeatureAttributeDescriptor attr = type.getAttributeDescriptor(string2);
                if (!attr.isForeingKey()) continue;
                ForeingKey foreingKey = attr.getForeingKey();
                SQLBuilder.TableNameBuilder foreingTable = sqlbuilder.createTableNameBuilder().database(table.getDatabase()).schema(table.getSchema()).name(foreingKey.getTableName());
                SQLBuilder.TableNameBuilder mainTable = sqlbuilder.createTableNameBuilder().database(table.getDatabase()).schema(table.getSchema()).name(table.getName());
                if (!usedLeftJoins.contains(foreingTable.getName())) {
                    SQLBuilder.Column v = sqlbuilder.column(mainTable, string2);
                    v.setProperty("FeatureType", (Object)type);
                    v.setProperty("JDBCHelper", (Object)this);
                    v.setProperty("Query", sqlbuilder.select().getProperty("Query"));
                    sqlbuilder.select().from().left_join(foreingTable, (ExpressionBuilder.Value)expbuilder.eq((ExpressionBuilder.Value)v, (ExpressionBuilder.Value)sqlbuilder.column(foreingTable, foreingKey.getCodeName())));
                    usedLeftJoins.add(foreingTable.getName());
                }
                if (sqlbuilder.select().has_group_by() || sqlbuilder.select().has_aggregate_functions()) continue;
                sqlbuilder.select().column().name(foreingTable, columnNameForeing);
            }
        }
        catch (Throwable th) {
            LOGGER.warn("Can't replace FOREIGN_VALUE function.", th);
            throw th;
        }
    }

    protected void addTableToColumnReferences(SQLBuilder sqlbuilder, FeatureType type, FeatureQuery query) {
        SQLBuilder.SelectBuilder select = sqlbuilder.select();
        ArrayList<Pair<SQLBuilder.TableNameBuilder, FeatureType>> tables = new ArrayList<Pair<SQLBuilder.TableNameBuilder, FeatureType>>();
        this.collectTablesFromSelect(select, tables, type);
        this.addTableToColumnReferencesInSingleSelect(sqlbuilder, select, tables, query);
    }

    private void collectTablesFromSelect(SQLBuilder.SelectBuilder select, List<Pair<SQLBuilder.TableNameBuilder, FeatureType>> tables, FeatureType type) throws LocatorException {
        DataManager dataManager = DALLocator.getDataManager();
        List joins = select.from().getJoins();
        if (!CollectionUtils.isEmpty((Collection)joins)) {
            for (SQLBuilder.JoinBuilder join : joins) {
                SQLBuilder.TableNameBuilder joinTable = join.getTable();
                FeatureType featureType = dataManager.getStoresRepository().getFeatureType(joinTable.getName());
                if (featureType == null) continue;
                tables.add((Pair<SQLBuilder.TableNameBuilder, FeatureType>)new ImmutablePair((Object)joinTable, (Object)featureType));
            }
        }
        SQLBuilder.TableNameBuilder table = select.from().table();
        if (type == null) {
            type = dataManager.getStoresRepository().getFeatureType(table.getName());
        }
        if (type != null) {
            tables.add((Pair<SQLBuilder.TableNameBuilder, FeatureType>)new ImmutablePair((Object)table, (Object)type));
        }
    }

    private boolean isComputed(String name, FeatureType featureType, FeatureQuery query) {
        FeatureAttributeDescriptor attr = featureType.getAttributeDescriptor(name);
        if (attr != null) {
            return attr.isComputed();
        }
        if (query == null) {
            return false;
        }
        attr = query.getExtraColumns().get(name);
        return attr != null;
    }

    protected void addTableToColumnReferencesInSingleSelect(final SQLBuilder sqlbuilder, final SQLBuilder.SelectBuilder select, final List<Pair<SQLBuilder.TableNameBuilder, FeatureType>> outerTables, final FeatureQuery query) {
        FeatureType mainFeatureType = CollectionUtils.isEmpty(outerTables) ? null : (FeatureType)outerTables.get(0).getRight();
        SQLBuilder.TableNameBuilder fromTable = select.from().table();
        ArrayList<ExpressionBuilder.Value[]> value_replacements = new ArrayList<ExpressionBuilder.Value[]>();
        ArrayList variables = new ArrayList();
        select.accept(value -> {
            if (value instanceof SQLBuilder.Column) {
                SQLBuilder.Column c = (SQLBuilder.Column)value;
                if (c.table() == null || !c.table().has_name() || !c.table().has_schema()) {
                    variables.add(c);
                }
            } else if (value instanceof ExpressionBuilder.Variable) {
                variables.add((ExpressionBuilder.Variable)value);
            }
        }, new ExpressionBuilder.VisitorFilter(){

            public boolean skipChildren() {
                return true;
            }

            public boolean accept(ExpressionBuilder.Visitable visitable) {
                if (select == visitable) {
                    return true;
                }
                if (visitable instanceof SQLBuilder.SelectBuilder) {
                    ArrayList<Pair<SQLBuilder.TableNameBuilder, FeatureType>> tables = new ArrayList<Pair<SQLBuilder.TableNameBuilder, FeatureType>>(outerTables);
                    JDBCHelperBase.this.collectTablesFromSelect((SQLBuilder.SelectBuilder)visitable, tables, null);
                    JDBCHelperBase.this.addTableToColumnReferencesInSingleSelect(sqlbuilder, (SQLBuilder.SelectBuilder)visitable, tables, query);
                    return false;
                }
                return true;
            }
        });
        for (ExpressionBuilder.Variable variable : variables) {
            SQLBuilder.Column variable_replacement = null;
            Pair<SQLBuilder.TableNameBuilder, FeatureType> tableNameAndFeatureType = this.getTableAndFeatureType(outerTables, variable.name());
            if (tableNameAndFeatureType != null) {
                if (!this.isComputed(variable.name(), (FeatureType)tableNameAndFeatureType.getRight(), query)) {
                    SQLBuilder.Column column;
                    SQLBuilder.TableNameBuilder variableTable = (SQLBuilder.TableNameBuilder)tableNameAndFeatureType.getLeft();
                    if (variable instanceof SQLBuilder.Column) {
                        column = (SQLBuilder.Column)variable;
                        if (column.table() != null && column.table().has_name()) {
                            if (!column.table().has_schema()) {
                                SQLBuilder.TableNameBuilder t;
                                if (column.table().getName().equals(variableTable.getName())) {
                                    t = sqlbuilder.createTableNameBuilder().name(column.table().getName()).schema(variableTable.getSchema());
                                    variable_replacement = sqlbuilder.column_from(t, variable);
                                } else if (fromTable.has_schema()) {
                                    t = sqlbuilder.createTableNameBuilder().name(column.table().getName()).schema(fromTable.getSchema());
                                    variable_replacement = sqlbuilder.column_from(t, variable);
                                }
                            }
                        } else {
                            column = sqlbuilder.column_from((SQLBuilder.TableNameBuilder)tableNameAndFeatureType.getLeft(), variable);
                            column.setProperty("FeatureType", tableNameAndFeatureType.getRight());
                            variable_replacement = column;
                        }
                    } else {
                        column = sqlbuilder.column_from((SQLBuilder.TableNameBuilder)tableNameAndFeatureType.getLeft(), variable);
                        column.setProperty("FeatureType", tableNameAndFeatureType.getRight());
                        variable_replacement = column;
                    }
                }
            } else if (!this.isComputed(variable.name(), mainFeatureType, query)) {
                if (variable instanceof SQLBuilder.Column) {
                    SQLBuilder.Column column = (SQLBuilder.Column)variable;
                    if (column.table() == null || !column.table().has_name()) {
                        variable_replacement = sqlbuilder.column_from(fromTable, variable);
                    } else if (!column.table().has_schema() && fromTable.has_schema()) {
                        SQLBuilder.TableNameBuilder t = sqlbuilder.createTableNameBuilder().name(column.table().getName()).schema(fromTable.getSchema());
                        variable_replacement = sqlbuilder.column_from(t, variable);
                    }
                } else if (StringUtils.equals((CharSequence)fromTable.getName(), (CharSequence)variable.name())) {
                    LOGGER.debug("Uff, la variable coincide con el nombre de la tabla...\nNo esta nada claro que haya que ponerle el prefijo,\nde momento no hacemos nada.");
                } else {
                    variable_replacement = sqlbuilder.column_from(fromTable, variable);
                }
            }
            if (variable_replacement == null) continue;
            value_replacements.add(new ExpressionBuilder.Value[]{variable, variable_replacement});
        }
        for (ExpressionBuilder.Value[] replaceValue : value_replacements) {
            ExpressionBuilder.Value target = replaceValue[0];
            ExpressionBuilder.Value replacement = replaceValue[1];
            Boolean addTableName = (Boolean)target.getProperty("ADD_TABLE_NAME");
            if (addTableName == null || !addTableName.booleanValue()) continue;
            select.replace(target, replacement);
        }
    }

    protected Pair<SQLBuilder.TableNameBuilder, FeatureType> getTableAndFeatureType(List<Pair<SQLBuilder.TableNameBuilder, FeatureType>> outerTables, String columnName) {
        ReverseListIterator iterator = new ReverseListIterator(outerTables);
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            FeatureType featureType = (FeatureType)pair.getRight();
            if (featureType.get(columnName) == null) continue;
            return pair;
        }
        return null;
    }

    @Override
    public void setTransaction(DataTransactionServices transaction) {
        this.transactionsHelper.setTransaction((DataTransaction)transaction);
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("hash", (Object)String.format("%x", this.hashCode()));
            builder.append("url", (Object)this.connectionParameters.getUrl());
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    public String getConnectionProviderStatus() {
        return "";
    }

    @Override
    public void expandCalculedColumns(JDBCSQLBuilderBase sqlbuilder) {
        ComputedAttribute computedAttributeFormater = new ComputedAttribute((SQLBuilder)sqlbuilder, (Formatter<ExpressionBuilder.Value>)sqlbuilder.formatter());
        for (int i = 0; i < 10; ++i) {
            ArrayList variablesToReplace = new ArrayList();
            sqlbuilder.accept(value -> {
                if (computedAttributeFormater.canApply((ExpressionBuilder.Value)value)) {
                    ExpressionBuilder.Variable variable = (ExpressionBuilder.Variable)value;
                    ExpressionBuilder.Value replace = computedAttributeFormater.expandedValue((ExpressionBuilder.Value)variable);
                    variablesToReplace.add(Pair.of((Object)variable, (Object)replace));
                }
            }, null);
            if (variablesToReplace.isEmpty()) break;
            for (Pair entry : variablesToReplace) {
                ExpressionBuilder.Value variable = (ExpressionBuilder.Value)entry.getKey();
                ExpressionBuilder.Value replace = (ExpressionBuilder.Value)entry.getValue();
                Boolean addTableName = (Boolean)variable.getProperty("ADD_TABLE_NAME");
                if (addTableName != null && addTableName.booleanValue()) {
                    sqlbuilder.setProperties((ExpressionBuilder.Visitable)replace, null, new Object[]{"ADD_TABLE_NAME", true});
                }
                sqlbuilder.select().replace(variable, replace);
            }
        }
    }

    @Override
    public DataTransactionServices getTransaction() {
        return (DataTransactionServices)this.transactionsHelper.getTransaction();
    }

    public ConnectionProvider getConnectionProvider() {
        return new FakeConnectionProvider(this.connectionParameters);
    }

    protected String getConnectionProviderKey(JDBCConnectionParameters connectionParameters) {
        String pass = Hex.encodeHexString((byte[])(connectionParameters.getPassword() + "").getBytes());
        return connectionParameters.getUrl() + ";user:" + connectionParameters.getUser() + "@" + pass;
    }
}

