/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.sql.SQLException;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCTransactionRollbackException;
import org.gvsig.fmap.dal.store.jdbc.exception.SQLRuntimeException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.ConnectionOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionOperation
implements ConnectionOperation {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractConnectionOperation.class);
    protected final JDBCHelper helper;
    protected JDBCConnection conn = null;

    public AbstractConnectionOperation(JDBCHelper helper) {
        this.helper = helper;
    }

    @Override
    public boolean continueTransactionAllowed() {
        return this.helper.getTransaction() != null;
    }

    @Override
    public boolean needTransaction() {
        return true;
    }

    protected JDBCSQLBuilderBase createSQLBuilder() {
        return this.helper.createSQLBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object perform() {
        try {
            if (this.helper.isThreadSafe()) {
                return this.perform_operation();
            }
            Class<AbstractConnectionOperation> clazz = AbstractConnectionOperation.class;
            synchronized (AbstractConnectionOperation.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.perform_operation();
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't perform operation '" + this.getClass().getSimpleName() + "'.", ex);
        }
    }

    protected JDBCConnection getConnection() throws AccessResourceException {
        if (this.conn == null) {
            this.conn = this.helper.getConnection();
        }
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object perform_operation() throws Exception {
        Object result = null;
        LOGGER.trace("preparing execution of " + this.getClass().getSimpleName() + ".");
        if (this.needTransaction()) {
            block26: {
                try {
                    if (this.helper.allowNestedOperations()) {
                        boolean commitOnFinish = true;
                        if (!this.getConnection().isInTransaction()) {
                            commitOnFinish = false;
                        }
                        this.getConnection().begin();
                        try {
                            LOGGER.trace("Excuting operation {}.", (Object)this.getClass().getSimpleName());
                            result = this.perform(this.getConnection());
                        }
                        catch (Exception ex) {
                            try {
                                this.getConnection().rollback();
                                throw new RuntimeException("Can't perform operation '" + this.getClass().getSimpleName() + "'.", ex);
                            }
                            catch (Exception e1) {
                                throw new JDBCTransactionRollbackException(e1, ex);
                            }
                        }
                        if (commitOnFinish) {
                            this.getConnection().commit();
                        }
                        break block26;
                    }
                    if (this.getConnection().isInTransaction() && !this.continueTransactionAllowed()) {
                        throw new SQLException("nested operations not allowed.");
                    }
                    this.getConnection().begin();
                    try {
                        LOGGER.trace("Excuting operation {}.", (Object)this.getClass().getSimpleName());
                        result = this.perform(this.getConnection());
                    }
                    catch (SQLRuntimeException ex) {
                        try {
                            this.getConnection().rollback();
                            throw new SQLRuntimeException("Can't perform operation '" + this.getClass().getSimpleName() + "'.", ex);
                        }
                        catch (Exception e1) {
                            throw new JDBCTransactionRollbackException(e1, ex);
                        }
                    }
                    catch (RuntimeException ex) {
                        try {
                            this.getConnection().rollback();
                            throw ex;
                        }
                        catch (Exception e1) {
                            throw new JDBCTransactionRollbackException(e1, ex);
                        }
                    }
                    catch (Exception ex) {
                        try {
                            this.getConnection().rollback();
                            throw new RuntimeException("Can't perform operation '" + this.getClass().getSimpleName() + "'.", ex);
                        }
                        catch (Exception e1) {
                            throw new JDBCTransactionRollbackException(e1, ex);
                        }
                    }
                    this.getConnection().commit();
                }
                catch (Throwable throwable) {
                    this.closeConnection(result);
                    throw throwable;
                }
            }
            this.closeConnection(result);
            return result;
        }
        try {
            LOGGER.trace("Excuting operation {}.", (Object)this.getClass().getSimpleName());
            result = this.perform(this.getConnection());
        }
        catch (SQLRuntimeException ex) {
            try {
                throw new SQLRuntimeException("Can't perform operation '" + this.getClass().getSimpleName() + "'.", ex);
                catch (Exception ex2) {
                    throw new RuntimeException("Can't perform operation '" + this.getClass().getSimpleName() + "'.", ex2);
                }
            }
            catch (Throwable throwable) {
                this.closeConnection(result);
                throw throwable;
            }
        }
        this.closeConnection(result);
        return result;
    }

    protected void closeConnection(Object result) throws Exception {
        this.getConnection().close();
        this.conn = null;
    }
}

