/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AbstractConnectionOperation;

public class ListTablesOperation
extends AbstractConnectionOperation {
    private static final String METADATA_COLUMN_TABLE_CATALOG = "TABLE_CAT";
    private static final String METADATA_COLUMN_TABLE_SCHEMA = "TABLE_SCHEM";
    private static final String METADATA_COLUMN_TABLE_NAME = "TABLE_NAME";
    private boolean informationTables = false;
    private final JDBCServerExplorerParameters serverParameters;
    private final int mode;
    private final int tablesOrViews;

    public ListTablesOperation(JDBCHelper helper, int mode, JDBCServerExplorerParameters serverParameters, boolean informationTables, int tablesOrViews) {
        super(helper);
        this.mode = mode;
        this.informationTables = informationTables;
        this.serverParameters = serverParameters;
        this.tablesOrViews = tablesOrViews;
    }

    public ListTablesOperation(JDBCHelper helper, int mode, JDBCServerExplorerParameters serverParameters, boolean informationTables) {
        this(helper, mode, serverParameters, informationTables, 0);
    }

    @Override
    public final Object perform(JDBCConnection conn) throws DataException {
        List<JDBCStoreParameters> tables = this.listTables(conn, this.mode, this.serverParameters, this.informationTables, this.tablesOrViews);
        return tables;
    }

    public List<JDBCStoreParameters> listTables(JDBCConnection conn, int mode, JDBCServerExplorerParameters serverParameters, boolean informationTables, int tablesOrViews) {
        ArrayList<JDBCStoreParameters> arrayList;
        ResultSet rs = null;
        ArrayList<JDBCStoreParameters> tables = new ArrayList<JDBCStoreParameters>();
        try {
            String[] tableTypes = null;
            switch (tablesOrViews) {
                case 1: {
                    if (informationTables) {
                        tableTypes = new String[]{"TABLE", "SYSTEM TABLE", "GLOBAL TEMPORARY", "LOCAL TEMPORARY", "ALIAS", "SYNONYM"};
                        break;
                    }
                    tableTypes = new String[]{"TABLE"};
                    break;
                }
                case 2: {
                    tableTypes = new String[]{"VIEW"};
                    break;
                }
                default: {
                    if (informationTables) break;
                    tableTypes = new String[]{"TABLE", "VIEW"};
                }
            }
            DatabaseMetaData metadata = conn.getMetaData();
            rs = metadata.getTables(null, "%", "%", tableTypes);
            while (rs.next()) {
                JDBCStoreParameters params = this.helper.createOpenStoreParameters(serverParameters);
                params.setCatalog(rs.getString(METADATA_COLUMN_TABLE_CATALOG));
                params.setSchema(rs.getString(METADATA_COLUMN_TABLE_SCHEMA));
                params.setTable(rs.getString(METADATA_COLUMN_TABLE_NAME));
                tables.add(params);
            }
            arrayList = tables;
        }
        catch (SQLException ex) {
            try {
                throw new RuntimeException("Can't fetch tables information", ex);
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        JDBCUtils.closeQuietly(rs);
        return arrayList;
    }
}

