/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCSQLException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AbstractConnectionWritableOperation;

public class UpdateTableStatisticsOperation
extends AbstractConnectionWritableOperation {
    protected final OperationsFactory.TableReference table;

    public UpdateTableStatisticsOperation(JDBCHelper helper) {
        this(helper, null);
    }

    public UpdateTableStatisticsOperation(JDBCHelper helper, OperationsFactory.TableReference table) {
        super(helper);
        this.table = table;
    }

    @Override
    public final Object perform(JDBCConnection conn) throws DataException {
        this.updateTableStatistics(conn);
        return true;
    }

    public List<String> getSQLs() {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        sqlbuilder.update_table_statistics().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        List sqls = sqlbuilder.update_table_statistics().toStrings();
        return sqls;
    }

    public void updateTableStatistics(JDBCConnection conn) throws DataException {
        List<String> sqls = this.getSQLs();
        Statement st = null;
        String currentsql = null;
        try {
            st = conn.createStatement();
            Iterator<String> iterator = sqls.iterator();
            while (iterator.hasNext()) {
                String sql;
                currentsql = sql = iterator.next();
                JDBCUtils.execute(st, sql);
            }
        }
        catch (SQLException ex) {
            throw new JDBCSQLException(ex, currentsql);
        }
        finally {
            JDBCUtils.closeQuietly(st);
        }
    }
}

