/*
 * Decompiled with CFR 0.152.
 */
package com.github.miachm.SODS.io;

import com.github.miachm.SODS.exceptions.NotAnOds;
import com.github.miachm.SODS.exceptions.OperationNotSupported;
import com.github.miachm.SODS.io.Style;
import com.github.miachm.SODS.io.Uncompressor;
import com.github.miachm.SODS.spreadsheet.Range;
import com.github.miachm.SODS.spreadsheet.Sheet;
import com.github.miachm.SODS.spreadsheet.SpreadSheet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OdsReader {
    private static final String CORRECT_MIMETYPE = "application/vnd.oasis.opendocument.spreadsheet";
    private static final String MANIFEST_PATH = "META-INF/manifest.xml";
    private String main_path;
    private SpreadSheet spread;
    private Map<String, byte[]> files;
    private Map<String, Style> styles = new HashMap<String, Style>();
    private Map<Integer, Style> rows_styles = new HashMap<Integer, Style>();
    private Map<Integer, Style> columns_styles = new HashMap<Integer, Style>();

    private OdsReader(InputStream in, SpreadSheet spread) throws IOException {
        this.spread = spread;
        this.styles.put("Default", new Style());
        Uncompressor uncompressor = new Uncompressor(in);
        this.files = uncompressor.getFiles();
        this.checkMimeType(this.files);
        byte[] manifest = this.getManifest(this.files);
        this.readManifest(manifest);
        this.readContent();
    }

    public static void load(InputStream in, SpreadSheet spread) throws IOException {
        OdsReader reader = new OdsReader(in, spread);
    }

    private void checkMimeType(Map<String, byte[]> map) {
        byte[] mimetype = map.get("mimetype");
        if (mimetype == null) {
            throw new NotAnOds("This file doesn't contain a mimetype");
        }
        String mimetype_string = new String(mimetype);
        if (!mimetype_string.equals(CORRECT_MIMETYPE)) {
            throw new NotAnOds("This file doesn't look like an ODS file. Mimetype: " + mimetype_string);
        }
    }

    private byte[] getManifest(Map<String, byte[]> map) {
        byte[] manifest = map.get(MANIFEST_PATH);
        if (manifest == null) {
            throw new NotAnOds("Error loading, it doesn't like an ODS file");
        }
        return manifest;
    }

    private void readManifest(byte[] manifest) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(manifest));
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals("manifest:manifest")) {
                throw new NotAnOds("The signature of the manifest is not valid. Is it an ODS file?");
            }
            NodeList files = doc.getElementsByTagName("manifest:file-entry");
            this.iterateFilesEntryManifest(files);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    private void iterateFilesEntryManifest(NodeList files) {
        for (int i = 0; i < files.getLength(); ++i) {
            NamedNodeMap children = files.item(i).getAttributes();
            boolean main_path = false;
            String path = null;
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (child.getNodeName().equals("manifest:encryption-data")) {
                    throw new OperationNotSupported("This file has encription technology that it's not supportedby this library");
                }
                if (child.getNodeName().equals("manifest:full-path")) {
                    path = child.getNodeValue();
                    continue;
                }
                if (!child.getNodeName().equals("manifest:media-type")) continue;
                main_path = child.getNodeValue().equals(CORRECT_MIMETYPE);
            }
            if (!main_path) continue;
            this.main_path = path;
        }
    }

    private void readContent() {
        Set<String> names = this.files.keySet();
        for (String name : names) {
            if (!name.endsWith(".xml")) continue;
            this.processContent(this.files.get(name));
        }
    }

    private void processContent(byte[] bytes) {
        try {
            Node n;
            NodeList files;
            Node n2;
            if (bytes.length == 0) {
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(bytes));
            Element root = doc.getDocumentElement();
            NodeList styles = doc.getElementsByTagName("office:automatic-styles");
            if (styles != null && (n2 = styles.item(0)) != null) {
                this.iterateStyleEntries(n2.getChildNodes());
            }
            if ((files = doc.getElementsByTagName("office:body")) != null && (n = files.item(0)) != null) {
                this.iterateFilesEntries(n.getChildNodes());
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    private void iterateStyleEntries(NodeList childNodes) {
        if (childNodes == null) {
            return;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            NamedNodeMap map;
            Node aux;
            Node node = childNodes.item(i);
            if (!node.getNodeName().equals("style:style") || (aux = (map = node.getAttributes()).getNamedItem("style:name")) == null) continue;
            Style style = this.readStyleEntry(node.getChildNodes());
            this.styles.put(aux.getNodeValue(), style);
        }
    }

    private Style readStyleEntry(NodeList childNodes) {
        Style style = new Style();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            NamedNodeMap map;
            Node bold;
            Node n = childNodes.item(i);
            if (!n.getNodeName().equals("style:text-properties") || (bold = (map = n.getAttributes()).getNamedItem("fo:font-weight")) == null) continue;
            style.bold = bold.getNodeValue().equals("bold");
        }
        return style;
    }

    private void iterateFilesEntries(NodeList files) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.getLength(); ++i) {
            Node node = files.item(i);
            if (!node.getNodeName().equals("office:spreadsheet")) continue;
            this.processSpreadsheet(node.getChildNodes());
        }
    }

    private void processSpreadsheet(NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!node.getNodeName().equals("table:table")) continue;
            this.processTable(node);
        }
    }

    private void processTable(Node node) {
        NamedNodeMap atributes = node.getAttributes();
        String name = atributes.getNamedItem("table:name").getNodeValue();
        Sheet sheet = new Sheet(name);
        sheet.deleteRow(0);
        sheet.deleteColumn(0);
        NodeList new_list = node.getChildNodes();
        for (int i = 0; i < new_list.getLength(); ++i) {
            Node n = new_list.item(i);
            Style style = this.styles.get(this.getAtribFromNode(n, "table:default-cell-style-name", null));
            if (n.getNodeName().equals("table:table-column")) {
                int numColumns = this.getNumberOfColumns(n);
                if (style != null) {
                    for (int j = sheet.getMaxColumns(); j < sheet.getMaxColumns() + numColumns; ++j) {
                        this.columns_styles.put(j, style);
                    }
                }
                sheet.appendColumns(numColumns);
                continue;
            }
            if (!n.getNodeName().equals("table:table-row")) continue;
            if (style != null) {
                this.rows_styles.put(sheet.getMaxRows(), style);
            }
            sheet.appendRow();
            this.processCells(n.getChildNodes(), sheet);
        }
        this.spread.appendSheet(sheet);
    }

    private int getNumberOfColumns(Node n) {
        Node n5 = n.getAttributes().getNamedItem("table:number-columns-repeated");
        int incr = 1;
        if (n5 != null) {
            incr = Integer.parseInt(n5.getNodeValue());
        }
        return incr;
    }

    private void processCells(NodeList childNodes, Sheet sheet) {
        int column = 0;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!n.getNodeName().equals("table:table-cell")) continue;
            Range range = sheet.getRange(sheet.getMaxRows() - 1, column);
            String valueType = this.getValueType(n);
            String formula = this.getFormula(n);
            range.setFormula(formula);
            Style style = this.styles.get(this.getStyle(n));
            if (style == null) {
                style = this.columns_styles.get(column);
            }
            if (style == null) {
                style = this.rows_styles.get(sheet.getMaxRows() - 1);
            }
            if (style != null) {
                range.setFontBold(style.bold);
            }
            NodeList cells = n.getChildNodes();
            for (int j = 0; j < cells.getLength(); ++j) {
                Node cell = cells.item(j);
                if (!cell.getNodeName().equals("text:p")) continue;
                range.setValue(this.getValue(cell.getTextContent(), valueType));
            }
            ++column;
        }
    }

    private String getValueType(Node n) {
        return this.getAtribFromNode(n, "office:value-type", "string");
    }

    private String getFormula(Node n) {
        return this.getAtribFromNode(n, "table:formula", null);
    }

    private String getStyle(Node n) {
        return this.getAtribFromNode(n, "table:style-name", null);
    }

    private String getAtribFromNode(Node n, String atrib, String defaultValue) {
        Node type = n.getAttributes().getNamedItem(atrib);
        if (type != null) {
            defaultValue = type.getNodeValue();
        }
        return defaultValue;
    }

    private Object getValue(String value, String valueType) {
        if (valueType.equals("integer")) {
            return Integer.parseInt(value);
        }
        if (valueType.equals("float")) {
            return this.parseDouble(value);
        }
        return value;
    }

    private Double parseDouble(String value) {
        Locale locale = this.spread.getLocale();
        if (value.startsWith("+")) {
            value = value.substring(1);
        }
        ParsePosition p = new ParsePosition(0);
        NumberFormat nf = NumberFormat.getInstance(locale);
        Number num = nf.parse(value, p);
        if (p.getErrorIndex() > 0 || p.getIndex() < value.length()) {
            throw new NumberFormatException("Can't parse '" + value + "' to double with locale " + (locale == null ? "null" : locale.getLanguage()) + "(error index " + p.getErrorIndex() + ", index " + p.getIndex() + ").");
        }
        return num.doubleValue();
    }
}

