/*
 * Decompiled with CFR 0.152.
 */
package com.github.miachm.SODS.spreadsheet;

import com.github.miachm.SODS.spreadsheet.Cell;
import com.github.miachm.SODS.spreadsheet.RangeIterator;
import com.github.miachm.SODS.spreadsheet.Sheet;

public class Range {
    private final int column_init;
    private final int row_init;
    private final int numrows;
    private final int numcolumns;
    private final Sheet sheet;

    Range(Sheet sheet, int row_init, int column_init, int numrows, int numcolumns) {
        if (row_init + numrows > sheet.getMaxRows()) {
            throw new AssertionError((Object)("Range goes out of bounds: (end_of_range: " + (row_init + numrows) + ", maxrows in sheet: " + sheet.getMaxRows()));
        }
        if (column_init + numcolumns > sheet.getMaxColumns()) {
            throw new AssertionError((Object)("Range goes out of bounds: (end_of_range: " + (column_init + numcolumns) + ", maxcolumns in sheet: " + sheet.getMaxColumns()));
        }
        this.sheet = sheet;
        this.row_init = row_init;
        this.column_init = column_init;
        this.numrows = numrows;
        this.numcolumns = numcolumns;
    }

    public void clear() {
        this.iterateRange((cell, row, column) -> cell.clear());
    }

    public void copyTo(Range dest) {
        if (dest.getNumValues() != this.getNumValues()) {
            throw new AssertionError((Object)("Error in copyTo, the range is of different size (" + dest.getNumValues() + " against " + this.getNumValues() + ")"));
        }
        dest.setValues(this.getValues());
    }

    public Range getCell(int row, int column) {
        return new Range(this.sheet, this.row_init + row, this.column_init + column, 1, 1);
    }

    public int getColumn() {
        return this.column_init;
    }

    public String getFormula() {
        return this.sheet.getCell(this.row_init, this.column_init).getFormula();
    }

    public String[][] getFormulas() {
        String[][] formulas = new String[this.getNumRows()][this.getNumColumns()];
        this.iterateRange((cell, row, column) -> {
            formulas[row][column] = cell.getFormula();
        });
        return formulas;
    }

    public int getLastColumn() {
        return this.column_init + this.getNumColumns() - 1;
    }

    public int getLastRow() {
        return this.row_init + this.getNumRows() - 1;
    }

    public int getNumColumns() {
        return this.numcolumns;
    }

    public int getNumRows() {
        return this.numrows;
    }

    public int getRow() {
        return this.row_init;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public Object getValue() {
        return this.sheet.getCell(this.row_init, this.column_init).getValue();
    }

    public Object[][] getValues() {
        Object[][] values = new Object[this.getNumRows()][this.getNumColumns()];
        this.iterateRange((cell, row, column) -> {
            values[row][column] = cell.getValue();
        });
        return values;
    }

    public boolean getFontBold() {
        return this.sheet.getCell(this.row_init, this.column_init).isBold();
    }

    public boolean[][] getFontBolds() {
        boolean[][] arr = new boolean[this.getNumRows()][this.getNumColumns()];
        this.iterateRange((cell, row, column) -> {
            arr[row][column] = cell.isBold();
        });
        return arr;
    }

    public int getNumValues() {
        return this.getNumColumns() * this.getNumRows();
    }

    public void setValue(Object o) {
        this.iterateRange((cell, row, column) -> cell.setValue(o));
    }

    public void setValues(Object ... o) {
        if (o.length != this.getNumValues()) {
            throw new AssertionError((Object)("Error in setValues, the number of the arguments doesn't fit (" + o.length + " against " + this.getNumValues() + ")"));
        }
        this.iterateRange((cell, row, column) -> cell.setValue(o[row * this.getNumColumns() + column]));
    }

    public void setValues(Object[][] o) {
        if (o.length == 0) {
            throw new AssertionError((Object)"Error in setValues, the array is empty");
        }
        if (o.length != this.getNumRows()) {
            throw new AssertionError((Object)("Error in setValues, the number of rows doesn't fit (" + o.length + " against " + this.getNumRows() + ")"));
        }
        if (o[0].length != this.getNumColumns()) {
            throw new AssertionError((Object)("Error in setValues, the number of columns doesn't fit (" + o.length + " against " + this.getNumColumns() + ")"));
        }
        this.iterateRange((cell, row, column) -> cell.setValue(o[row][column]));
    }

    public void setFontBold(boolean bold) {
        this.iterateRange((cell, row, column) -> cell.setBold(bold));
    }

    public void setFontBolds(boolean ... bold) {
        if (bold.length != this.getNumValues()) {
            throw new AssertionError((Object)("Error in setFontBold, the number of the arguments doesn't fit (" + bold.length + " against " + this.getNumValues() + ")"));
        }
        this.iterateRange((cell, row, column) -> cell.setBold(bold[row * this.getNumColumns() + column]));
    }

    public void setFontBolds(boolean[][] bold) {
        if (bold.length == 0) {
            throw new AssertionError((Object)"Error in setFontBold, the array is empty");
        }
        if (bold.length != this.getNumRows()) {
            throw new AssertionError((Object)("Error in setFontBolds, the number of rows doesn't fit (" + bold.length + " against " + this.getNumRows() + ")"));
        }
        if (bold[0].length != this.getNumColumns()) {
            throw new AssertionError((Object)("Error in setFontBolds, the number of columns doesn't fit (" + bold.length + " against " + this.getNumColumns() + ")"));
        }
        this.iterateRange((cell, row, column) -> cell.setBold(bold[row][column]));
    }

    private void iterateRange(RangeIterator e) {
        for (int i = 0; i < this.numrows; ++i) {
            for (int j = 0; j < this.numcolumns; ++j) {
                Cell cell = this.sheet.getCell(this.row_init + i, this.column_init + j);
                e.call(cell, i, j);
            }
        }
    }

    private String valuesToString() {
        StringBuilder builder = new StringBuilder();
        Object[][] values = this.getValues();
        for (int i = 0; i < values.length; ++i) {
            builder.append(values[i][0]);
            for (int j = 1; j < values[i].length; ++j) {
                builder.append(" , " + values[i][j]);
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public void setFormula(String formula) {
        this.iterateRange((cell, row, column) -> cell.setFormula(formula));
    }

    public void setFormulas(String ... formula) {
        if (formula.length != this.getNumValues()) {
            throw new AssertionError((Object)("Error in setValues, the number of the arguments doesn't fit (" + formula.length + " against " + this.getNumValues() + ")"));
        }
        this.iterateRange((cell, row, column) -> cell.setFormula(formula[row * this.getNumColumns() + column]));
    }

    public void setFormulas(String[][] formula) {
        if (formula.length == 0) {
            throw new AssertionError((Object)"Error in setValues, the array is empty");
        }
        if (formula.length != this.getNumRows()) {
            throw new AssertionError((Object)("Error in setValues, the number of rows doesn't fit (" + formula.length + " against " + this.getNumRows() + ")"));
        }
        if (formula[0].length != this.getNumColumns()) {
            throw new AssertionError((Object)("Error in setValues, the number of columns doesn't fit (" + formula.length + " against " + this.getNumColumns() + ")"));
        }
        this.iterateRange((cell, row, column) -> cell.setFormula(formula[row][column]));
    }

    public String toString() {
        return "Range{\ncolumn_init=" + this.column_init + "\nrow_init=" + this.row_init + "\nnumrows=" + this.numrows + "\nnumcolumns=" + this.numcolumns + "\nvalues =\n\n" + this.valuesToString() + "\n}";
    }
}

