/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.gui;

import java.awt.Dimension;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.catalog.CatalogLocator;
import org.gvsig.catalog.CatalogManager;
import org.gvsig.catalog.drivers.ICatalogServiceDriver;
import org.gvsig.catalog.gui.SearchDialog;
import org.gvsig.catalog.gui.ServerPropertiesDialog;
import org.gvsig.catalog.ui.serverconnect.ServerConnectDialogPanel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.utils.swing.jcomboServer.ServerData;

public class ConnectDialog
extends ServerConnectDialogPanel {
    public WindowInfo m_windowInfo = null;
    private static final CatalogManager catalogManager = CatalogLocator.getCatalogManager();

    public ConnectDialog() {
        super(null);
        this.init();
    }

    private void init() {
        this.setPreferredSize(new Dimension(600, 200));
        this.setName("connectDialog");
    }

    protected void searchButtonActionPerformed() {
        this.addCurrentHost();
        this.closeJDialog();
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        SearchDialog dialog = new SearchDialog(this.getClient(), (Object)this);
        windowManager.showWindow((JComponent)((Object)dialog), ToolsSwingUtils.makeTitle((String)"catalog_search", (String)this.getCurrentServer(), null), WindowManager.MODE.TOOL, Collections.singletonMap("align", 10));
    }

    private void addCurrentHost() {
        String host = this.getClient().getSUri();
        ServerData newServerData = new ServerData(host, "CATALOG", this.getClient().getProtocol(), this.getControlsPanel().getDatabase());
        if (this.client.getServerData() != null && this.client.getServerData().getServerAddress().compareTo(newServerData.getServerAddress()) == 0 && this.client.getServerData().getServiceSubType().compareTo(newServerData.getServiceSubType()) == 0) {
            newServerData.setProperies(this.client.getServerData().getProperies());
        }
        Map serversMap = catalogManager.getServersPersistence();
        serversMap.put(newServerData.getServerAddress(), newServerData);
    }

    protected void closeButtonActionPerformed() {
        this.closeJDialog();
    }

    protected void serverPropertiesButtonActionPerformed() {
        this.createClient();
        PluginServices.getMDIManager().addWindow((IWindow)new ServerPropertiesDialog(this.getControlsPanel().getServer(), this.client, ((ICatalogServiceDriver)this.getControlsPanel().getDriver()).getProfile(), null));
    }

    public void closeJDialog() {
        this.setVisible(false);
    }

    protected Icon getPropertiesIcon() {
        return IconThemeHelper.getImageIcon((String)"catalog-server-properties");
    }
}

