/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.loaders;

import java.net.URI;
import org.gvsig.catalog.loaders.LayerLoader;
import org.gvsig.catalog.loaders.LayerLoaderException;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.desktopopen.DesktopOpen;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.util.ToolsUtilLocator;

public class LinkLoader
extends LayerLoader {
    public LinkLoader(Resource resource) {
        super(resource);
    }

    public void loadLayer() throws LayerLoaderException {
        String link = this.getResource().getLinkage();
        DesktopOpen desktop = ToolsUtilLocator.getToolsUtilManager().createDesktopOpen();
        try {
            desktop.browse(new URI(link));
        }
        catch (Exception e) {
            throw new LayerLoaderException(e.getMessage(), this.getWindowMessage());
        }
    }

    protected String getErrorMessage() {
        return Messages.getText((String)"linkError") + ".\n" + Messages.getText((String)"link") + ": " + this.getResource().getLinkage();
    }

    protected String getWindowMessage() {
        return Messages.getText((String)"linkLoad");
    }
}

