/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.loaders;

import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.catalog.loaders.GvSigLayerLoader;
import org.gvsig.catalog.schemas.Resource;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.i18n.Messages;

public class WFSLayerLoader
extends GvSigLayerLoader {
    public static final String DYNFIELDNAME_URL = "url";
    public static final String DYNFIELDNAME_VERSION = "version";
    public static final String DYNFIELDNAME_TYPENAME = "typeName";
    public static final String DYNFIELDNAME_NAMESPACE = "namespace";
    public static final String DYNFIELDNAME_NAMESPACEPREFIX = "namespacePrefix";
    public static final String DYNFIELDNAME_CRS = "Crs";
    public static final String DYNFIELDNAME_FIELDS = "fields";
    public static final String DYNFIELDNAME_FILTERENCODING = "filterEncoding";
    public static final String DYNFIELDNAME_MAXFEATURES = "maxFeatures";
    public static final String DYNFIELDNAME_TIMEOUT = "timeOut";
    public static final String DYNFIELDNAME_USER = "user";
    public static final String DYNFIELDNAME_PASSWORD = "password";

    public WFSLayerLoader(Resource resource) {
        super(resource);
    }

    @Override
    protected boolean hasSpecificLayer() {
        return false;
    }

    @Override
    protected String getLayerName() {
        return this.getResource().getName();
    }

    @Override
    protected DataStoreParameters createDataStoreParameters() throws InitializeException, ProviderNotRegisteredException {
        String host = this.getResource().getLinkage();
        String featureType = this.getResource().getName();
        DataStoreParameters dataStoreParameters = DATA_MANAGER.createStoreParameters("WFSStore");
        dataStoreParameters.setDynValue(DYNFIELDNAME_URL, (Object)host);
        int index = featureType.indexOf(":");
        if (index > 0) {
            dataStoreParameters.setDynValue(DYNFIELDNAME_NAMESPACEPREFIX, (Object)featureType.substring(0, index));
        }
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        AbstractViewPanel activeView = (AbstractViewPanel)application.getActiveWindow(ViewDocument.class);
        dataStoreParameters.setDynValue(DYNFIELDNAME_CRS, (Object)activeView.getProjection().getAbrev());
        dataStoreParameters.setDynValue(DYNFIELDNAME_TYPENAME, (Object)featureType);
        dataStoreParameters.setDynValue(DYNFIELDNAME_USER, (Object)"");
        dataStoreParameters.setDynValue(DYNFIELDNAME_PASSWORD, (Object)"");
        return dataStoreParameters;
    }

    protected String getErrorMessage() {
        return Messages.getText((String)"wfsError") + ".\n" + Messages.getText((String)"server") + ": " + this.getResource().getLinkage() + "\n" + Messages.getText((String)"layer") + ": " + this.getResource().getName();
    }

    protected String getWindowMessage() {
        return Messages.getText((String)"wfsLoad");
    }
}

