/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers.order.impl;

import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.order.LayerOrderManager;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasterPolLinePointOrderManager
implements LayerOrderManager {
    public static final String RASTER_POLYGON_LINE_POINT_LAYER_ORDER_MANAGER_PERSISTENCE_NAME = "RASTER_POLYGON_LINE_POINT_LAYER_ORDER_MANAGER_PERSISTENCE_NAME";
    private static Logger logger = LoggerFactory.getLogger(RasterPolLinePointOrderManager.class);

    public int getPosition(FLayers target, FLayer newLayer) {
        int new_weight = 3;
        new_weight = this.getLayerWeight(newLayer);
        int len = target.getLayersCount();
        int item_w = 0;
        for (int i = len - 1; i >= 0; --i) {
            item_w = this.getLayerWeight(target.getLayer(i));
            if (item_w < new_weight) continue;
            return i + 1;
        }
        return 0;
    }

    public String getDescription() {
        return Messages.getText((String)"_Raster_at_bottom_then_polygons_lines_points");
    }

    public String getName() {
        return Messages.getText((String)"_Raster_Polygon_Line_Point_order_manager");
    }

    public String getCode() {
        return this.getClass().getName();
    }

    private int getLayerWeight(FLayer lyr) {
        if (lyr.getClass().getName().toLowerCase().indexOf("raster") != -1) {
            return 4;
        }
        if (lyr instanceof FLyrVect) {
            FLyrVect lyrv = (FLyrVect)lyr;
            int type2d = 3;
            try {
                type2d = this.simplifyType(lyrv.getGeometryType());
            }
            catch (ReadException e) {
                logger.error("While getting geo type.", (Throwable)e);
            }
            switch (type2d) {
                case 3: {
                    return 2;
                }
                case 2: {
                    return 1;
                }
                case 1: {
                    return 0;
                }
            }
            return 3;
        }
        return 3;
    }

    private int simplifyType(GeometryType gt) {
        if (gt.isTypeOf(1) || gt.isTypeOf(7)) {
            return 1;
        }
        if (gt.isTypeOf(2) || gt.isTypeOf(8)) {
            return 2;
        }
        if (gt.isTypeOf(3) || gt.isTypeOf(9)) {
            return 3;
        }
        return 3;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("name", this.getName());
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(RASTER_POLYGON_LINE_POINT_LAYER_ORDER_MANAGER_PERSISTENCE_NAME) == null) {
            DynStruct def = manager.addDefinition(RasterPolLinePointOrderManager.class, RASTER_POLYGON_LINE_POINT_LAYER_ORDER_MANAGER_PERSISTENCE_NAME, "RASTER_POLYGON_LINE_POINT_LAYER_ORDER_MANAGER_PERSISTENCE_NAME Persistence definition", null, null);
            def.addDynFieldString("name").setMandatory(true);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return new RasterPolLinePointOrderManager();
    }
}

