/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.lib.legend.api.colortable.colortableclass.ColorTableClass;
import org.gvsig.raster.lib.legend.api.colortable.colortableclass.ColorTableClassNotification;
import org.gvsig.raster.lib.legend.impl.DefaultColorTableClass;
import org.gvsig.raster.lib.legend.impl.colortable.DefaultColorTableNotification;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.observer.Notification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.impl.BaseWeakReferencingObservable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultColorTable
extends BaseWeakReferencingObservable
implements ColorTable {
    public static final String PERSISTENT_NAME = "ColorTablePersistent";
    public static final String PERSISTENT_DESCRIPTION = "Persistent definition of color table";
    private static final String NAME_PERSISTENCE_FIELD = "name";
    private static final String RANGE_PERSISTENCE_FIELD = "range";
    private static final String NAME_CLASS_PERSISTENCE_FIELD = "nameClass";
    private static final String CLASSES_PERSISTENCE_FIELD = "classes";
    private static final String PALETTE_BY_BAND_PERSISTENCE_FIELD = "paletteByBand";
    private static final String INTERPOLATED_PERSISTENCE_FIELD = "interpolated";
    private static final String ERROR_COLOR_PERSISTENCE_FIELD = "errorColor";
    private static final int defaultNumberOfClasses = 256;
    private List<ColorTableClass> classes;
    private String name;
    private boolean interpolated;
    private int errorColor = 8;
    private double[] classValues = null;
    private byte[][] paletteByBand = null;
    private String[] classNames = null;

    public DefaultColorTable() {
    }

    public DefaultColorTable(String name, List<ColorTableClass> classes, boolean interpolated) {
        if (this.isNamePath(name)) {
            throw new IllegalArgumentException("Name of Color table can not be a path");
        }
        this.name = name;
        this.classes = classes;
        this.interpolated = interpolated;
        this.observeClasses();
        this.reCalculateColorTable(false);
    }

    private void observeClasses() {
        for (ColorTableClass clazz : this.classes) {
            clazz.addObserver((Observer)this);
        }
    }

    private void stopObservingClasses() {
        for (ColorTableClass clazz : this.classes) {
            clazz.deleteObserver((Observer)this);
        }
    }

    private void applyPalette(List<ColorTableClass> colorItems) {
        int i;
        double max;
        ArrayList<DefaultColorTableClass> arrayColors = new ArrayList<DefaultColorTableClass>();
        this.classValues = new double[0];
        this.classNames = new String[0];
        if (colorItems.size() == 0) {
            return;
        }
        double min = colorItems.get(0).getValue();
        if (min > (max = colorItems.get(colorItems.size() - 1).getValue())) {
            double aux = max;
            max = min;
            min = aux;
        }
        Color color = Color.white;
        Color colorOld = null;
        for (i = 0; i < 256; ++i) {
            double value = min + (double)i * (max - min) / 255.0;
            int pos = 0;
            for (int j = 1; j <= colorItems.size(); ++j) {
                if (j < colorItems.size()) {
                    if (!(value < colorItems.get(j).getValue())) continue;
                    pos = j - 1;
                    break;
                }
                pos = j - 1;
                break;
            }
            if (this.interpolated) {
                color = this.interpolatedColor(value, pos);
            } else {
                double max2;
                double min2;
                if (pos + 1 < colorItems.size() && (min2 = colorItems.get(pos).getValue()) + ((max2 = colorItems.get(pos + 1).getValue()) - min2) * colorItems.get(pos + 1).getInterpolated() / 100.0 < value) {
                    ++pos;
                }
                color = colorItems.get(pos).getColor();
            }
            if (!this.isEqualColor(color, colorOld, 0)) {
                DefaultColorTableClass colorItem = new DefaultColorTableClass();
                colorItem.setValue(value);
                colorItem.setColor(color);
                arrayColors.add(colorItem);
            }
            colorOld = color;
        }
        this.paletteByBand = new byte[arrayColors.size()][4];
        this.classValues = new double[arrayColors.size()];
        this.classNames = new String[arrayColors.size()];
        for (i = 0; i < arrayColors.size(); ++i) {
            this.paletteByBand[i][0] = (byte)((ColorTableClass)arrayColors.get(i)).getColor().getRed();
            this.paletteByBand[i][1] = (byte)((ColorTableClass)arrayColors.get(i)).getColor().getGreen();
            this.paletteByBand[i][2] = (byte)((ColorTableClass)arrayColors.get(i)).getColor().getBlue();
            this.paletteByBand[i][3] = (byte)((ColorTableClass)arrayColors.get(i)).getColor().getAlpha();
            this.classValues[i] = ((ColorTableClass)arrayColors.get(i)).getValue();
            this.classNames[i] = ((ColorTableClass)arrayColors.get(i)).getName();
        }
    }

    private boolean canDelete(int first, int last) {
        if (first >= this.getClasses().size()) {
            return false;
        }
        if (last >= this.getClasses().size()) {
            return false;
        }
        ColorTableClass c1 = this.getClasses().get(first);
        ColorTableClass c2 = this.getClasses().get(last);
        for (int i = first + 1; i < last; ++i) {
            if (this.isCorrectColor(c1, c2, this.getClasses().get(i))) continue;
            return false;
        }
        return true;
    }

    public void compressPalette() {
        this.removeDuplicatedValues();
        int size = -1;
        while (size != this.classes.size()) {
            int init = 0;
            int posMax = 2;
            size = this.classes.size();
            while (init < this.classes.size()) {
                if (posMax < this.classes.size() && this.canDelete(init, posMax)) {
                    ++posMax;
                    continue;
                }
                if (init + 2 < posMax && this.canDelete(init, posMax - 1)) {
                    for (int i = posMax - 2; i > init; --i) {
                        if (i >= this.classes.size()) continue;
                        this.classes.remove(i);
                    }
                }
                posMax = ++init + 2;
            }
        }
    }

    public void copyFrom(ColorTable colorTable) {
        RasterLegendManager rasterLegendManager = RasterLegendLocator.getRasterLegendManager();
        this.interpolated = colorTable.isInterpolated();
        this.name = colorTable.getName();
        ArrayList<ColorTableClass> clonedClasses = new ArrayList<ColorTableClass>(colorTable.getClasses().size());
        for (ColorTableClass colorTableClass : colorTable.getClasses()) {
            ColorTableClass clonedClass = rasterLegendManager.createColorTableClass(colorTableClass.getName(), colorTableClass.getValue(), colorTableClass.getInterpolated(), colorTableClass.getColor());
            clonedClasses.add(clonedClass);
        }
        this.setClasses(clonedClasses, false);
        this.notifyObservers((Object)new DefaultColorTableNotification("copied_from_color_table_notification", new Object[]{colorTable}));
    }

    public List<ColorTableClass> getClasses() {
        return this.classes;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAlpha() {
        for (int i = 0; i < this.classes.size(); ++i) {
            ColorTableClass colorTableClass = this.classes.get(i);
            if (colorTableClass.getColor().getAlpha() == 255) continue;
            return true;
        }
        return false;
    }

    private Color interpolatedColor(double value, int pos) {
        double perc2;
        double perc1;
        Color color2;
        Color color1;
        if (this.classes.size() <= 0) {
            return Color.black;
        }
        if (pos + 1 == this.classes.size()) {
            return this.classes.get(pos).getColor();
        }
        if (value <= this.classes.get(0).getValue()) {
            return this.classes.get(0).getColor();
        }
        ColorTableClass item1 = this.classes.get(pos);
        ColorTableClass item2 = this.classes.get(pos + 1);
        double percValue = (value - item1.getValue()) * 100.0 / (item2.getValue() - item1.getValue());
        Color halfColor = new Color(item2.getColor().getRed() + item1.getColor().getRed() >> 1, item2.getColor().getGreen() + item1.getColor().getGreen() >> 1, item2.getColor().getBlue() + item1.getColor().getBlue() >> 1, item2.getColor().getAlpha() + item1.getColor().getAlpha() >> 1);
        if (percValue > item2.getInterpolated()) {
            color1 = halfColor;
            color2 = item2.getColor();
            perc1 = item2.getInterpolated();
            perc2 = 100.0;
        } else {
            color1 = item1.getColor();
            color2 = halfColor;
            perc1 = 0.0;
            perc2 = item2.getInterpolated();
        }
        double percNew = (percValue - perc1) / (perc2 - perc1);
        Color newColor = new Color((int)((double)color1.getRed() + (double)(color2.getRed() - color1.getRed()) * percNew) & 0xFF, (int)((double)color1.getGreen() + (double)(color2.getGreen() - color1.getGreen()) * percNew) & 0xFF, (int)((double)color1.getBlue() + (double)(color2.getBlue() - color1.getBlue()) * percNew) & 0xFF, (int)((double)color1.getAlpha() + (double)(color2.getAlpha() - color1.getAlpha()) * percNew) & 0xFF);
        return newColor;
    }

    private boolean isCorrectColor(ColorTableClass c1, ColorTableClass c2, ColorTableClass c3) {
        if (c3.getName() != null && c3.getName().length() > 0) {
            return false;
        }
        if (c3.getInterpolated() != 50.0) {
            return false;
        }
        if (c2.getInterpolated() != 50.0) {
            return false;
        }
        double max = c2.getValue() - c1.getValue();
        int r = c1.getColor().getRed() + (int)((double)(c2.getColor().getRed() - c1.getColor().getRed()) * (c3.getValue() - c1.getValue()) / max);
        int g = c1.getColor().getGreen() + (int)((double)(c2.getColor().getGreen() - c1.getColor().getGreen()) * (c3.getValue() - c1.getValue()) / max);
        int b = c1.getColor().getBlue() + (int)((double)(c2.getColor().getBlue() - c1.getColor().getBlue()) * (c3.getValue() - c1.getValue()) / max);
        int a = c1.getColor().getAlpha() + (int)((double)(c2.getColor().getAlpha() - c1.getColor().getAlpha()) * (c3.getValue() - c1.getValue()) / max);
        Color aux = new Color(r & 0xFF, g & 0xFF, b & 0xFF, a & 0xFF);
        return this.isEqualColor(c3.getColor(), aux, this.errorColor);
    }

    private boolean isEqualColor(Color c1, Color c2, int error) {
        if (c2 == null && c1 != null) {
            return false;
        }
        if (c1 == null && c2 != null) {
            return false;
        }
        if (c2.getRed() < c1.getRed() - error) {
            return false;
        }
        if (c2.getGreen() < c1.getGreen() - error) {
            return false;
        }
        if (c2.getBlue() < c1.getBlue() - error) {
            return false;
        }
        if (c2.getAlpha() < c1.getAlpha() - error) {
            return false;
        }
        if (c2.getRed() > c1.getRed() + error) {
            return false;
        }
        if (c2.getGreen() > c1.getGreen() + error) {
            return false;
        }
        if (c2.getBlue() > c1.getBlue() + error) {
            return false;
        }
        return c2.getAlpha() <= c1.getAlpha() + error;
    }

    public boolean isInterpolated() {
        return this.interpolated;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        List aux;
        List colorItems;
        this.interpolated = state.getBoolean(INTERPOLATED_PERSISTENCE_FIELD);
        this.errorColor = state.getInt(ERROR_COLOR_PERSISTENCE_FIELD);
        this.name = state.getString(NAME_PERSISTENCE_FIELD);
        List range = state.getList(RANGE_PERSISTENCE_FIELD);
        this.classValues = new double[range.size()];
        for (int i = 0; i < range.size(); ++i) {
            this.classValues[i] = (Double)range.get(i);
        }
        List nameClass = state.getList(NAME_CLASS_PERSISTENCE_FIELD);
        if (nameClass != null) {
            this.classNames = new String[nameClass.size()];
            nameClass.toArray(this.classNames);
        }
        if ((colorItems = state.getList(CLASSES_PERSISTENCE_FIELD)) != null) {
            this.classes = new ArrayList<ColorTableClass>();
            this.classes.addAll(colorItems);
        }
        if ((aux = state.getList(PALETTE_BY_BAND_PERSISTENCE_FIELD)) != null) {
            this.paletteByBand = null;
            for (int i = 0; i < aux.size(); ++i) {
                String[] values = ((String)aux.get(i)).split("#");
                if (this.paletteByBand == null) {
                    if (values.length == 3) {
                        this.paletteByBand = new byte[aux.size()][3];
                    }
                    if (values.length == 4) {
                        this.paletteByBand = new byte[aux.size()][4];
                    }
                }
                this.paletteByBand[i][0] = Byte.valueOf(values[0]);
                this.paletteByBand[i][1] = Byte.valueOf(values[1]);
                this.paletteByBand[i][2] = Byte.valueOf(values[2]);
                if (values.length != 4) continue;
                this.paletteByBand[i][3] = Byte.valueOf(values[3]);
            }
        }
    }

    private void reCalculateColorTable(boolean compress) {
        Collections.sort(this.classes);
        if (compress) {
            this.compressPalette();
        }
        this.applyPalette(this.classes);
        this.removeDuplicatedValues();
    }

    public void removeDuplicatedValues() {
        for (int i = this.classes.size() - 2; i >= 0; --i) {
            if (i + 1 >= this.classes.size()) continue;
            ColorTableClass nextColorTableClass = this.classes.get(i + 1);
            ColorTableClass colorTableClass = this.classes.get(i);
            if (nextColorTableClass.getValue() != colorTableClass.getValue() || !nextColorTableClass.getColor().equals(colorTableClass.getColor())) continue;
            if (StringUtils.isBlank((CharSequence)nextColorTableClass.getName())) {
                this.classes.remove(i + 1);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)colorTableClass.getName())) {
                this.classes.remove(i);
                continue;
            }
            if (!nextColorTableClass.getName().equals(colorTableClass.getName())) continue;
            this.classes.remove(i);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(INTERPOLATED_PERSISTENCE_FIELD, this.interpolated);
        state.set(ERROR_COLOR_PERSISTENCE_FIELD, this.errorColor);
        state.set(NAME_PERSISTENCE_FIELD, this.name);
        state.set(RANGE_PERSISTENCE_FIELD, this.classValues);
        state.set(NAME_CLASS_PERSISTENCE_FIELD, this.classNames);
        state.set(CLASSES_PERSISTENCE_FIELD, this.classes);
        ArrayList<String> list = new ArrayList<String>();
        if (this.paletteByBand != null) {
            String entry = null;
            for (int i = 0; i < this.paletteByBand.length; ++i) {
                entry = this.paletteByBand[i][0] + "#" + this.paletteByBand[i][1] + "#" + this.paletteByBand[i][2];
                if (this.paletteByBand[0].length > 3) {
                    entry = entry + "#" + this.paletteByBand[i][3];
                }
                list.add(entry);
            }
            state.set(PALETTE_BY_BAND_PERSISTENCE_FIELD, list);
        } else {
            state.setNull(PALETTE_BY_BAND_PERSISTENCE_FIELD);
        }
    }

    public void setClasses(List<ColorTableClass> colorTableClasses, boolean compress) {
        if (this.classes != null) {
            this.stopObservingClasses();
        }
        this.classes = colorTableClasses;
        this.observeClasses();
        this.reCalculateColorTable(compress);
        this.notifyObservers((Object)new DefaultColorTableNotification("setted_class_values_color_table_notification", new Object[]{colorTableClasses}));
    }

    public void setClasses(double min, double max, boolean compress) {
        ColorTableClass colorTableClass;
        int i;
        double max2 = Double.NEGATIVE_INFINITY;
        double min2 = Double.POSITIVE_INFINITY;
        if (min > max) {
            double aux = min;
            min = max;
            max = aux;
        }
        RasterLegendManager rasterLegendManager = RasterLegendLocator.getRasterLegendManager();
        ArrayList<ColorTableClass> arrayList = new ArrayList<ColorTableClass>();
        List<ColorTableClass> items = this.getClasses();
        for (i = 0; i < items.size(); ++i) {
            colorTableClass = items.get(i);
            if (colorTableClass.getValue() > max2) {
                max2 = colorTableClass.getValue();
            }
            if (!(colorTableClass.getValue() < min2)) continue;
            min2 = colorTableClass.getValue();
        }
        if (items.size() > 0) {
            colorTableClass = items.get(0);
        } else {
            colorTableClass = rasterLegendManager.createColorTableClass();
            colorTableClass.setValue(0.0);
            colorTableClass.setColor(Color.black);
        }
        arrayList.add(colorTableClass);
        for (i = 0; i < items.size(); ++i) {
            colorTableClass = items.get(i);
            colorTableClass.setValue(min + (colorTableClass.getValue() - min2) * (max - min) / (max2 - min2));
            arrayList.add(colorTableClass);
        }
        if (items.size() > 0) {
            colorTableClass = items.get(items.size() - 1);
        } else {
            colorTableClass = rasterLegendManager.createColorTableClass();
            colorTableClass.setValue(255.0);
            colorTableClass.setColor(Color.white);
        }
        arrayList.add(colorTableClass);
        this.setClasses(arrayList, compress);
    }

    public void setInterpolated(boolean flag) {
        boolean oldInterpolated = this.interpolated;
        this.interpolated = flag;
        if (this.classes != null) {
            this.reCalculateColorTable(false);
        }
        this.notifyObservers((Object)new DefaultColorTableNotification("changed_interpolated_color_table_notification", new Object[]{oldInterpolated, this.interpolated}));
    }

    public void setName(String name) {
        if (this.isNamePath(name)) {
            throw new IllegalArgumentException("Name of Color table can not be a path");
        }
        this.name = name;
        this.notifyObservers((Object)new DefaultColorTableNotification("renamed_color_table_notification", new Object[]{name}));
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(DefaultColorTable.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.addDynFieldBoolean(INTERPOLATED_PERSISTENCE_FIELD).setMandatory(true);
            definition.addDynFieldInt(ERROR_COLOR_PERSISTENCE_FIELD).setMandatory(false);
            definition.addDynFieldString(NAME_PERSISTENCE_FIELD).setMandatory(false);
            definition.addDynFieldList(RANGE_PERSISTENCE_FIELD).setClassOfItems(Double.class).setMandatory(false);
            definition.addDynFieldList(NAME_CLASS_PERSISTENCE_FIELD).setClassOfItems(String.class).setMandatory(false);
            definition.addDynFieldList(CLASSES_PERSISTENCE_FIELD).setClassOfItems(ColorTableClass.class).setMandatory(false);
            definition.addDynFieldList(PALETTE_BY_BAND_PERSISTENCE_FIELD).setClassOfItems(String.class).setMandatory(false);
        }
    }

    private boolean isNamePath(String name) {
        return name.contains(File.pathSeparator) || name.contains(".");
    }

    public byte[] getRGBA(Object value) {
        Number number = null;
        if (value instanceof Number) {
            number = (Number)value;
            for (int i = 1; i <= this.classValues.length; ++i) {
                if (i < this.classValues.length) {
                    if (!(number.doubleValue() < this.classValues[i])) continue;
                    return (byte[])this.paletteByBand[i - 1].clone();
                }
                return (byte[])this.paletteByBand[i - 1].clone();
            }
            return new byte[4];
        }
        throw new IllegalArgumentException("Value has to be a number");
    }

    public Object clone() throws CloneNotSupportedException {
        ColorTable cloned = (ColorTable)super.clone();
        cloned.copyFrom((ColorTable)this);
        return cloned;
    }

    public void update(Observable observable, Object notification) {
        Notification colorTableClassNotification;
        if (notification instanceof ColorTableClassNotification && observable instanceof ColorTableClass && ((colorTableClassNotification = (Notification)notification).getType().equals("setted_color_in_class_notification") || colorTableClassNotification.getType().equals("setted_interpolated_in_class_notification") || colorTableClassNotification.getType().equals("setted_name_in_class_notification") || colorTableClassNotification.getType().equals("setted_value_in_class_notification"))) {
            this.notifyObservers((Object)new DefaultColorTableNotification("setted_class_values_color_table_notification", new Object[]{observable}));
        }
    }
}

