/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.io;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.raster.lib.legend.api.colortable.ColorTableIO;
import org.gvsig.raster.lib.legend.api.colortable.ColorTableIOFactory;
import org.gvsig.raster.lib.legend.impl.io.GimpGradientColorTableIO;

public class GimpGradientColorTableIOFactory
implements ColorTableIOFactory {
    public static final String DESCRIPTION = "Gimp Gradient";
    public static final String DEFAULT_EXTENSION = "ggr";

    public String getName() {
        return "GimpGradientColorTableIO";
    }

    public ColorTableIO create() {
        return new GimpGradientColorTableIO();
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FilenameUtils.getExtension((String)file.getAbsolutePath());
        return extension.equalsIgnoreCase(DEFAULT_EXTENSION);
    }

    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public String getDescription() {
        return DESCRIPTION;
    }
}

