/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.csv;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.exception.ResourceExecuteException;
import org.gvsig.fmap.dal.resource.file.FileResource;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.AbsolutePathRequiredException;
import org.gvsig.fmap.dal.store.csv.CSVFeatureWriter;
import org.gvsig.fmap.dal.store.csv.CSVNewStoreParameters;
import org.gvsig.fmap.dal.store.csv.CSVStoreParameters;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderFilesystemServerProvider;
import org.gvsig.tools.dynobject.DynObject;
import org.supercsv.comment.CommentMatcher;
import org.supercsv.comment.CommentStartsWith;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.quote.QuoteMode;

public class CSVFilesystemServerProvider
extends SimpleReaderFilesystemServerProvider {
    public String getDataStoreProviderName() {
        return "CSV";
    }

    public String getDescription() {
        return "CSV file";
    }

    protected String getFileExtension() {
        return ".csv";
    }

    public DataStoreParameters getParameters(File file) throws DataException {
        DataManager manager = DALLocator.getDataManager();
        CSVStoreParameters params = (CSVStoreParameters)manager.createStoreParameters(this.getDataStoreProviderName());
        params.setFile(file);
        return params;
    }

    public boolean canCreate() {
        return true;
    }

    public boolean canCreate(NewDataStoreParameters parameters) {
        CSVNewStoreParameters params = (CSVNewStoreParameters)parameters;
        if (params.getFile().getParentFile().canWrite()) {
            return false;
        }
        if (params.getFile().exists() && !params.getFile().canWrite()) {
            return false;
        }
        return params.getDefaultFeatureType() != null;
    }

    public void create(NewDataStoreParameters parameters, boolean overwrite) throws CreateException {
        FileResource resource;
        final CSVNewStoreParameters params = (CSVNewStoreParameters)parameters;
        final File file = params.getFile();
        if (!file.isAbsolute()) {
            throw new AbsolutePathRequiredException(file.getPath());
        }
        if (file.exists() && !overwrite) {
            throw new CreateException(this.getDataStoreProviderName(), (Throwable)new IOException("file already exist"));
        }
        try {
            resource = (FileResource)this.serverExplorer.getServerExplorerProviderServices().createResource("file", new Object[]{file.getAbsolutePath()});
        }
        catch (InitializeException e1) {
            throw new CreateException(params.getFile().getAbsolutePath(), (Throwable)e1);
        }
        resource.addConsumer((ResourceConsumer)this);
        try {
            resource.execute(new ResourceAction(){

                public Object run() throws Exception {
                    CSVFeatureWriter writer = new CSVFeatureWriter();
                    CSVNewStoreParameters newparams = params;
                    CsvPreference defaultPreference = CSVStoreParameters.getPredefinedCSVPreferences((DynObject)newparams);
                    String s = CSVStoreParameters.getQuoteCharacter((DynObject)params);
                    char quoteChar = StringUtils.isBlank((CharSequence)s) ? (char)defaultPreference.getQuoteChar() : s.charAt(0);
                    s = CSVStoreParameters.getDelimiter((DynObject)newparams);
                    int delimiterChar = StringUtils.isBlank((CharSequence)s) ? defaultPreference.getDelimiterChar() : (int)s.charAt(0);
                    String endOfLineSymbols = CSVStoreParameters.getRecordSeparator((DynObject)params);
                    if (StringUtils.isBlank((CharSequence)endOfLineSymbols)) {
                        endOfLineSymbols = defaultPreference.getEndOfLineSymbols();
                    }
                    CsvPreference.Builder builder = new CsvPreference.Builder(quoteChar, delimiterChar, endOfLineSymbols);
                    s = CSVStoreParameters.getCommentStartMarker((DynObject)newparams);
                    if (!StringUtils.isBlank((CharSequence)s)) {
                        CommentStartsWith cs = new CommentStartsWith(s);
                        builder.skipComments((CommentMatcher)cs);
                    }
                    builder.surroundingSpacesNeedQuotes(true);
                    QuoteMode quoteMode = CSVStoreParameters.getQuoteMode((DynObject)newparams);
                    if (quoteMode != null) {
                        builder.useQuoteMode(quoteMode);
                    }
                    CsvPreference csvpreferences = builder.build();
                    writer.initialize(params, file.getAbsoluteFile(), (FeatureType)params.getDefaultFeatureType(), csvpreferences);
                    writer.begin();
                    writer.end();
                    resource.notifyChanges();
                    return null;
                }
            });
        }
        catch (ResourceExecuteException e) {
            throw new CreateException(this.getDataStoreProviderName(), (Throwable)e);
        }
        finally {
            resource.removeConsumer((ResourceConsumer)this);
        }
    }

    protected NewDataStoreParameters createInstanceNewDataStoreParameters() {
        return new CSVNewStoreParameters();
    }

    public NewDataStoreParameters getCreateParameters() {
        NewFeatureStoreParameters params = (NewFeatureStoreParameters)this.createInstanceNewDataStoreParameters();
        params.setDefaultFeatureType((FeatureType)this.serverExplorer.getServerExplorerProviderServices().createNewFeatureType());
        return params;
    }
}

