/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.addlayer.AddLayerDialog;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.serverexplorer.filesystem.swing.FilesystemExplorerWizardPanel;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddLayer
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(AddLayer.class);
    private static ArrayList<Class<? extends WizardPanel>> wizardStack = null;

    public static void addWizard(Class<? extends WizardPanel> wpClass) {
        wizardStack.add(wpClass);
    }

    private static WizardPanel getInstance(int i, MapControl mapControl) throws IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<? extends WizardPanel> wpClass = wizardStack.get(i);
        Object[] params = new Object[]{};
        WizardPanel wp = wpClass.getConstructor(new Class[0]).newInstance(params);
        wp.setMapCtrl(mapControl);
        wp.initWizard();
        return wp;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        return application.getActiveComponent(ViewDocument.class) != null;
    }

    public void postInitialize() {
        super.postInitialize();
    }

    public static void checkProjection(FLayer lyr, ViewPort viewPort) {
        if (lyr instanceof FLayers) {
            FLayers layers = (FLayers)lyr;
            for (int i = 0; i < layers.getLayersCount(); ++i) {
                AddLayer.checkProjection(layers.getLayer(i), viewPort);
            }
        }
        if (lyr instanceof FLyrVect) {
            FLyrVect lyrVect = (FLyrVect)lyr;
            IProjection proj = lyr.getProjection();
            if (proj == null) {
                lyrVect.setProjection(viewPort.getProjection());
                return;
            }
            if (proj != viewPort.getProjection()) {
                int option = JOptionPane.showConfirmDialog((Component)PluginServices.getMainFrame(), PluginServices.getText(AddLayer.class, (String)"reproyectar_aviso") + "\n" + PluginServices.getText(AddLayer.class, (String)"Capa") + ": " + lyrVect.getName(), PluginServices.getText(AddLayer.class, (String)"reproyectar_pregunta"), 0);
                if (option != 0) {
                    return;
                }
                ICoordTrans ct = proj.getCT(viewPort.getProjection());
                lyrVect.setCoordTrans(ct);
                System.err.println("coordTrans = " + proj.getAbrev() + " " + viewPort.getProjection().getAbrev());
            }
        }
    }

    public void execute(String actionCommand) {
        this.execute(actionCommand, null);
    }

    public void execute(String command, Object[] args) {
        Arguments arguments = Arguments.create((Object[])args);
        List files = arguments.getListOf(0, File.class);
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return;
        }
        ViewDocument document = view.getViewDocument();
        MapControl mapControl = view.getMapControl();
        this.doAddLayers(mapControl, mapControl.getMapContext(), files, arguments);
        mapControl.getMapContext().callLegendChanged();
        document.setModified(true);
    }

    public boolean isEnabled() {
        return true;
    }

    public static AddLayerDialog createAddLayerDialog(MapControl mapControl, MapContext mapContext, List<File> files) {
        return AddLayer.createAddLayerDialog(mapControl, mapContext, files, null);
    }

    public static AddLayerDialog createAddLayerDialog(MapControl mapControl, MapContext mapContext, List<File> files, Arguments args) {
        ApplicationManager application = ApplicationLocator.getManager();
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        AddLayerDialog fopen = new AddLayerDialog();
        Dimension preferredSize = fopen.getPreferredSize();
        String activeTab = null;
        for (Class<? extends WizardPanel> wpClass : wizardStack) {
            try {
                Object[] params = new Object[]{};
                WizardPanel wp = wpClass.getConstructor(new Class[0]).newInstance(params);
                application.message(i18nManager.getTranslation("Adding tab...") + wp.getTabName(), 1);
                wp.setMapCtrl(mapControl);
                wp.setMapContext(mapContext);
                wp.initWizard();
                if (wp instanceof FilesystemExplorerWizardPanel && files != null && !files.isEmpty()) {
                    FilesystemExplorerWizardPanel fswp = (FilesystemExplorerWizardPanel)wp;
                    fswp.addFiles(files);
                    activeTab = wp.getTabName();
                }
                if (wp.addArguments(args)) {
                    activeTab = wp.getTabName();
                }
                Dimension dim = wp.getPreferredSize();
                if (dim.height > preferredSize.height) {
                    preferredSize.height = dim.height;
                }
                if (dim.width > preferredSize.width) {
                    preferredSize.width = dim.width;
                }
                fopen.addWizardTab(wp.getTabName(), wp);
            }
            catch (Exception e) {
                logger.warn("Can't create layer open dialog.", (Throwable)e);
            }
        }
        if (args != null && args.contains("activateTab")) {
            activeTab = (String)args.get("activateTab");
        }
        fopen.setSelectedTab(activeTab);
        preferredSize.height += ToolsSwingUtils.rows2px((int)4);
        preferredSize.width += ToolsSwingUtils.cols2px((int)2);
        fopen.setPreferredSize(preferredSize);
        ToolsSwingUtils.ensureRowsCols((JComponent)fopen, (int)-1, (int)-1, (int)30, (int)100);
        application.message(null, 1);
        fopen.updateOkButtonState();
        return fopen;
    }

    public boolean addLayers(MapContext mapContext) {
        return this.doAddLayers(null, mapContext, null);
    }

    public boolean addLayers(MapControl mapControl) {
        return this.doAddLayers(mapControl, mapControl.getMapContext(), null, false, null);
    }

    public boolean addLayers(MapControl mapControl, boolean wait) {
        return this.doAddLayers(mapControl, mapControl.getMapContext(), null, wait, null);
    }

    private boolean doAddLayers(MapControl mapControl, MapContext mapContext, List<File> files) {
        return this.doAddLayers(mapControl, mapContext, files, null);
    }

    private boolean doAddLayers(MapControl mapControl, MapContext mapContext, List<File> files, Arguments args) {
        return this.doAddLayers(mapControl, mapContext, files, false, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doAddLayers(MapControl mapControl, MapContext mapContext, List<File> files, boolean wait, Arguments args) {
        block4: {
            addLayerDialog = null;
            try {
                addLayerDialog = AddLayer.createAddLayerDialog(mapControl, mapContext, files, args);
                screensize = ToolsSwingUtils.getCurrentScreenSize();
                ToolsSwingUtils.ensureHeightWitdh((JComponent)addLayerDialog, (int)(3 * (screensize.height / 4)), (int)(2 * (screensize.width / 4)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
                PluginServices.getMDIManager().addWindow((IWindow)addLayerDialog);
                if (!addLayerDialog.isAccepted()) ** GOTO lbl25
                if (!(addLayerDialog.getSelectedTab() instanceof WizardPanel)) break block4;
                panel = (WizardPanel)addLayerDialog.getSelectedTab();
                panel.executeWizard();
                if (wait) {
                    panel.waitTasks(0L);
                }
                var9_10 = true;
            }
            catch (Throwable var10_11) {
                DisposeUtils.disposeQuietly(addLayerDialog);
                throw var10_11;
            }
            DisposeUtils.disposeQuietly((Disposable)addLayerDialog);
            return var9_10;
        }
        JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"ninguna_capa_seleccionada"));
lbl25:
        // 2 sources

        var8_9 = false;
        DisposeUtils.disposeQuietly((Disposable)addLayerDialog);
        return var8_9;
    }

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"view-layer-add", (Object)((Object)this));
    }

    static {
        wizardStack = new ArrayList();
        AddLayer.addWizard(FilesystemExplorerWizardPanel.class);
    }
}

