/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.actioninfo.ActionInfoManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.DefaultFeatureTypeDefinitionsManager;
import org.gvsig.app.extension.OpenLayerOnStart;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.ProjectPreferences;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.app.project.documents.view.toolListeners.InfoListener;
import org.gvsig.app.util.BaseOpenErrorHandler;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerPool;
import org.gvsig.fmap.dal.DataServerExplorerPoolEntry;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.OpenErrorHandler;
import org.gvsig.fmap.dal.resource.ResourceManager;
import org.gvsig.fmap.dal.resource.exception.DisposeResorceManagerException;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.resourcesstorage.FilesResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeApplicationExtension
extends Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitializeApplicationExtension.class);
    public static final String PROJECTS_FOLDER_PROPERTY_NAME = "ProjectsFolder";
    public static final String DATA_FOLDER_PROPERTY_NAME = "DataFolder";
    public static final String TEMPLATES_FOLDER_PROPERTY_NAME = "TemplatesFolder";
    public static final String SYMBOL_LIBRARY_FOLDER_PROPERTY_NAME = "SymbolLibraryFolder";
    private OpenErrorHandler openErrorHandler = null;

    public void initialize() {
        PluginsManager pluginmgr = PluginsLocator.getManager();
        File folder = pluginmgr.getApplicationHomeFolder();
        File storageFolder = new File(folder, "localresources");
        DALLocator.getDataManager().setLocalResourcesFolder(storageFolder);
        DALLocator.registerFeatureTypeDefinitionsManager(DefaultFeatureTypeDefinitionsManager.class);
        ExpressionEvaluatorLocator.getManager().registerClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        InfoListener.initializeExtensionPoint();
        this.initLastPath();
        this.registerIcons();
    }

    private void loadHistoryAndBookmarks() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ApplicationManager application = ApplicationLocator.getManager();
        application.message(i18n.getTranslation("_loading_history_and_bookmarks"), 1);
        PluginsManager pluginmgr = PluginsLocator.getManager();
        File folder = pluginmgr.getApplicationHomeFolder();
        String nameFolder = "bookmarks";
        File storageFolder = new File(folder, nameFolder);
        try {
            if (!storageFolder.exists()) {
                storageFolder.mkdir();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Not able to create bookmarks folder. Load and save of bookmarks will be deactivated", (Throwable)ex);
            return;
        }
        FilesResourcesStorage bookmarksResources = new FilesResourcesStorage(storageFolder.getAbsolutePath());
        ToolsLocator.getBookmarksAndHistoryManager().setPrimaryStorage((ResourcesStorage)bookmarksResources);
        ToolsLocator.getBookmarksAndHistoryManager().load();
        PluginsManager pluginManager = PluginsLocator.getManager();
        pluginManager.addShutdownTask("saveBookmarksAndHistory", () -> ToolsLocator.getBookmarksAndHistoryManager().save(), false, 100);
    }

    private void initLastPath() {
        Preferences prefs = Preferences.userRoot().node("gvsig.foldering");
        FoldersManager folderManager = ToolsLocator.getFoldersManager();
        String v = prefs.get(DATA_FOLDER_PROPERTY_NAME, folderManager.getHome().getAbsolutePath());
        folderManager.setLastPath("OPEN_LAYER_FILE_CHOOSER_ID", new File(v));
        v = prefs.get(PROJECTS_FOLDER_PROPERTY_NAME, folderManager.getHome().getAbsolutePath());
        folderManager.setLastPath("PROJECT_FILECHOOSER_ID", new File(v));
        v = prefs.get("LegendsFolder", folderManager.getHome().getAbsolutePath());
        folderManager.setLastPath("LegendsFolder", new File(v));
        try {
            PluginsManager pluginManager = PluginsLocator.getPluginsManager();
            PluginServices plugin = pluginManager.getPlugin((Object)this);
            DynObject preferences = plugin.getPluginProperties();
            Map paths = (Map)preferences.getDynValue("folderManagerPaths");
            if (paths != null) {
                for (Map.Entry path : paths.entrySet()) {
                    String name = (String)path.getKey();
                    String path_s = (String)path.getValue();
                    folderManager.set(name, new File(path_s));
                }
            }
            pluginManager.addShutdownTask("saveFolderManagerPaths", () -> this.doFolderManagerPaths(), false, 100);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't restore folder manager paths.", (Throwable)ex);
        }
    }

    public void postInitialize() {
        PluginsManager pluginManager = PluginsLocator.getManager();
        this.openErrorHandler = new BaseOpenErrorHandler();
        ApplicationLocator.getManager().getDataManager().setOpenErrorHandler(this.openErrorHandler);
        DALLocator.getResourceManager().startResourceCollector(180000L, null);
        ProjectPreferences projectPreferences = ApplicationLocator.getProjectManager().getProjectPreferences();
        if (projectPreferences.getOpenWithANewMaximizedView()) {
            pluginManager.addStartupTask("showNewViewMaximized", (Runnable)new ShowNewMaximizedView(), true, 750);
        }
        pluginManager.addStartupTask("OpenLayerOnStart", (Runnable)new OpenLayerOnStart(), true, 740);
        pluginManager.addStartupTask("ApplicationStartedMessage", new Runnable(){

            @Override
            public void run() {
                I18nManager i18n = ToolsLocator.getI18nManager();
                ApplicationManager application = ApplicationLocator.getManager();
                application.message(i18n.getTranslation("StatusBar.Aplicacion_iniciada"), 1);
            }
        }, true, -1);
        pluginManager.addStartupTask("ConnectoToDefaultWorkspace", () -> this.connectToDefaultWorkspace(), false, 500);
        pluginManager.addStartupTask("InitializeHistoryAndBookmarks", new Runnable(){

            @Override
            public void run() {
                InitializeApplicationExtension.this.loadHistoryAndBookmarks();
            }
        }, false, 100);
    }

    private void connectToDefaultWorkspace() {
        String workspaceName = null;
        try {
            DataManager dataManager = DALLocator.getDataManager();
            PluginsManager pluginManager = PluginsLocator.getPluginsManager();
            PluginServices plugin = pluginManager.getPlugin((Object)this);
            DynObject preferences = plugin.getPluginProperties();
            if (((Boolean)preferences.getDynValue("connectAutomaticallyToDatabaseWorkspace")).booleanValue()) {
                workspaceName = (String)preferences.getDynValue("databaseWorkspaceToConnect");
                DataServerExplorerPool pool = dataManager.getDataServerExplorerPool();
                DataServerExplorerPoolEntry entry = pool.get(workspaceName);
                if (entry != null) {
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    ApplicationManager application = ApplicationLocator.getManager();
                    application.message(i18n.getTranslation("_connecting_to_repository") + " (" + workspaceName + ")", 1);
                    DatabaseWorkspaceManager workspace = dataManager.createDatabaseWorkspaceManager(entry.getExplorerParameters());
                    if (workspace != null && workspace.isValid()) {
                        workspace.connect();
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't connect to default workspace (" + Objects.toString(workspaceName) + ").", (Throwable)ex);
        }
    }

    private void showAddOnManagerOnStartIfNeed() {
        Boolean showAddOnmanagerOnStartForCurrentVersion;
        PluginsManager pluginManager = PluginsLocator.getManager();
        PluginServices plugin = pluginManager.getPlugin((Object)this);
        DynObject pluginProperties = plugin.getPluginProperties();
        HashMap showAddOnmanagerOnStart = null;
        try {
            showAddOnmanagerOnStart = (HashMap)pluginProperties.getDynValue("showAddOnmanagerOnStart");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (showAddOnmanagerOnStart == null) {
            showAddOnmanagerOnStart = new HashMap();
            pluginProperties.setDynValue("showAddOnmanagerOnStart", showAddOnmanagerOnStart);
        }
        if ((showAddOnmanagerOnStartForCurrentVersion = (Boolean)showAddOnmanagerOnStart.get(pluginManager.getApplicationVersion().fullFormat())) == null || showAddOnmanagerOnStartForCurrentVersion.booleanValue()) {
            pluginManager.addStartupTask("showAddOnmanagerOnStart", (Runnable)new ShowAddOnManagerOnStart(), true, 500);
        }
    }

    private void doFolderManagerPaths() {
        FoldersManager folderManager = ToolsLocator.getFoldersManager();
        PluginsManager pluginManager = PluginsLocator.getPluginsManager();
        PluginServices plugin = pluginManager.getPlugin((Object)this);
        DynObject preferences = plugin.getPluginProperties();
        HashMap<String, String> paths = new HashMap<String, String>();
        for (String name : folderManager) {
            File f = folderManager.get(name);
            if (f == null) continue;
            paths.put(name, f.getAbsolutePath());
        }
        preferences.setDynValue("folderManagerPaths", paths);
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"edit-clear", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-copy", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-cut", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-delete", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-find", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-find-replace", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-paste", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-redo", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-select-all", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-undo", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-undo-redo-actions", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"document-print", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"addlayer", (String)"addlayer-crstoview", (Object)((Object)this));
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getDefault();
        iconTheme.setGroupDescription("action", "Images in the 'action' group are associated with menus and toolbar buttons.");
    }

    public void execute(String actionCommand) {
    }

    public boolean isEnabled() {
        return false;
    }

    public boolean isVisible() {
        return false;
    }

    private void addToLogInfo() {
        String[] info;
        for (String line : info = this.getStringInfo().split("\n")) {
            LOGGER.info(line);
        }
    }

    public String getStringInfo() {
        ApplicationManager application = ApplicationLocator.getManager();
        PluginsManager pluginmgr = PluginsLocator.getManager();
        InstallerManager installmgr = InstallerLocator.getInstallerManager();
        StringWriter writer = new StringWriter();
        Properties props = System.getProperties();
        String osName = props.getProperty("os.name");
        writer.write("OS\n");
        writer.write("    name   : " + osName + "\n");
        writer.write("    arch   : " + props.get("os.arch") + "\n");
        writer.write("    version: " + props.get("os.version") + "\n");
        if (osName.startsWith("Linux")) {
            try {
                String line;
                String[] command = new String[]{"lsb_release", "-a"};
                Process p = Runtime.getRuntime().exec(command);
                InputStream is = p.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                while ((line = reader.readLine()) != null) {
                    writer.write("    " + line + "\n");
                }
            }
            catch (Exception ex) {
                writer.write("Can't get detailled os information (lsb_release -a).");
            }
        }
        writer.write("JRE\n");
        writer.write("    vendor : " + props.get("java.vendor") + "\n");
        writer.write("    version: " + props.get("java.version") + "\n");
        writer.write("    home   : " + props.get("java.home") + "\n");
        writer.write("gvSIG\n");
        writer.write("    version                 : " + application.getVersion().getLongFormat() + "\n");
        writer.write("    locale language         : " + application.getLocaleLanguage() + "\n");
        writer.write("    application forlder     : " + pluginmgr.getApplicationFolder() + "\n");
        writer.write("    install forlder         : " + pluginmgr.getInstallFolder() + "\n");
        writer.write("    application home forlder: " + pluginmgr.getApplicationHomeFolder() + "\n");
        writer.write("    plugins forlder         : " + StringUtils.join((Object[])new List[]{pluginmgr.getPluginsFolders()}) + "\n");
        try {
            PackageInfo[] pkgs = installmgr.getInstalledPackages();
            writer.write("Installed packages\n");
            for (PackageInfo pkg : pkgs) {
                writer.write("    ");
                writer.write(pkg.toStringCompact());
                writer.write("\n");
            }
        }
        catch (Throwable e) {
            writer.write("Can't get installed package information.");
        }
        return writer.toString();
    }

    public void terminate() {
        ResourceManager resMan = DALLocator.getResourceManager();
        resMan.stopResourceCollector();
        try {
            resMan.dispose();
        }
        catch (DisposeResorceManagerException e) {
            LOGGER.warn(e.getMessageStack());
        }
        super.terminate();
    }

    private static class ShowAddOnManagerOnStart
    implements Runnable {
        private ShowAddOnManagerOnStart() {
        }

        @Override
        public void run() {
            ApplicationManager application = ApplicationLocator.getManager();
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            PluginsManager pluginManager = PluginsLocator.getManager();
            PluginServices plugin = pluginManager.getPlugin((Object)this);
            DynObject pluginProperties = plugin.getPluginProperties();
            String msg = i18nManager.getTranslation("_Instalar_complementos_adicionales_no_disponibles_durante_el_proceso_de_instalacion");
            int resp = application.confirmDialog(msg, i18nManager.getTranslation("_Finalizando_proceso_de_instalacion"), 0, 3);
            if (resp == 0) {
                ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
                actionManager.execute("tools-addonsmanager", new Object[]{"skipBundleSelection"});
            }
            Map showAddOnmanagerOnStart = (Map)pluginProperties.getDynValue("showAddOnmanagerOnStart");
            showAddOnmanagerOnStart.put(pluginManager.getApplicationVersion().fullFormat(), Boolean.FALSE);
        }
    }

    private static class ShowNewMaximizedView
    implements Runnable {
        private ShowNewMaximizedView() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ApplicationManager application = ApplicationLocator.getManager();
            ProjectManager projectManager = application.getProjectManager();
            Project project = projectManager.getCurrentProject();
            ViewManager viewManager = (ViewManager)projectManager.getDocumentManager(ViewManager.TYPENAME);
            ViewDocument view = (ViewDocument)((Object)viewManager.createDocument());
            try {
                project.addDocument(view);
                IView viewWindow = (IView)viewManager.getMainWindow(view);
                application.getUIManager().addWindow((IWindow)viewWindow, 10);
                try {
                    application.getUIManager().setMaximum((IWindow)viewWindow, true);
                }
                catch (PropertyVetoException e) {
                    LOGGER.info("Can't maximize view.", (Throwable)e);
                }
                project.setModified(false);
            }
            finally {
                DisposeUtils.disposeQuietly((Object)view);
            }
        }
    }
}

