/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.util.Collections;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.searchpanel.FeatureStoreSearchPanel;
import org.gvsig.fmap.dal.swing.searchpanel.SearchParameters;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class SearchByAttributesExtension
extends Extension {
    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"search-by-attributes-layer", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"filter-by-attributes-layer", (Object)((Object)this));
    }

    public void postInitialize() {
        ProjectManager projectManager = ProjectManager.getInstance();
        ViewManager viewManager = (ViewManager)projectManager.getDocumentManager(ViewManager.TYPENAME);
        viewManager.addTOCContextAction("search-by-attributes-layer", "group2", 20, 10);
        viewManager.addTOCContextAction("filter-by-attributes-layer", "group2", 20, 11);
    }

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return;
        }
        if ("search-by-attributes-layer".equals(actionCommand)) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            ViewDocument document = view.getViewDocument();
            FLayer layer = document.getMapContext().getLayers().getActives()[0];
            String title = i18n.getTranslation("search") + ": " + layer.getName();
            FeatureStore featureStore = ((FLyrVect)layer).getFeatureStore();
            try {
                FeatureType type = featureStore.getDefaultFeatureType();
                if (!type.supportReferences()) {
                    ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs.messageDialog(i18n.getTranslation("_The_table_has_no_primary_key_or_OID") + "\n" + i18n.getTranslation("_Many_features_selection_deletion_modification_will_not_be_available_as_they_require_it_for_proper_operation"), null, i18n.getTranslation("_Warning"), 2, "TableDoNotSupportReferences");
                }
            }
            catch (Exception ex) {
                logger.debug("Error in search by attributes leyer.", (Throwable)ex);
            }
            FeatureStoreSearchPanel panel = dataSwingManager.createFeatureStoreSearchPanel(featureStore);
            ToolsSwingUtils.ensureHeightWitdh((Component)panel, (int)1, (float)0.75f, (float)0.75f, (float)0.85f, (float)0.85f);
            winManager.showWindow(panel.asJComponent(), title, WindowManager.MODE.WINDOW, Collections.singletonMap("align", 10));
        } else if ("filter-by-attributes-layer".equals(actionCommand)) {
            this.doFilter();
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        return document.getMapContext().hasActiveVectorLayers();
    }

    private void doFilter() {
        ApplicationManager application = ApplicationLocator.getManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return;
        }
        ViewDocument document = view.getViewDocument();
        FLyrVect layer = (FLyrVect)document.getMapContext().getLayers().getActives()[0];
        String title = i18n.getTranslation("Filter") + ": " + layer.getName();
        FeatureStore featureStore = layer.getFeatureStore();
        FeatureStoreSearchPanel builderPanel = dataSwingManager.createFeatureStoreSearchPanel(featureStore);
        try {
            builderPanel.setFilterOnlyMode(true);
        }
        catch (Exception ex) {
            return;
        }
        ToolsSwingUtils.ensureHeightWitdh((Component)builderPanel, (int)1, (float)0.75f, (float)0.75f, (float)0.85f, (float)0.85f);
        Dialog dialog = winManager.createDialog(builderPanel.asJComponent(), title, null, 3);
        dialog.show(WindowManager.MODE.WINDOW);
        if (dialog.getAction() == 1) {
            SearchParameters params = builderPanel.fetch(null);
            FeatureQuery query = params.getQuery().getCopy();
            FeatureQuery layerQuery = null;
            if (query != null) {
                Expression expFilter = query.getExpressionFilter();
                if (expFilter != null && !expFilter.isEmpty()) {
                    if (layerQuery == null) {
                        layerQuery = featureStore.createFeatureQuery();
                    }
                    layerQuery.addFilter(expFilter);
                    layerQuery.retrievesAllAttributes();
                }
                if (query.hasOrder()) {
                    if (layerQuery == null) {
                        layerQuery = featureStore.createFeatureQuery();
                    }
                    layerQuery.getOrder().copyFrom(query.getOrder());
                }
                if (layerQuery == null) {
                    layer.setBaseQuery(null);
                } else {
                    layer.setBaseQuery(layerQuery);
                }
            }
        }
        layer.getMapContext().invalidate();
    }
}

