/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.exception.BaseException;

public class ZoomToSelectViewExtension
extends Extension {
    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"view-navigation-zoom-to-selection", (Object)((Object)this));
    }

    public void execute(String s) {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return;
        }
        ViewDocument document = view.getViewDocument();
        MapContext mapa = document.getMapContext();
        try {
            Envelope selectedExtent = mapa.getSelectionBounds();
            mapa.zoomToEnvelope(selectedExtent);
        }
        catch (BaseException e) {
            String msg = "Can't zoom to the seleccion.";
            logger.warn(msg, (Throwable)e);
            application.message(msg, 2);
        }
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument document = (ViewDocument)application.getActiveDocument(ViewDocument.class);
        if (document == null) {
            return false;
        }
        return document.getMapContext().getLayers().getLayersCount() > 0;
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        if (document == null) {
            return false;
        }
        boolean hasActiveVectorLayers = false;
        boolean hasSelection = false;
        for (FLayer layer : document.getMapContext().getLayers().getActives()) {
            if (!layer.isActive() || !layer.isAvailable() || !(layer instanceof FLyrVect)) continue;
            try {
                hasActiveVectorLayers = true;
                FeatureStore store = ((FLyrVect)layer).getFeatureStore();
                if (!store.isFeatureSelectionAvailable() || store.isFeatureSelectionEmpty()) continue;
                hasSelection = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hasActiveVectorLayers && hasSelection;
    }
}

