/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.copytable;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gvsig.app.extension.copytable.CopyTable2ProcessParameters;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyTable2ProcessParametersImpl
extends AbstractDisposable
implements CopyTable2ProcessParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyTable2ProcessParametersImpl.class);
    private DataStoreParameters sourceStoreParams;
    private DataStoreParameters targetStoreParams;
    private Expression sourceFilter = null;
    private FeatureStore sourceStore = null;
    private FeatureStore targetStore;
    private Map<String, CopyTable2ProcessParameters.ProcessFieldParameters> fields = new LinkedHashMap<String, CopyTable2ProcessParameters.ProcessFieldParameters>();
    private int editMode;
    private int finishAndRestarEditEach;
    private boolean finishAndRestarEdit;
    private boolean beginEditIfNeed;
    private boolean finishEditAfterTerminate;
    private boolean notifyUserIfNeedBeginEditing;
    private boolean mustUpdateWhenSourceAndTargetAreNotEquals = false;
    private String sourceFieldJoin;
    private String targetFieldJoin;
    private boolean insertIfNotExistsTarget;
    private boolean updateIfExistsTarget;
    private boolean deleteIfNotExiststInSource;
    private Expression updateIfExistsInTargetCondition;
    private Expression joinExpression;

    protected void doDispose() throws BaseException {
        DisposeUtils.dispose((Disposable)this.sourceStore);
        DisposeUtils.dispose((Disposable)this.targetStore);
        this.sourceStore = null;
        this.targetStore = null;
        this.sourceFilter = null;
    }

    @Override
    public CopyTable2ProcessParameters add(String name, boolean copyField, Expression expression) {
        ProcessFieldParametersImpl x = new ProcessFieldParametersImpl(name, copyField, expression);
        this.fields.put(name, x);
        return this;
    }

    @Override
    public CopyTable2ProcessParameters.ProcessFieldParameters get(String name) {
        return this.fields.get(name);
    }

    @Override
    public Iterator<CopyTable2ProcessParameters.ProcessFieldParameters> iterator() {
        return this.fields.values().iterator();
    }

    @Override
    public CopyTable2ProcessParameters setSourceStore(FeatureStore store) {
        DisposeUtils.dispose((Disposable)this.sourceStore);
        this.sourceStore = store;
        DisposeUtils.bind((Disposable)this.sourceStore);
        return this;
    }

    @Override
    public FeatureStore getSourceStore() {
        if (this.sourceStore == null) {
            DataManager dataManager = DALLocator.getDataManager();
            if (this.sourceStoreParams != null && this.sourceStoreParams instanceof DataStoreParameters) {
                try {
                    this.sourceStore = (FeatureStore)dataManager.openStore(this.sourceStoreParams.getProviderName(), this.sourceStoreParams);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't open source store '" + this.sourceStoreParams.getDescription() + "'", (Throwable)ex);
                }
            }
        }
        return this.sourceStore;
    }

    @Override
    public Expression getSourceFilter() {
        return this.sourceFilter;
    }

    @Override
    public CopyTable2ProcessParameters setSourceFilter(Expression filter) {
        this.sourceFilter = filter;
        return this;
    }

    @Override
    public int getEditMode() {
        return this.editMode;
    }

    @Override
    public CopyTable2ProcessParameters setEditMode(int editMode) {
        this.editMode = editMode;
        return this;
    }

    @Override
    public int getFinishAndRestarEditEach() {
        return this.finishAndRestarEditEach;
    }

    @Override
    public CopyTable2ProcessParameters setFinishAndRestarEditEach(int finishAndRestarEditEach) {
        this.finishAndRestarEditEach = finishAndRestarEditEach;
        return this;
    }

    @Override
    public boolean isBeginEditIfNeed() {
        return this.beginEditIfNeed;
    }

    @Override
    public CopyTable2ProcessParameters setBeginEditIfNeed(boolean beginEditIfNeed) {
        this.beginEditIfNeed = beginEditIfNeed;
        return this;
    }

    @Override
    public boolean isFinishEditAfterTerminate() {
        return this.finishEditAfterTerminate;
    }

    @Override
    public CopyTable2ProcessParameters setFinishEditAfterTerminate(boolean finishEditAfterTerminate) {
        this.finishEditAfterTerminate = finishEditAfterTerminate;
        return this;
    }

    @Override
    public boolean isNotifyUserIfNeedBeginEditing() {
        return this.notifyUserIfNeedBeginEditing;
    }

    @Override
    public CopyTable2ProcessParameters setNotifyUserIfNeedBeginEditing(boolean notifyUserIfNeedBeginEditing) {
        this.notifyUserIfNeedBeginEditing = notifyUserIfNeedBeginEditing;
        return this;
    }

    @Override
    public boolean isFinishAndRestarEdit() {
        return this.finishAndRestarEdit;
    }

    @Override
    public CopyTable2ProcessParameters setFinishAndRestarEdit(boolean finishAndRestarEdit) {
        this.finishAndRestarEdit = finishAndRestarEdit;
        return this;
    }

    @Override
    public FeatureStore getTargetStore() {
        if (this.targetStore == null) {
            DataManager dataManager = DALLocator.getDataManager();
            if (this.targetStoreParams != null && this.targetStoreParams instanceof DataStoreParameters) {
                try {
                    this.targetStore = (FeatureStore)dataManager.openStore(this.targetStoreParams.getProviderName(), this.targetStoreParams);
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't open source store '" + this.targetStoreParams.getDescription() + "'", (Throwable)ex);
                }
            }
        }
        return this.targetStore;
    }

    @Override
    public boolean isInsertIfNotExistsTargetActive() {
        return this.insertIfNotExistsTarget;
    }

    @Override
    public boolean isUpdateIfExistsTargetActive() {
        return this.updateIfExistsTarget;
    }

    @Override
    public boolean isDeleteIfNotExiststInSourceActive() {
        return this.deleteIfNotExiststInSource;
    }

    @Override
    public String getSourceFieldForJoin() {
        return this.sourceFieldJoin;
    }

    @Override
    public String getTargetFieldForJoin() {
        return this.targetFieldJoin;
    }

    @Override
    public Expression getUpdateIfExistsInTargetCondition() {
        return this.updateIfExistsInTargetCondition;
    }

    @Override
    public CopyTable2ProcessParameters setTargetStore(FeatureStore store) {
        DisposeUtils.dispose((Disposable)this.targetStore);
        this.targetStore = store;
        DisposeUtils.bind((Disposable)this.targetStore);
        return this;
    }

    @Override
    public CopyTable2ProcessParameters setInsertIfNotExistsTargetActive(boolean active) {
        this.insertIfNotExistsTarget = active;
        return this;
    }

    @Override
    public CopyTable2ProcessParameters setUpdateIfExistsTargetActive(boolean active) {
        this.updateIfExistsTarget = active;
        return this;
    }

    @Override
    public CopyTable2ProcessParameters setSourceFieldForJoin(String fieldName) {
        this.sourceFieldJoin = fieldName;
        return this;
    }

    @Override
    public CopyTable2ProcessParameters setTargetFieldForJoin(String fieldName) {
        this.targetFieldJoin = fieldName;
        return this;
    }

    @Override
    public CopyTable2ProcessParameters setUpdateIfExistsInTargetCondition(Expression condition) {
        this.updateIfExistsInTargetCondition = condition;
        return this;
    }

    @Override
    public CopyTable2ProcessParameters setDeleteIfNotExiststInSourceActive(boolean active) {
        this.deleteIfNotExiststInSource = active;
        return this;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("sourceFilter", (Persistent)this.sourceFilter);
        if (this.sourceStore != null) {
            state.set("sourceStoreParams", (Persistent)this.sourceStore.getParameters());
        } else {
            state.setNull("sourceStoreParams");
        }
        if (this.targetStore != null) {
            state.set("targetStoreParams", (Persistent)this.targetStore.getParameters());
        } else {
            state.setNull("targetStoreParams");
        }
        state.set("fields", this.fields);
        state.set("editMode", this.editMode);
        state.set("finishAndRestarEditEach", this.finishAndRestarEditEach);
        state.set("finishAndRestarEdit", this.finishAndRestarEdit);
        state.set("beginEditIfNeed", this.beginEditIfNeed);
        state.set("finishEditAfterTerminate", this.finishEditAfterTerminate);
        state.set("notifyUserIfNeedBeginEditing", this.notifyUserIfNeedBeginEditing);
        state.set("sourceFieldJoin", this.sourceFieldJoin);
        state.set("targetFieldJoin", this.targetFieldJoin);
        state.set("insertIfNotExistsTarget", this.insertIfNotExistsTarget);
        state.set("updateIfExistsTarget", this.updateIfExistsTarget);
        state.set("deleteIfNotExiststInSource", this.deleteIfNotExiststInSource);
        state.set("updateIfExistsInTargetCondition", (Persistent)this.updateIfExistsInTargetCondition);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.sourceFilter = (Expression)state.get("sourceFilter");
        this.sourceStoreParams = (DataStoreParameters)state.get("sourceStoreParams");
        this.targetStoreParams = (DataStoreParameters)state.get("targetStoreParams");
        this.fields = state.getMap("fields");
        this.editMode = state.getInt("editMode");
        this.finishAndRestarEditEach = state.getInt("finishAndRestarEditEach");
        this.finishAndRestarEdit = state.getBoolean("finishAndRestarEdit");
        this.beginEditIfNeed = state.getBoolean("beginEditIfNeed");
        this.finishEditAfterTerminate = state.getBoolean("finishEditAfterTerminate");
        this.notifyUserIfNeedBeginEditing = state.getBoolean("notifyUserIfNeedBeginEditing");
        this.sourceFieldJoin = state.getString("sourceFieldJoin");
        this.targetFieldJoin = state.getString("targetFieldJoin");
        this.insertIfNotExistsTarget = state.getBoolean("insertIfNotExistsTarget");
        this.updateIfExistsTarget = state.getBoolean("updateIfExistsTarget");
        this.deleteIfNotExiststInSource = state.getBoolean("deleteIfNotExiststInSource");
        this.updateIfExistsInTargetCondition = (Expression)state.get("updateIfExistsInTargetCondition");
    }

    public static void selfRegister() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.addDefinition(CopyTable2ProcessParametersImpl.class, "CopyTable2ProcessParameters", "CopyTable2ProcessParameters Persistence definition", null, null);
        ProcessFieldParametersImpl.selfRegister();
        definition.addDynFieldObject("sourceStoreParams").setClassOfValue(DataParameters.class).setMandatory(true);
        definition.addDynFieldObject("targetStoreParams").setClassOfValue(DataParameters.class).setMandatory(true);
        definition.addDynFieldObject("sourceFilter").setClassOfValue(Expression.class).setMandatory(false);
        definition.addDynFieldObject("updateIfExistsInTargetCondition").setClassOfValue(Expression.class).setMandatory(false);
        definition.addDynFieldMap("fields").setClassOfItems(ProcessFieldParametersImpl.class).setMandatory(true);
        definition.addDynFieldInt("editMode").setMandatory(true);
        definition.addDynFieldInt("finishAndRestarEditEach").setMandatory(true);
        definition.addDynFieldBoolean("finishAndRestarEdit").setMandatory(true);
        definition.addDynFieldBoolean("beginEditIfNeed").setMandatory(true);
        definition.addDynFieldBoolean("finishEditAfterTerminate").setMandatory(true);
        definition.addDynFieldBoolean("notifyUserIfNeedBeginEditing").setMandatory(true);
        definition.addDynFieldString("sourceFieldJoin").setMandatory(true);
        definition.addDynFieldString("targetFieldJoin").setMandatory(true);
        definition.addDynFieldBoolean("insertIfNotExistsTarget").setMandatory(true);
        definition.addDynFieldBoolean("updateIfExistsTarget").setMandatory(true);
        definition.addDynFieldBoolean("deleteIfNotExiststInSource").setMandatory(true);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SOURCE: ");
        DataStoreParameters sourceParameters = this.getSourceStore().getParameters();
        if (sourceParameters instanceof JDBCStoreParameters) {
            builder.append(((JDBCStoreParameters)sourceParameters).getUrl());
            builder.append(" -> ");
            builder.append(((JDBCStoreParameters)sourceParameters).getTable());
        } else if (sourceParameters instanceof FilesystemStoreParameters) {
            builder.append(((FilesystemStoreParameters)sourceParameters).getFile().getAbsolutePath());
        }
        builder.append("\n");
        builder.append("TARGET: ");
        DataStoreParameters targetParameters = this.getTargetStore().getParameters();
        if (targetParameters instanceof JDBCStoreParameters) {
            builder.append(((JDBCStoreParameters)targetParameters).getUrl());
            builder.append(" -> ");
            builder.append(((JDBCStoreParameters)targetParameters).getTable());
        } else if (targetParameters instanceof FilesystemStoreParameters) {
            builder.append(((FilesystemStoreParameters)targetParameters).getFile().getAbsolutePath());
        }
        builder.append("\n");
        builder.append("FIELDS: ");
        for (Map.Entry<String, CopyTable2ProcessParameters.ProcessFieldParameters> entry : this.fields.entrySet()) {
            Expression expression;
            builder.append("\n");
            builder.append("  ");
            builder.append(entry.getKey());
            builder.append(": ");
            CopyTable2ProcessParameters.ProcessFieldParameters value = entry.getValue();
            if (value == null || (expression = value.getExpression()) == null) continue;
            builder.append(expression.getPhrase());
        }
        builder.append("\n");
        builder.append("EDIT MODE: ");
        builder.append(this.editMode);
        builder.append("\n");
        builder.append("FINISH AND RESTART EDIT EACH: ");
        builder.append(this.finishAndRestarEditEach);
        builder.append("\n");
        builder.append("FINISH AND RESTART EDIT: ");
        builder.append(this.finishAndRestarEdit);
        builder.append("\n");
        builder.append("BEGIN EDIT IF NEED: ");
        builder.append(this.beginEditIfNeed);
        builder.append("\n");
        builder.append("FINISH EDIT AFTER TERMINATE: ");
        builder.append(this.finishEditAfterTerminate);
        builder.append("\n");
        builder.append("NOTIFY USER IF NEED BEGIN EDITING: ");
        builder.append(this.notifyUserIfNeedBeginEditing);
        builder.append("\n");
        builder.append("SOURCE FIELD JOIN: ");
        builder.append(this.sourceFieldJoin);
        builder.append("\n");
        builder.append("TARGET FIELD JOIN: ");
        builder.append(this.targetFieldJoin);
        builder.append("\n");
        builder.append("INSERT IF NOT EXISTS TARGET: ");
        builder.append(this.insertIfNotExistsTarget);
        builder.append("\n");
        builder.append("UPDATE IF EXISTS TARGET: ");
        builder.append(this.updateIfExistsTarget);
        builder.append("\n");
        builder.append("DELETE IF NOT EXISTS IN SOURCE: ");
        builder.append(this.deleteIfNotExiststInSource);
        builder.append("\n");
        builder.append("UPDATE IF EXISTS IN TARGET CONDITION: ");
        if (this.updateIfExistsInTargetCondition != null) {
            builder.append(this.updateIfExistsInTargetCondition.getPhrase());
        }
        return builder.toString();
    }

    @Override
    public Expression getJoinExpression() {
        return this.joinExpression;
    }

    @Override
    public CopyTable2ProcessParameters setJoinExpression(Expression join) {
        this.joinExpression = join;
        return this;
    }

    @Override
    public boolean isMustUpdateWhenSourceAndTargetAreNotEquals() {
        return this.mustUpdateWhenSourceAndTargetAreNotEquals;
    }

    @Override
    public CopyTable2ProcessParameters setMustUpdateIfSourceAndTargetAreNotEquals(boolean update) {
        this.mustUpdateWhenSourceAndTargetAreNotEquals = update;
        return this;
    }

    public static class ProcessFieldParametersImpl
    implements CopyTable2ProcessParameters.ProcessFieldParameters {
        private String name;
        private boolean copyThisField;
        private Expression expression;

        public ProcessFieldParametersImpl() {
        }

        public ProcessFieldParametersImpl(String name, boolean update, Expression expression) {
            this.name = name;
            this.copyThisField = update;
            this.expression = expression;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isCopyThisFieldActive() {
            return this.copyThisField;
        }

        @Override
        public Expression getExpression() {
            return this.expression;
        }

        public static void selfRegister() {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            DynStruct definition = manager.addDefinition(ProcessFieldParametersImpl.class, "ProcessFieldParameters", "ProcessFieldParameters Persistence definition", null, null);
            definition.addDynFieldString("name").setMandatory(true);
            definition.addDynFieldBoolean("copyThisField").setMandatory(true);
            definition.addDynFieldObject("expression").setClassOfValue(Expression.class).setMandatory(false);
        }

        public void loadFromState(PersistentState state) throws PersistenceException {
            this.name = state.getString("name");
            this.copyThisField = state.getBoolean("copyThisField");
            this.expression = (Expression)state.get("expression");
        }

        public void saveToState(PersistentState state) throws PersistenceException {
            state.set("name", this.name);
            state.set("copyThisField", this.copyThisField);
            state.set("expression", (Persistent)this.expression);
        }
    }
}

