/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.develtools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.ImageIcon;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.app.extension.develtools.InfoPanel;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconThemeDevelTool {
    public static final Logger LOGGER = LoggerFactory.getLogger(IconThemeDevelTool.class);

    public void showDefaultIconTheme() {
        IconThemeManager manager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = manager.getDefault();
        String html = "<html><style type=\"text/css\" media=\"print\">@page {\n  size: A4 portrait;\n}</style>\n<body>\n" + this.getIconThemeInformationByGroup(theme) + "</body>\n</html>\n";
        InfoPanel.showInBrowser("default-icontheme-report", "Icon theme " + theme.getName(), html);
    }

    public void showCurrentIconTheme() {
        IconThemeManager manager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = manager.getCurrent();
        String html = "<html><style type=\"text/css\" media=\"print\">@page {\n  size: A4 portrait;\n}</style>\n<body>\n" + this.getIconThemeInformationByGroup(theme) + "</body>\n</html>\n";
        InfoPanel.showInBrowser("current-icontheme-report", "Icon theme " + theme.getName(), html);
    }

    public void showDefaultIconThemeByPlugin() {
        IconThemeManager manager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = manager.getDefault();
        String html = "<html><style type=\"text/css\" media=\"print\">@page {\n  size: A4 portrait;\n}</style>\n<body>\n" + this.getIconThemeInformationByPlugin(theme) + "</body>\n</html>\n";
        InfoPanel.showInBrowser("default-icontheme-report-byplugin", "Icon theme " + theme.getName(), html);
    }

    private List<IconTheme.Icon> getIconsFromDefaultTheme(Predicate<IconTheme.Icon> filter) {
        IconThemeManager manager = ToolsSwingLocator.getIconThemeManager();
        IconTheme defaultTheme = manager.getDefault();
        ArrayList<IconTheme.Icon> defaultThemeIcons = new ArrayList<IconTheme.Icon>();
        Iterator defaultThemeIconsIt = defaultTheme.getThemeIcons();
        while (defaultThemeIconsIt.hasNext()) {
            IconTheme.Icon defaultTheIcon = (IconTheme.Icon)defaultThemeIconsIt.next();
            if (filter != null && !filter.test(defaultTheIcon)) continue;
            defaultThemeIcons.add(defaultTheIcon);
        }
        return defaultThemeIcons;
    }

    private String getIconThemeInformationByPlugin(IconTheme theme) {
        List<IconTheme.Icon> defaultThemeIcons = this.getIconsFromDefaultTheme(null);
        Collections.sort(defaultThemeIcons, (o1, o2) -> {
            String s1 = String.format("%s:%s:%s:%s", o1.getProviderName(), o1.getGroup(), StringUtils.defaultIfEmpty((CharSequence)o1.getSubgroup(), (CharSequence)""), o1.getName());
            String s2 = String.format("%s:%s:%s:%s", o2.getProviderName(), o2.getGroup(), StringUtils.defaultIfEmpty((CharSequence)o2.getSubgroup(), (CharSequence)""), o2.getName());
            return s1.compareTo(s2);
        });
        return this.getIconThemeInformation(theme, defaultThemeIcons);
    }

    public String getIconThemeInformationOfPlugin(String pluginName) {
        IconThemeManager manager = ToolsSwingLocator.getIconThemeManager();
        IconTheme defaultTheme = manager.getDefault();
        return this.getIconThemeInformationOfPlugin(defaultTheme, pluginName);
    }

    public String getIconThemeInformationOfPlugin(IconTheme theme, String pluginName) {
        if (pluginName == null) {
            return "";
        }
        List<IconTheme.Icon> defaultThemeIcons = this.getIconsFromDefaultTheme(t -> StringUtils.equalsIgnoreCase((CharSequence)pluginName, (CharSequence)t.getProviderName()));
        Collections.sort(defaultThemeIcons, (o1, o2) -> {
            String s1 = String.format("%s:%s:%s:%s", o1.getProviderName(), o1.getGroup(), StringUtils.defaultIfEmpty((CharSequence)o1.getSubgroup(), (CharSequence)""), o1.getName());
            String s2 = String.format("%s:%s:%s:%s", o2.getProviderName(), o2.getGroup(), StringUtils.defaultIfEmpty((CharSequence)o2.getSubgroup(), (CharSequence)""), o2.getName());
            return s1.compareTo(s2);
        });
        return this.getIconThemeInformation(theme, defaultThemeIcons);
    }

    private String getIconThemeInformationByGroup(IconTheme theme) {
        List<IconTheme.Icon> defaultThemeIcons = this.getIconsFromDefaultTheme(null);
        Collections.sort(defaultThemeIcons, (o1, o2) -> {
            String s1 = String.format("%s:%s:%s:%s", o1.getGroup(), StringUtils.defaultIfEmpty((CharSequence)o1.getSubgroup(), (CharSequence)""), o1.getName(), o1.getProviderName());
            String s2 = String.format("%s:%s:%s:%s", o2.getGroup(), StringUtils.defaultIfEmpty((CharSequence)o2.getSubgroup(), (CharSequence)""), o2.getName(), o2.getProviderName());
            return s1.compareTo(s2);
        });
        return this.getIconThemeInformation(theme, defaultThemeIcons);
    }

    private String getIconThemeInformation(IconTheme theme, Iterable<IconTheme.Icon> defaultThemeIcons) {
        IconTheme.Icon themeIcon;
        IconThemeManager manager = ToolsSwingLocator.getIconThemeManager();
        IconTheme defaultTheme = manager.getDefault();
        HashSet<String> actionIcons = new HashSet<String>();
        Iterator actions = PluginsLocator.getActionInfoManager().getActions();
        while (actions.hasNext()) {
            ActionInfo action = (ActionInfo)actions.next();
            if (action.getIconName() == null) continue;
            actionIcons.add(action.getIconName());
        }
        Set<String> tangoIconNames = this.getTangoIconNames();
        String previousGroup = "----- none -----";
        String previousSubgroup = "----- none -----";
        StringBuilder buffer = new StringBuilder();
        buffer.append("<div>\n");
        buffer.append("<style>\n");
        buffer.append(".fullscreen-image { position: fixed; top: 0; left: 0; width: 100vw; height: 100vh; background-color: rgba(0, 0, 0, 0.5); display: flex; justify-content: center; align-items: center; z-index: 999; }");
        buffer.append("</style>\n");
        buffer.append("<script>\n");
        buffer.append("function showFullscreen(image) {\n");
        buffer.append("    const fullscreen = document.createElement('div');\n");
        buffer.append("    fullscreen.classList.add('fullscreen-image');\n");
        buffer.append("    fullscreen.innerHTML = '<img src=\"'+image.src+'\">';\n");
        buffer.append("    fullscreen.addEventListener('click', (event) => {\n");
        buffer.append("        if (event.target === fullscreen) {\n");
        buffer.append("            fullscreen.remove();\n");
        buffer.append("        }\n");
        buffer.append("    });\n");
        buffer.append("    document.body.appendChild(fullscreen);\n");
        buffer.append("}\n");
        buffer.append("</script>\n");
        buffer.append("<h2>Icon theme information</h2>\n");
        buffer.append("<br>\n");
        buffer.append("Theme: ");
        buffer.append(theme.getName());
        buffer.append("<br>\n");
        buffer.append("Description: ");
        buffer.append(theme.getDescription());
        buffer.append("<br>\n");
        buffer.append("<table border=\"0\">\n");
        for (IconTheme.Icon defaultThemeIcon : defaultThemeIcons) {
            List images;
            ImageIcon img;
            if (defaultThemeIcon == null) continue;
            themeIcon = theme.getThemeIcon(defaultThemeIcon.getName());
            if (themeIcon == null) {
                themeIcon = defaultThemeIcon;
            }
            String nameTag = "";
            String imageTag = "";
            String note1Tag = "";
            String note2Tag = "";
            String note3Tag = "";
            nameTag = StringUtils.equalsIgnoreCase((CharSequence)"action", (CharSequence)defaultThemeIcon.getGroup()) && !actionIcons.contains(defaultThemeIcon.getName()) ? String.format("<span title=\"Don't exists an action associated to this icon\"><b><font color=\"red\">%s</font></b></span>", defaultThemeIcon.getName()) : (!defaultThemeIcon.getName().contains("-") ? String.format("<span title=\"Name don't have recomended format\"><b>%s</b></span>", defaultThemeIcon.getName()) : (tangoIconNames.contains(defaultThemeIcon.getName()) ? String.format("<span title=\"The name conforms to the Tango directives\"><b><font color=\"green\">%s</font></b></span>", defaultThemeIcon.getName()) : String.format("<span>%s</span>", defaultThemeIcon.getName())));
            if (!theme.isMyIcon(themeIcon.getName())) {
                note2Tag = "<span title=\"The image not found in this theme, get from default theme.\"><small><sup>(2)</sup></small></span>";
            }
            if ((img = themeIcon.getImageIcon()) != null) {
                try {
                    SimpleImage simpleImg = ToolsSwingLocator.getToolsSwingManager().createSimpleImage((Object)img);
                    if (img.getIconHeight() > 48 || img.getIconWidth() > 48) {
                        imageTag = String.format("<img onclick=\"showFullscreen(this)\" width=\"48\" height=\"48\" src=\"data:image/%s;base64,%s\" title=\"%s\">", simpleImg.getFormatName(), simpleImg.toStringBase64(), Objects.toString(themeIcon.getURL()));
                        note1Tag = "<span title=\"The image is big, resized to 48x48.\"><small><sup>(1)</sup></small></span>";
                    } else {
                        imageTag = String.format("<img src=\"data:image/%s;base64,%s\" title=\"%s\">", simpleImg.getFormatName(), simpleImg.toStringBase64(), Objects.toString(themeIcon.getURL()));
                        note1Tag = "";
                    }
                }
                catch (Exception ex) {
                    imageTag = String.format("<img src=\"%s\">", themeIcon.getLabel());
                    note3Tag = String.format("<span title=\"Problems loading image. %s\"><small><sup>(3)</sup></small></span>", ex.getMessage());
                }
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)previousGroup, (CharSequence)defaultThemeIcon.getGroup())) {
                previousGroup = defaultThemeIcon.getGroup();
                previousSubgroup = "----- none -----";
                buffer.append("  <tr valign=\"top\">\n");
                buffer.append("    <td colspan=\"2\">");
                buffer.append("    <hr><b>Group ");
                buffer.append(defaultThemeIcon.getGroup());
                buffer.append("    </b>");
                if (StringUtils.isNotEmpty((CharSequence)defaultThemeIcon.getGroupDescription())) {
                    buffer.append("<br>");
                    buffer.append(ToolsSwingUtils.toHTML((String)defaultThemeIcon.getGroupDescription()));
                }
                images = defaultTheme.getGroupImages(defaultThemeIcon.getGroup());
                buffer.append(this.createImagesTag(images));
                buffer.append("    </td>");
                buffer.append("  </tr>\n");
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)previousSubgroup, (CharSequence)defaultThemeIcon.getSubgroup())) {
                previousSubgroup = defaultThemeIcon.getSubgroup();
                if (StringUtils.isNotEmpty((CharSequence)defaultThemeIcon.getSubgroup())) {
                    buffer.append("  <tr valign=\"top\">\n");
                    buffer.append("    <td colspan=\"2\">");
                    buffer.append("    <b>Subgroup ");
                    buffer.append(defaultThemeIcon.getSubgroup());
                    buffer.append("    </b>");
                    if (StringUtils.isNotEmpty((CharSequence)defaultThemeIcon.getSubgroupDescription())) {
                        buffer.append("<br>");
                        buffer.append(ToolsSwingUtils.toHTML((String)defaultThemeIcon.getSubgroupDescription()));
                    }
                    images = defaultTheme.getSubgroupImages(defaultThemeIcon.getGroup(), defaultThemeIcon.getSubgroup());
                    buffer.append(this.createImagesTag(images));
                    buffer.append("    </td>");
                    buffer.append("  </tr>\n");
                }
            }
            buffer.append("  <tr valign=\"top\">\n");
            buffer.append("    <td>\n");
            buffer.append(imageTag);
            buffer.append(note1Tag);
            buffer.append(note2Tag);
            buffer.append(note3Tag);
            buffer.append("    </td>\n");
            buffer.append("    <td>\n");
            buffer.append(nameTag);
            if (StringUtils.isNotEmpty((CharSequence)defaultThemeIcon.getProviderName())) {
                buffer.append(" (");
                buffer.append(defaultThemeIcon.getProviderName());
                buffer.append(")");
            }
            buffer.append("    </td>\n");
            buffer.append("  </tr>\n");
            String s = defaultThemeIcon.getDescription();
            if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
            buffer.append("  <tr valign=\"top\">\n<td></td>");
            buffer.append("    <td>");
            buffer.append(ToolsSwingUtils.toHTML((String)s));
            buffer.append("\n");
            buffer.append("    </td>\n");
            buffer.append("  </tr>\n");
        }
        buffer.append("</table>\n");
        boolean first = true;
        Iterator it = theme.getThemeIcons();
        while (it.hasNext()) {
            ImageIcon img;
            themeIcon = (IconTheme.Icon)it.next();
            if (themeIcon == null) continue;
            String imageTag = "";
            String note3Tag = "";
            IconTheme.Icon defaultThemeIcon = defaultTheme.getThemeIcon(themeIcon.getName());
            if (defaultThemeIcon != null) continue;
            if (first) {
                first = false;
                buffer.append("<hr>\n");
                buffer.append("<p>Imagenes que no estan en el tema por defecto.</p>\n");
                buffer.append("<table border=\"0\">\n");
                buffer.append("  <tr valign=\"top\">\n");
                buffer.append("    <td>Image</td>\n");
                buffer.append("    <td>Group</td>\n");
                buffer.append("    <td>Name</td>\n");
                buffer.append("  </tr>\n");
            }
            if ((img = themeIcon.getImageIcon()) != null) {
                try {
                    SimpleImage simpleImg = ToolsSwingLocator.getToolsSwingManager().createSimpleImage((Object)img);
                    imageTag = img.getIconHeight() > 48 || img.getIconWidth() > 48 ? String.format("<img onclick=\"showFullscreen(this)\" width=\"48\" height=\"48\" src=\"data:image/%s;base64,%s\" title=\"%s\">", simpleImg.getFormatName(), simpleImg.toStringBase64(), Objects.toString(themeIcon.getURL())) : String.format("<img src=\"data:image/%s;base64,%s\" title=\"%s\">", simpleImg.getFormatName(), simpleImg.toStringBase64(), Objects.toString(themeIcon.getURL()));
                }
                catch (Exception ex) {
                    imageTag = String.format("<img src=\"%s\">", themeIcon.getLabel());
                    note3Tag = String.format("<span title=\"Problems loading image. %s\"><small><sup>(3)</sup></small></span>", ex.getMessage());
                }
            }
            buffer.append("  <tr valign=\"top\">\n");
            buffer.append("    <td>");
            buffer.append(imageTag);
            buffer.append(note3Tag);
            buffer.append("</td>\n");
            buffer.append("    <td>");
            buffer.append(themeIcon.getGroup());
            buffer.append("</td>\n");
            buffer.append("    <td>");
            buffer.append(themeIcon.getName());
            buffer.append("</td>\n");
            buffer.append("  </tr>\n");
        }
        if (!first) {
            buffer.append("</table>\n");
        }
        buffer.append("<p>");
        buffer.append("<sup>(1)</sup> Resized Icon<br>");
        buffer.append("<sup>(2)</sup> Image not found in this theme, get from default theme<br>");
        buffer.append("<sup>(3)</sup> Problems loading the image<br>");
        buffer.append("</p>");
        buffer.append("</div>\n");
        return buffer.toString();
    }

    private Set<String> getTangoIconNames() {
        String[] iconNames = new String[]{"address-book-new", "application-exit", "appointment-new", "call-start", "call-stop", "contact-new", "document-new", "document-open", "document-open-recent", "document-page-setup", "document-print", "document-print-preview", "document-properties", "document-revert", "document-save", "document-save-as", "document-send", "edit-clear", "edit-copy", "edit-cut", "edit-delete", "edit-find", "edit-find-replace", "edit-paste", "edit-redo", "edit-select-all", "edit-undo", "folder-new", "format-indent-less", "format-indent-more", "format-justify-center", "format-justify-fill", "format-justify-left", "format-justify-right", "format-text-direction-ltr", "format-text-direction-rtl", "format-text-bold", "format-text-italic", "format-text-underline", "format-text-strikethrough", "go-bottom", "go-down", "go-first", "go-home", "go-jump", "go-last", "go-next", "go-previous", "go-top", "go-up", "help-about", "help-contents", "help-faq", "insert-image", "insert-link", "insert-object", "insert-text", "list-add", "list-remove", "mail-forward", "mail-mark-important", "mail-mark-junk", "mail-mark-notjunk", "mail-mark-read", "mail-mark-unread", "mail-message-new", "mail-reply-all", "mail-reply-sender", "mail-send", "mail-send-receive", "media-eject", "media-playback-pause", "media-playback-start", "media-playback-stop", "media-record", "media-seek-backward", "media-seek-forward", "media-skip-backward", "media-skip-forward", "object-flip-horizontal", "object-flip-vertical", "object-rotate-left", "object-rotate-right", "process-stop", "system-lock-screen", "system-log-out", "system-run", "system-search", "system-reboot", "system-shutdown", "tools-check-spelling", "view-fullscreen", "view-refresh", "view-restore", "view-sort-ascending", "view-sort-descending", "window-close", "window-new", "zoom-fit-best", "zoom-in", "zoom-original", "zoom-out", "process-working", "accessories-calculator", "accessories-character-map", "accessories-dictionary", "accessories-text-editor", "help-browser", "multimedia-volume-control", "preferences-desktop-accessibility", "preferences-desktop-font", "preferences-desktop-keyboard", "preferences-desktop-locale", "preferences-desktop-multimedia", "preferences-desktop-screensaver", "preferences-desktop-theme", "preferences-desktop-wallpaper", "system-file-manager", "system-software-install", "system-software-update", "utilities-system-monitor", "utilities-terminal", "applications-accessories", "applications-development", "applications-engineering", "applications-games", "applications-graphics", "applications-internet", "applications-multimedia", "applications-office", "applications-other", "applications-science", "applications-system", "applications-utilities", "preferences-desktop", "preferences-desktop-peripherals", "preferences-desktop-personal", "preferences-other", "preferences-system", "preferences-system-network", "system-help", "audio-card", "audio-input-microphone", "battery", "camera-photo", "camera-video", "camera-web", "computer", "drive-harddisk", "drive-optical", "drive-removable-media", "input-gaming", "input-keyboard", "input-mouse", "input-tablet", "media-flash", "media-floppy", "media-optical", "media-tape", "modem", "multimedia-player", "network-wired", "network-wireless", "pda", "phone", "printer", "scanner", "video-display", "emblem-default", "emblem-documents", "emblem-downloads", "emblem-favorite", "emblem-important", "emblem-mail", "emblem-photos", "emblem-readonly", "emblem-shared", "emblem-symbolic-link", "emblem-synchronized", "emblem-system", "emblem-unreadable", "face-angel", "face-angry", "face-cool", "face-crying", "face-devilish", "face-embarrassed", "face-kiss", "face-laugh", "face-monkey", "face-plain", "face-raspberry", "face-sad", "face-sick", "face-smile", "face-smile-big", "face-smirk", "face-surprise", "face-tired", "face-uncertain", "face-wink", "face-worried", "flag-aa", "application-x-executable", "audio-x-generic", "font-x-generic", "image-x-generic", "package-x-generic", "text-html", "text-x-generic", "text-x-generic-template", "text-x-script", "video-x-generic", "x-office-address-book", "x-office-calendar", "x-office-document", "x-office-presentation", "x-office-spreadsheet", "folder", "folder-remote", "network-server", "network-workgroup", "start-here", "user-bookmarks", "user-desktop", "user-home", "user-trash", "appointment-missed", "appointment-soon", "audio-volume-high", "audio-volume-low", "audio-volume-medium", "audio-volume-muted", "battery-caution", "battery-low", "dialog-error", "dialog-information", "dialog-password", "dialog-question", "dialog-warning", "folder-drag-accept", "folder-open", "folder-visiting", "image-loading", "image-missing", "mail-attachment", "mail-unread", "mail-read", "mail-replied", "mail-signed", "mail-signed-verified", "media-playlist-repeat", "media-playlist-shuffle", "network-error", "network-idle", "network-offline", "network-receive", "network-transmit", "network-transmit-receive", "printer-error", "printer-printing", "security-high", "security-medium", "security-low", "software-update-available", "software-update-urgent", "sync-error", "sync-synchronizing", "task-due", "task-past-due", "user-available", "user-away", "user-idle", "user-offline", "user-trash-full", "weather-clear", "weather-clear-night", "weather-few-clouds", "weather-few-clouds-night", "weather-fog", "weather-overcast", "weather-severe-alert", "weather-showers", "weather-showers-scattered", "weather-snow", "weather-storm"};
        HashSet<String> icons = new HashSet<String>();
        icons.addAll(Arrays.asList(iconNames));
        return icons;
    }

    private String createImagesTag(List<SimpleImage> images) {
        if (CollectionUtils.isEmpty(images)) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<br>");
        buffer.append("<span>\n");
        for (SimpleImage image : images) {
            String imageTag = String.format("<img onclick=\"showFullscreen(this)\" width=\"48\" height=\"48\" src=\"data:image/%s;base64,%s\">", image.getFormatName(), image.toStringBase64());
            buffer.append(imageTag);
            buffer.append(" ");
        }
        buffer.append("<span>\n");
        return buffer.toString();
    }
}

