/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.editedfeatures;

import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.gvsig.app.extension.editedfeatures.EditedFeaturesPanelView;
import org.gvsig.featureform.swing.CreateJFeatureFormException;
import org.gvsig.featureform.swing.JFeatureReferencesForm;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dynform.AbortActionException;
import org.gvsig.tools.dynform.JDynFormSet;
import org.gvsig.tools.dynform.JDynFormSetAdapter;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.TableColumnAdjuster;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditedFeaturesPanel
extends EditedFeaturesPanelView
implements Component {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditedFeaturesPanel.class);
    private TableColumnAdjuster columnAdjuster;
    private final FeatureStore store;
    private final Coercion toString;
    private final FeatureType featureType;
    private List<FeatureReference> references;
    private JFeatureReferencesForm form;
    private Color backgroundColorWarning;
    private DefaultTableColumnModel columnModel;
    private Observer storeObserver;

    public EditedFeaturesPanel(FeatureStore store) {
        this.store = store;
        this.featureType = this.store.getDefaultFeatureTypeQuietly();
        this.toString = ToolsLocator.getDataTypesManager().get(8).getCoercion();
        this.initComponents();
    }

    private void executeQuietly(Runnable r) {
        try {
            r.run();
        }
        catch (Exception ex) {
            LOGGER.debug("Can't execute", (Throwable)ex);
        }
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.backgroundColorWarning = toolsSwingManager.getWarningBackgroundColor();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (EditedFeaturesPanel.this.form != null && EditedFeaturesPanel.this.form.asJComponent().isVisible()) {
                    EditedFeaturesPanel.this.form.asJComponent().setVisible(false);
                }
            }
        });
        this.storeObserver = (observable, notification) -> {
            if (notification instanceof FeatureStoreNotification && (((FeatureStoreNotification)notification).getType().equals("after_FinishEditing_DataStore") || ((FeatureStoreNotification)notification).getType().equals("after_CancelEditing_DataStore"))) {
                this.executeQuietly(() -> this.store.deleteObserver(this.storeObserver));
                this.executeQuietly(() -> this.form.asJComponent().setVisible(false));
                this.executeQuietly(() -> this.setVisible(false));
            }
        };
        this.store.addObserver(this.storeObserver);
        toolsSwingManager.translate((AbstractButton)this.chkOnlyNotValidatedFeatures);
        this.chkOnlyNotValidatedFeatures.addActionListener(e -> this.doOnlyNotValidatedFeaturesChange());
        this.btnShowForm.addActionListener(e -> this.doShowForm());
        this.tblFeatures.setAutoCreateColumnsFromModel(false);
        this.tblFeatures.setSelectionMode(0);
        this.tblFeatures.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int x = EditedFeaturesPanel.this.tblFeatures.rowAtPoint(e.getPoint());
                    EditedFeaturesPanel.this.tblFeatures.getSelectionModel().setSelectionInterval(x, x);
                    EditedFeaturesPanel.this.doShowForm();
                }
            }
        });
        this.tblFeatures.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.doSelectCurrentFeature();
        });
        this.columnModel = new DefaultTableColumnModel();
        FeatureType ftype = this.store.getDefaultFeatureTypeQuietly();
        int modelIndex = 0;
        for (FeatureAttributeDescriptor attr : ftype) {
            TableColumn column = new TableColumn();
            column.setHeaderValue(attr.getLabel());
            column.setCellRenderer(new FeatureAttributeCellRenderer(attr));
            column.setResizable(true);
            column.setModelIndex(modelIndex++);
            this.columnModel.addColumn(column);
        }
        this.references = this.store.getEditedFeatures();
        this.doOnlyNotValidatedFeaturesChange();
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)15, (int)90, (int)30, (int)100);
    }

    private void doSelectCurrentFeature() {
        int row = this.tblFeatures.getSelectedRow();
        if (row >= 0) {
            try {
                FeatureSelection selection = this.store.getFeatureSelection();
                selection.deselectAll();
                selection.select(this.references.get(row));
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }
    }

    private void doOnlyNotValidatedFeaturesChange() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.references = this.chkOnlyNotValidatedFeatures.isSelected() ? this.store.getEditedFeaturesNotValidated() : this.store.getEditedFeatures();
        this.tblFeatures.setModel(new MyTableModel());
        this.tblFeatures.setColumnModel(this.columnModel);
        if (this.columnAdjuster == null) {
            this.columnAdjuster = toolsSwingManager.createTableColumnAdjuster(this.tblFeatures);
        } else {
            this.columnAdjuster.restoreColumns();
        }
        if (this.form != null) {
            if (this.form.getFormset().getForm().isModified()) {
                this.form.getFormset().fireEvent("save", null);
            }
            this.form.setFeatures(this.references);
            this.form.getFormset().addListener((JDynFormSet.JDynFormSetListener)new JDynFormSetAdapter(){

                public void formMovedTo(int currentPosition) throws AbortActionException {
                    EditedFeaturesPanel.this.tblFeatures.getSelectionModel().setSelectionInterval(currentPosition, currentPosition);
                }
            });
        }
    }

    private void doShowForm() {
        JDynFormSet formset;
        if (this.references.isEmpty()) {
            return;
        }
        int index = this.tblFeatures.getSelectedRow();
        if (index < 0) {
            index = 0;
        }
        if (this.form == null) {
            try {
                WindowManager winmgr = ToolsSwingLocator.getWindowManager();
                DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
                I18nManager i18n = ToolsLocator.getI18nManager();
                this.form = dataSwingManager.createJFeatureReferencesForm(this.store, this.references);
                this.form.getFormset().setAutosave(false);
                this.form.asJComponent().addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        EditedFeaturesPanel.this.form = null;
                    }
                });
                this.form.getFormset().addListener((JDynFormSet.JDynFormSetListener)new JDynFormSetAdapter(){

                    public void formMovedTo(int currentPosition) throws AbortActionException {
                        EditedFeaturesPanel.this.tblFeatures.getSelectionModel().setSelectionInterval(currentPosition, currentPosition);
                    }
                });
                String title = ToolsSwingUtils.makeTitle((String)"_Edited_features", (String)this.store.getName(), null);
                winmgr.showWindow(this.form.asJComponent(), title, WindowManager.MODE.WINDOW);
            }
            catch (CreateJFeatureFormException winmgr) {
                // empty catch block
            }
        }
        if ((formset = this.form.getFormset()).getCurrentIndex() != index) {
            if (formset.getForm().isModified()) {
                formset.fireEvent("save", null);
            }
            formset.setCurrentIndex(index);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        return ToolsSwingUtils.loadImage((Object)this, (String)imageName);
    }

    private class MyTableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            try {
                if (EditedFeaturesPanel.this.references == null) {
                    return 0;
                }
                return EditedFeaturesPanel.this.references.size();
            }
            catch (Exception ex) {
                return 0;
            }
        }

        @Override
        public int getColumnCount() {
            try {
                if (EditedFeaturesPanel.this.featureType == null) {
                    return 0;
                }
                return EditedFeaturesPanel.this.featureType.size();
            }
            catch (Exception ex) {
                return 0;
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                if (EditedFeaturesPanel.this.references == null) {
                    return "";
                }
                Feature feature = ((FeatureReference)EditedFeaturesPanel.this.references.get(rowIndex)).getFeature();
                return feature.get(columnIndex);
            }
            catch (Exception ex) {
                return "";
            }
        }
    }

    private class FeatureAttributeCellRenderer
    extends DefaultTableCellRenderer {
        private final FeatureAttributeDescriptor descriptor;

        public FeatureAttributeCellRenderer(FeatureAttributeDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public java.awt.Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                this.setText("");
            } else {
                try {
                    value = EditedFeaturesPanel.this.toString.coerce(value);
                }
                catch (CoercionException ex) {
                    LOGGER.debug("Can't coerce value to string.", (Throwable)ex);
                }
                this.setText((String)value);
            }
            if (!isSelected) {
                this.setBackground(table.getBackground());
                try {
                    Feature feature = ((FeatureReference)EditedFeaturesPanel.this.references.get(row)).getFeature();
                    feature.validate(14);
                }
                catch (Exception ex) {
                    this.setBackground(EditedFeaturesPanel.this.backgroundColorWarning);
                }
            }
            return this;
        }
    }
}

