/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.UnknownHostException;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagePanel
extends JPanel {
    private static Logger logger = LoggerFactory.getLogger(MessagePanel.class);
    private static final long serialVersionUID = 2579894035021915221L;
    private JButton accept = null;
    private JTextPane text = null;

    public static void showMessage(String title, String header, String html) {
        MessagePanel panel = new MessagePanel(header, html, null);
        WindowManager wm = ToolsSwingLocator.getWindowManager();
        wm.showWindow((JComponent)panel, title, WindowManager.MODE.DIALOG);
    }

    public static void showMessage(String title, String header, Exception ex) {
        MessagePanel.showMessage(title, header, MessagePanel.getMessageAsHTML(ex));
    }

    private static String getMessageAsHTML(Exception ex) {
        ExceptionIterator exceptions = new ExceptionIterator(ex);
        StringBuilder html = new StringBuilder();
        html.append("<ul>\n");
        while (exceptions.hasNext()) {
            Throwable ex1 = (Throwable)exceptions.next();
            String message = null;
            message = ex1 instanceof UnknownHostException ? "Unknown Host " + ex1.getMessage() : ex1.getMessage();
            if (message == null || message.startsWith("Exception ") || message.startsWith("Error ")) continue;
            html.append("<li>");
            if (message.toLowerCase().contains(" create ")) {
                message = message.replaceFirst(" create ", "<br>\nCREATE ");
                message = message.replaceAll(",", ",<br>\n");
            } else if (message.toLowerCase().contains(" insert ")) {
                message = message.replaceFirst(" insert ", "<br>\nINSERT ");
                message = message.replaceAll(",", ",<br>\n");
            }
            html.append(message);
            html.append("</li>\n");
        }
        html.append("</ul>\n");
        return html.toString();
    }

    public MessagePanel(String header, String html, Feature feature) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 300));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JLabel headerlabel = new JLabel();
        headerlabel.setText(header);
        JTabbedPane tabs = new JTabbedPane();
        this.text = new JTextPane();
        this.text.setContentType("text/html");
        this.text.setEditable(false);
        this.text.setText(html);
        this.text.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(this.text);
        scrollPane.setPreferredSize(new Dimension(500, 220));
        tabs.addTab(i18nManager.getTranslation("_Problem"), scrollPane);
        if (feature != null) {
            DynObject data = feature.getAsDynObject();
            JDynForm form = DynFormLocator.getDynFormManager().createJDynForm(data);
            form.setLayoutMode(1);
            tabs.addTab(i18nManager.getTranslation("_Row_values"), form.asJComponent());
        }
        this.accept = new JButton(i18nManager.getTranslation("_Accept"));
        this.accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MessagePanel.this.setVisible(false);
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 2));
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.accept);
        this.add((Component)headerlabel, "North");
        this.add((Component)tabs, "Center");
        this.add((Component)buttonsPanel, "South");
        this.setVisible(true);
    }

    private static class ExceptionIterator
    implements Iterator {
        Throwable exception;

        ExceptionIterator(Throwable exception) {
            this.exception = exception;
        }

        @Override
        public boolean hasNext() {
            return this.exception != null;
        }

        public Object next() {
            Throwable exception = this.exception;
            this.exception = exception.getCause();
            return exception;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

