/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.preferencespage;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.app.extension.AddLayer;
import org.gvsig.app.gui.preferencespage.ViewPage;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.order.LayerOrderManager;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.dynobject.DynObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerOrderPage
extends AbstractPreferencePage
implements ActionListener {
    private static Logger logger = LoggerFactory.getLogger(LayerOrderPage.class);
    public static String PREFERENCES_ID = "current_layer_order_manager";
    private ImageIcon icon;
    private JComboBox orderCombo = null;
    private JTextArea descArea = null;

    public LayerOrderPage() {
        this.setParentID(ViewPage.id);
        this.initUI();
    }

    private void initUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 8, 5, 8);
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel(Messages.getText((String)"_Order")), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.getOrderCombo(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)new JLabel(Messages.getText((String)"_Description")), gbc);
        gbc.gridx = 1;
        panel.add((Component)this.getDescArea(this.getOrderCombo().getFont(), panel.getBackground()), gbc);
        this.addComponent(panel);
    }

    private JTextArea getDescArea(Font fnt, Color bg) {
        if (this.descArea == null) {
            this.descArea = new JTextArea();
            this.descArea.setWrapStyleWord(true);
            this.descArea.setLineWrap(true);
            this.descArea.setPreferredSize(new Dimension(250, 80));
            if (fnt != null) {
                this.descArea.setFont(fnt);
            }
            if (bg != null) {
                this.descArea.setBackground(bg);
            }
        }
        return this.descArea;
    }

    private JComboBox getOrderCombo() {
        if (this.orderCombo == null) {
            this.orderCombo = new JComboBox();
            this.orderCombo.addActionListener(this);
        }
        return this.orderCombo;
    }

    public String getID() {
        return this.getClass().getName();
    }

    public String getTitle() {
        return Messages.getText((String)"_Layer_order_in_TOC");
    }

    public JPanel getPanel() {
        return this;
    }

    public void initializeValues() {
        this.getOrderCombo().removeAllItems();
        this.loadAvailables();
        DynObject props = this.getPluginProperties();
        Object val_obj = null;
        if (props.hasDynValue(PREFERENCES_ID)) {
            val_obj = props.getDynValue(PREFERENCES_ID);
        }
        if (val_obj != null && val_obj instanceof LayerOrderManager) {
            LayerOrderManager lom = (LayerOrderManager)val_obj;
            String code = lom.getCode();
            this.setSelected(code);
            return;
        }
        LayerOrderManager lom = MapContextLocator.getDefaultOrderManager();
        if (lom != null) {
            this.setSelected(lom.getCode());
        } else {
            logger.warn("No default order manager set!");
        }
    }

    private void setSelected(String code) {
        int n = this.getOrderCombo().getItemCount();
        LayerOrderManager lom = null;
        for (int i = 0; i < n; ++i) {
            lom = ((LayerOrderComboItem)this.getOrderCombo().getItemAt(i)).getManager();
            if (lom.getCode().compareTo(code) != 0) continue;
            this.getOrderCombo().setSelectedIndex(i);
            return;
        }
        logger.warn("Did not find code in list of order managers: " + code);
        this.getOrderCombo().setSelectedIndex(0);
    }

    private void loadAvailables() {
        List avs = MapContextLocator.getOrderManagers();
        LayerOrderManager lom2 = null;
        for (LayerOrderManager lom2 : avs) {
            this.getOrderCombo().addItem(new LayerOrderComboItem(lom2));
        }
    }

    public void initializeDefaults() {
        this.getOrderCombo().removeAllItems();
        this.loadAvailables();
        LayerOrderManager lom = MapContextLocator.getDefaultOrderManager();
        if (lom != null) {
            this.setSelected(lom.getCode());
        } else {
            logger.warn("No default order manager set!");
        }
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = IconThemeHelper.getImageIcon((String)"layer-order-preferences");
        }
        return this.icon;
    }

    public boolean isValueChanged() {
        return true;
    }

    public void storeValues() throws StoreException {
        LayerOrderComboItem loci = (LayerOrderComboItem)this.getOrderCombo().getSelectedItem();
        DynObject props = this.getPluginProperties();
        props.setDynValue(PREFERENCES_ID, (Object)loci.getManager());
    }

    public void setChangesApplied() {
    }

    private DynObject getPluginProperties() {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        return pluginsManager.getPlugin(AddLayer.class).getPluginProperties();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.getOrderCombo()) {
            LayerOrderComboItem item = null;
            item = (LayerOrderComboItem)this.getOrderCombo().getSelectedItem();
            if (item == null) {
                return;
            }
            String desc = item.getManager().getDescription();
            this.getDescArea(null, null).setText(desc);
        }
    }

    public class LayerOrderComboItem {
        private LayerOrderManager lom = null;

        public LayerOrderComboItem(LayerOrderManager _lom) {
            this.lom = _lom;
        }

        public String toString() {
            return this.lom.getName();
        }

        public LayerOrderManager getManager() {
            return this.lom;
        }
    }
}

