/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.ProjectDocumentListener;
import org.gvsig.app.project.documents.gui.WindowLayout;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.PropertiesSupportHelper;

public abstract class AbstractDocument
extends AbstractDisposable
implements Serializable,
Persistent,
Document {
    private static final long serialVersionUID = 3335040973071555406L;
    public static final String PERSISTENCE_DEFINITION_NAME = "AbstractDocument";
    protected PropertyChangeSupport change;
    private Project project = null;
    private String name;
    private String creationDate;
    private String owner;
    private String comment;
    private boolean locked = false;
    private boolean isModified = false;
    private DocumentManager factory = null;
    private WindowLayout windowLayout = null;
    private PropertiesSupportHelper propertiesHelper;
    private List<ProjectDocumentListener> projectDocListener = new ArrayList<ProjectDocumentListener>();

    public AbstractDocument() {
        this.creationDate = DateFormat.getDateInstance().format(new Date());
        this.change = new PropertyChangeSupport(this);
        this.name = PluginServices.getText((Object)this, (String)"untitled");
        this.propertiesHelper = new PropertiesSupportHelper();
    }

    public AbstractDocument(DocumentManager factory) {
        this();
        this.factory = factory;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeName() {
        return this.factory.getTypeName();
    }

    @Override
    public void setName(String name) {
        Document doc;
        if (this.isLocked()) {
            throw new RuntimeException("this document is locked");
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = null;
        }
        if (this.project != null && (doc = this.project.getDocument(name, this.getTypeName())) != null && !this.equals(doc)) {
            throw new RuntimeException("document name already exists in project");
        }
        String previousName = this.name;
        this.name = name;
        this.change.firePropertyChange("name", previousName, name);
    }

    @Override
    public String getCreationDate() {
        return this.creationDate;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setCreationDate(String string) {
        this.creationDate = string;
        this.change.firePropertyChange("creationDate", this.creationDate, this.creationDate);
    }

    @Override
    public void setOwner(String string) {
        String oldOwner = this.owner;
        this.owner = string;
        this.change.firePropertyChange("owner", oldOwner, this.owner);
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String string) {
        String oldComment = this.comment;
        this.comment = string;
        this.change.firePropertyChange("comment", oldComment, this.comment);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.change.addPropertyChangeListener(listener);
    }

    @Override
    public void addListener(ProjectDocumentListener listener) {
        if (this.projectDocListener.indexOf(listener) == -1) {
            this.projectDocListener.add(listener);
        }
    }

    @Override
    public WindowLayout getWindowLayout() {
        return this.windowLayout;
    }

    @Override
    public void setWindowLayout(WindowLayout layout) {
        this.windowLayout = layout;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.setComment(state.getString("comment"));
        this.setCreationDate(state.getString("creationDate"));
        this.setName(state.getString("name"));
        this.setOwner(state.getString("owner"));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("comment", this.comment);
        state.set("creationDate", this.creationDate);
        state.set("name", this.name);
        state.set("owner", this.owner);
        state.set("locked", this.locked);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENCE_DEFINITION_NAME);
        if (definition == null) {
            definition = manager.addDefinition(AbstractDocument.class, PERSISTENCE_DEFINITION_NAME, "Document persistence definition", null, null);
            definition.addDynFieldString("comment").setMandatory(false);
            definition.addDynFieldString("creationDate").setMandatory(true);
            definition.addDynFieldString("name").setMandatory(true);
            definition.addDynFieldString("owner").setMandatory(false);
            definition.addDynFieldBoolean("locked").setMandatory(true);
        }
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public void lock() {
        boolean oldLocked = this.locked;
        this.locked = Boolean.TRUE;
        this.change.firePropertyChange("locked", oldLocked, this.locked);
    }

    @Override
    public void unlock() {
        boolean oldLocked = this.locked;
        this.locked = Boolean.FALSE;
        this.change.firePropertyChange("locked", oldLocked, this.locked);
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public DocumentManager getFactory() {
        return this.factory;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public void setModified(boolean modified) {
        this.isModified = modified;
    }

    public void raiseEventCreateWindow(IWindow window) {
        for (int i = 0; i < this.projectDocListener.size(); ++i) {
            this.projectDocListener.get(i).windowCreated(window);
        }
    }

    protected void callCreateWindow(IWindow window) {
        this.raiseEventCreateWindow(window);
    }

    @Override
    public void afterAdd() {
    }

    @Override
    public void afterRemove() {
    }

    public String exportDocumentAsText() {
        throw new UnsupportedOperationException();
    }

    public void setStateFromText(String text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IWindow getPropertiesWindow() {
        return this.getFactory().getPropertiesWindow(this);
    }

    @Override
    public IWindow getMainWindow() {
        return this.getFactory().getMainWindow(this);
    }

    @Override
    public JComponent getMainComponent() {
        return this.getFactory().getMainComponent(this);
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean getOpenWhenTheUserCreates() {
        return true;
    }

    public boolean contains(Object value) {
        return false;
    }

    @Override
    public void refresh() {
    }

    public Object getProperty(String name) {
        return this.propertiesHelper.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesHelper.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesHelper.getProperties();
    }

    protected void doDispose() throws BaseException {
    }
}

