/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.SetOfIntegerSyntax;
import javax.print.attribute.standard.PageRanges;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.jpedal.PdfDecoder;
import org.jpedal.exception.PdfException;

public class PDFViewerWindow
extends JPanel
implements IWindow,
PropertyChangeListener {
    private static final long serialVersionUID = 4022263653761949704L;
    private WindowInfo m_viewInfo;
    private PdfDecoder pf;
    private String currentFile = null;
    private int currentPage = 1;
    private final JLabel pageCounter1 = new JLabel(" " + PluginServices.getText((Object)this, (String)"Pagina") + " ");
    private JTextField pageCounter2 = new JTextField(4);
    private JLabel pageCounter3 = new JLabel(PluginServices.getText((Object)this, (String)"de"));

    public PDFViewerWindow(String currentFile) {
        this.initialize(currentFile);
    }

    private void initialize(String currentFile) {
        this.pf = new PdfDecoder();
        this.currentFile = currentFile;
        try {
            this.pf.openPdfFile(currentFile);
            this.pf.decodePage(this.currentPage);
            float scaling = 1.5f;
            this.pf.setPageParameters(scaling, 1);
            this.pf.setDisplayView(1, 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initializeViewer();
        this.pageCounter2.setText(this.currentPage + "");
        this.pageCounter3.setText(PluginServices.getText((Object)this, (String)"de") + " " + this.pf.getPageCount() + " ");
    }

    public void setCurrentFile(String currentFile) {
        this.currentFile = currentFile;
    }

    private void initializeViewer() {
        PDFViewerWindow cPane = this;
        cPane.setLayout(new BorderLayout());
        Component[] itemsToAdd = this.initChangerPanel();
        JPanel topBar = new JPanel();
        topBar.setLayout(new FlowLayout(1, 0, 0));
        for (int i = 0; i < itemsToAdd.length; ++i) {
            topBar.add(itemsToAdd[i]);
        }
        cPane.add((Component)topBar, "North");
        JScrollPane display = this.getJPaneViewer();
        cPane.add((Component)display, "Center");
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screen.width / 2, screen.height / 2);
        this.setVisible(true);
    }

    private Component[] initChangerPanel() {
        Component[] list = new Component[12];
        JButton start = new JButton();
        start.setBorderPainted(false);
        URL startImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/start.gif");
        start.setIcon(new ImageIcon(startImage));
        start.setToolTipText(PluginServices.getText((Object)this, (String)"primera_pagina"));
        list[0] = start;
        start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFViewerWindow.this.currentFile != null && PDFViewerWindow.this.currentPage != 1) {
                    PDFViewerWindow.this.currentPage = 1;
                    try {
                        PDFViewerWindow.this.pf.decodePage(PDFViewerWindow.this.currentPage);
                        PDFViewerWindow.this.pf.invalidate();
                        PDFViewerWindow.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("back to page 1");
                        e1.printStackTrace();
                    }
                    PDFViewerWindow.this.pageCounter2.setText(PDFViewerWindow.this.currentPage + "");
                }
            }
        });
        JButton fback = new JButton();
        fback.setBorderPainted(false);
        URL fbackImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/fback.gif");
        fback.setIcon(new ImageIcon(fbackImage));
        fback.setToolTipText(PluginServices.getText((Object)this, (String)"diez_paginas_atras"));
        list[1] = fback;
        fback.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFViewerWindow.this.currentFile != null && PDFViewerWindow.this.currentPage > 10) {
                    PDFViewerWindow.this.currentPage = PDFViewerWindow.this.currentPage - 10;
                    try {
                        PDFViewerWindow.this.pf.decodePage(PDFViewerWindow.this.currentPage);
                        PDFViewerWindow.this.pf.invalidate();
                        PDFViewerWindow.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("back 10 pages");
                        e1.printStackTrace();
                    }
                    PDFViewerWindow.this.pageCounter2.setText(PDFViewerWindow.this.currentPage + "");
                }
            }
        });
        JButton back = new JButton();
        back.setBorderPainted(false);
        URL backImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/back.gif");
        back.setIcon(new ImageIcon(backImage));
        back.setToolTipText(PluginServices.getText((Object)this, (String)"pagina_atras"));
        list[2] = back;
        back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFViewerWindow.this.currentFile != null && PDFViewerWindow.this.currentPage > 1) {
                    PDFViewerWindow.this.currentPage = PDFViewerWindow.this.currentPage - 1;
                    try {
                        PDFViewerWindow.this.pf.decodePage(PDFViewerWindow.this.currentPage);
                        PDFViewerWindow.this.pf.invalidate();
                        PDFViewerWindow.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("back 1 page");
                        e1.printStackTrace();
                    }
                    PDFViewerWindow.this.pageCounter2.setText(PDFViewerWindow.this.currentPage + "");
                }
            }
        });
        this.pageCounter2.setEditable(true);
        this.pageCounter2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                String value = PDFViewerWindow.this.pageCounter2.getText().trim();
                try {
                    int newPage = Integer.parseInt(value);
                    if (newPage > PDFViewerWindow.this.pf.getPageCount() | newPage < 1) {
                        return;
                    }
                    PDFViewerWindow.this.currentPage = newPage;
                    try {
                        PDFViewerWindow.this.pf.decodePage(PDFViewerWindow.this.currentPage);
                        PDFViewerWindow.this.pf.invalidate();
                        PDFViewerWindow.this.repaint();
                    }
                    catch (Exception e) {
                        System.err.println("page number entered");
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, ">" + value + "< " + PluginServices.getText((Object)this, (String)"valor_incorrecto") + PDFViewerWindow.this.pf.getPageCount());
                }
            }
        });
        list[3] = this.pageCounter1;
        list[4] = new JPanel();
        list[5] = this.pageCounter2;
        list[6] = new JPanel();
        list[7] = this.pageCounter3;
        JButton forward = new JButton();
        forward.setBorderPainted(false);
        URL fowardImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/forward.gif");
        forward.setIcon(new ImageIcon(fowardImage));
        forward.setToolTipText(PluginServices.getText((Object)this, (String)"pagina_delante"));
        list[8] = forward;
        forward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFViewerWindow.this.currentFile != null && PDFViewerWindow.this.currentPage < PDFViewerWindow.this.pf.getPageCount()) {
                    PDFViewerWindow.this.currentPage = PDFViewerWindow.this.currentPage + 1;
                    try {
                        PDFViewerWindow.this.pf.decodePage(PDFViewerWindow.this.currentPage);
                        PDFViewerWindow.this.pf.invalidate();
                        PDFViewerWindow.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("forward 1 page");
                        e1.printStackTrace();
                    }
                    PDFViewerWindow.this.pageCounter2.setText(PDFViewerWindow.this.currentPage + "");
                }
            }
        });
        JButton fforward = new JButton();
        fforward.setBorderPainted(false);
        URL ffowardImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/fforward.gif");
        fforward.setIcon(new ImageIcon(ffowardImage));
        fforward.setToolTipText(PluginServices.getText((Object)this, (String)"10_paginas_delante"));
        list[9] = fforward;
        fforward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFViewerWindow.this.currentFile != null && PDFViewerWindow.this.currentPage < PDFViewerWindow.this.pf.getPageCount() - 9) {
                    PDFViewerWindow.this.currentPage = PDFViewerWindow.this.currentPage + 10;
                    try {
                        PDFViewerWindow.this.pf.decodePage(PDFViewerWindow.this.currentPage);
                        PDFViewerWindow.this.pf.invalidate();
                        PDFViewerWindow.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("forward 10 pages");
                        e1.printStackTrace();
                    }
                    PDFViewerWindow.this.pageCounter2.setText(PDFViewerWindow.this.currentPage + "");
                }
            }
        });
        JButton end = new JButton();
        end.setBorderPainted(false);
        URL endImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/end.gif");
        end.setIcon(new ImageIcon(endImage));
        end.setToolTipText(PluginServices.getText((Object)this, (String)"ultima_pagina"));
        list[10] = end;
        end.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PDFViewerWindow.this.currentFile != null && PDFViewerWindow.this.currentPage < PDFViewerWindow.this.pf.getPageCount()) {
                    PDFViewerWindow.this.currentPage = PDFViewerWindow.this.pf.getPageCount();
                    try {
                        PDFViewerWindow.this.pf.decodePage(PDFViewerWindow.this.currentPage);
                        PDFViewerWindow.this.pf.invalidate();
                        PDFViewerWindow.this.repaint();
                    }
                    catch (Exception e1) {
                        System.err.println("forward to last page");
                        e1.printStackTrace();
                    }
                    PDFViewerWindow.this.pageCounter2.setText(PDFViewerWindow.this.currentPage + "");
                }
            }
        });
        JButton print = new JButton();
        print.setBorderPainted(false);
        URL printImage = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/print.gif");
        print.setIcon(new ImageIcon(printImage));
        print.setToolTipText(PluginServices.getText((Object)this, (String)"imprimir"));
        list[11] = print;
        print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PDFViewerWindow.this.printPDF();
            }
        });
        return list;
    }

    public void printPDF() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPageable((Pageable)this.pf);
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(new PageRanges(1, this.pf.getPageCount()));
        boolean printFile = printJob.printDialog(aset);
        PageRanges r = (PageRanges)aset.get(PageRanges.class);
        if (r != null) {
            try {
                PageFormat pformat = printJob.defaultPage();
                Paper paper = new Paper();
                paper.setSize(595.0, 842.0);
                paper.setImageableArea(43.0, 43.0, 545.0, 792.0);
                pformat.setPaper(paper);
                this.pf.setPageFormat(pformat);
                this.pf.setPagePrintRange((SetOfIntegerSyntax)r);
            }
            catch (PdfException e) {
                e.printStackTrace();
            }
        }
        if (printFile) {
            try {
                this.pf.setPrintPageScalingMode(1);
                printJob.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
    }

    private JScrollPane getJPaneViewer() {
        JScrollPane currentScroll = new JScrollPane();
        currentScroll.setHorizontalScrollBarPolicy(30);
        currentScroll.setVerticalScrollBarPolicy(20);
        currentScroll.setViewportView((Component)this.pf);
        return currentScroll;
    }

    public WindowInfo getWindowInfo() {
        if (this.m_viewInfo == null) {
            this.m_viewInfo = new WindowInfo(32);
            this.m_viewInfo.setMaximizable(true);
            this.m_viewInfo.setWidth(this.getWidth());
            this.m_viewInfo.setHeight(this.getHeight());
            this.m_viewInfo.setTitle(PluginServices.getText((Object)this, (String)"pdf_viewer"));
        }
        return this.m_viewInfo;
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
    }

    public Object getWindowProfile() {
        return WindowInfo.TOOL_PROFILE;
    }
}

