/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.dalactions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.util.HasAFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTemporalLayerAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateTemporalLayerAction.class);
    private final DALActionFactory.DALActionContext context;

    public CreateTemporalLayerAction(DALActionFactory.DALActionContext context) {
        this.context = context;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("ActionCommandKey", "CreateTemporalLayerAction");
        this.putValue("ShortDescription", i18n.getTranslation("_Create_layer_filtered"));
        this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("view-layer-add"));
    }

    private FeatureStore createTemporaryH2Store(String name, FeatureType ft_sourceStore, FeatureQuery query) throws Exception {
        FoldersManager foldersManager = ToolsLocator.getFoldersManager();
        File tempFile = foldersManager.getUniqueTemporaryFile(new String[]{name + UUID.randomUUID().toString()});
        DataManager dataManager = DALLocator.getDataManager();
        DataServerExplorerParameters serverParameters = dataManager.createServerExplorerParameters("H2Spatial");
        ((HasAFile)serverParameters).setFile(tempFile);
        JDBCServerExplorer serverExplorer = (JDBCServerExplorer)dataManager.openServerExplorer("H2Spatial", serverParameters);
        JDBCNewStoreParameters newParametersTarget = serverExplorer.getAddParameters();
        newParametersTarget.setDynValue("Table", (Object)name);
        EditableFeatureType ft_targetStore = dataManager.createFeatureType();
        ft_targetStore.addAll(ft_sourceStore);
        boolean ignoreDefaultGeometry = false;
        if (query != null) {
            for (EditableFeatureAttributeDescriptor column : query.getExtraColumn().getColumns()) {
                if (column.getType() != 66) continue;
                ignoreDefaultGeometry = true;
            }
        }
        for (Object attr : ft_sourceStore) {
            DataType dataType = attr.getDataType();
            EditableFeatureAttributeDescriptor eattr = ft_targetStore.getEditableAttributeDescriptor(attr.getName());
            if (dataType.isContainer()) {
                ft_targetStore.remove(attr.getName());
                continue;
            }
            if (dataType.getType() == 66 && ignoreDefaultGeometry) {
                ft_targetStore.remove(attr.getName());
                continue;
            }
            if (eattr.isComputed()) {
                eattr.setFeatureAttributeEmulator((FeatureAttributeEmulator)null);
            }
            if (eattr.isPrimaryKey()) {
                eattr.setIsPrimaryKey(false);
            }
            if (eattr.allowIndexDuplicateds()) continue;
            eattr.setAllowIndexDuplicateds(true);
        }
        HashMap<String, Object> allExtraColumns = new HashMap<String, Object>();
        for (Object column : ft_sourceStore.getExtraColumns().getColumns()) {
            allExtraColumns.put(column.getName(), column);
        }
        if (query != null) {
            for (Object column : query.getExtraColumn().getColumns()) {
                allExtraColumns.put(column.getName(), column);
            }
        }
        if (allExtraColumns.size() > 0) {
            for (Object column : allExtraColumns.values()) {
                DataType dataType = column.getDataType();
                if (dataType.isContainer()) continue;
                EditableFeatureAttributeDescriptor attr = ft_targetStore.add(column.getName(), column.getType());
                attr.copyFrom((DynField)column);
                attr.setFeatureAttributeEmulator((Expression)null);
            }
        }
        NamesTranslator tr = NamesTranslator.createBaseTranslator();
        for (FeatureAttributeDescriptor attr : ft_targetStore) {
            tr.addSource(attr.getName());
        }
        String suggestedPk = tr.getSuggestion("ID");
        EditableFeatureAttributeDescriptor pkAttr = ft_targetStore.add(suggestedPk, 5);
        pkAttr.setIsPrimaryKey(true);
        newParametersTarget.setDefaultFeatureType((FeatureType)ft_targetStore);
        serverExplorer.add("H2Spatial", (NewDataStoreParameters)newParametersTarget, true);
        DataStoreParameters openParametersTarget = dataManager.createStoreParameters("H2Spatial");
        openParametersTarget.setDynValue("database_file", (Object)tempFile);
        openParametersTarget.setDynValue("Table", (Object)name);
        FeatureStore storeResults = (FeatureStore)dataManager.openStore("H2Spatial", openParametersTarget);
        return storeResults;
    }

    private FLyrVect getFLyrVect(FeatureStore store) {
        ApplicationManager aplication = ApplicationLocator.getApplicationManager();
        FLayer layer = aplication.getCurrentLayer();
        if (layer instanceof FLyrVect && ((FLyrVect)layer).getFeatureStore() == store) {
            return (FLyrVect)layer;
        }
        ViewDocument viewDoc = (ViewDocument)aplication.getActiveDocument(ViewDocument.class);
        if (viewDoc == null) {
            return null;
        }
        for (FLayer layer1 : viewDoc.getMapContext().getLayers().getLayers(null)) {
            if (!(layer1 instanceof FLyrVect) || ((FLyrVect)layer1).getFeatureStore() != store) continue;
            return (FLyrVect)layer1;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        block15: {
            FeatureStore featureStore = null;
            FeatureStore targetStore = null;
            FeatureSet fs = null;
            ApplicationManager aplication = ApplicationLocator.getApplicationManager();
            try {
                Document viewDoc = aplication.getActiveDocument(ViewDocument.class);
                if (viewDoc == null) {
                    return;
                }
                DataStore store = this.context.getStore();
                if (!(store instanceof FeatureStore)) {
                    return;
                }
                featureStore = (FeatureStore)store;
                FeatureQuery query = this.context.getQuery();
                targetStore = this.createTemporaryH2Store(featureStore.getName() + "_filtered", featureStore.getDefaultFeatureTypeQuietly(), query);
                fs = featureStore.getFeatureSet(query);
                targetStore.edit(2);
                long n = 0L;
                String pkName = targetStore.getDefaultFeatureTypeQuietly().getPrimaryKey()[0].getName();
                for (Feature f : fs) {
                    EditableFeature newf = targetStore.createNewFeature(f);
                    newf.set(pkName, (Object)n++);
                    targetStore.insert(newf);
                }
                targetStore.finishEditingQuietly();
                FLyrVect layer = (FLyrVect)MapContextLocator.getMapContextManager().createLayer(targetStore.getName(), (DataStore)targetStore);
                layer.setTemporary(true);
                FLyrVect sourceLayer = this.getFLyrVect(featureStore);
                if (sourceLayer != null) {
                    layer.setProjection(sourceLayer.getProjection());
                    if (!query.hasGroupByColumns()) {
                        try {
                            if (sourceLayer != null && sourceLayer.getGeometryType() == layer.getGeometryType()) {
                                ILegend legend = sourceLayer.getLegend().cloneLegend();
                                layer.setLegend((IVectorLegend)legend);
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Not able to apply same legend", (Throwable)ex);
                        }
                    }
                }
                IView view = (IView)viewDoc.getMainWindow();
                view.getMapControl().addLayer((FLayer)layer);
                DisposeUtils.disposeQuietly((Disposable)fs);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't create filtered layer.", (Throwable)ex);
                FeatureStore.cancelEditingQuietly(targetStore);
                break block15;
            }
            finally {
                DisposeUtils.disposeQuietly(fs);
                DisposeUtils.disposeQuietly(featureStore);
                DisposeUtils.disposeQuietly(targetStore);
            }
            DisposeUtils.disposeQuietly((Disposable)featureStore);
            DisposeUtils.disposeQuietly((Disposable)targetStore);
        }
    }

    public static class CreateTemporalLayerActionFactory
    extends AbstractDALActionFactory {
        public static final String ACTION_NAME = "CreateTemporalLayerAction";

        public CreateTemporalLayerActionFactory() {
            super(ACTION_NAME);
        }

        public Action createAction(DALActionFactory.DALActionContext context) {
            return new CreateTemporalLayerAction(context);
        }

        public static void selfRegister() {
            DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
            dalSwingManager.registerStoreAction((DALActionFactory)new CreateTemporalLayerActionFactory());
        }
    }
}

