/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.expressionevaluator;

import java.util.Objects;
import org.cresques.cts.IProjection;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.spi.AbstractElement;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class ViewTakeProjectionCodeElement
extends AbstractElement
implements Element.SimpleElement,
Element.ConstantElement {
    public ViewTakeProjectionCodeElement() {
        super("ViewTakeProjectionCode", (Object)ToolsLocator.getI18nManager().getTranslation("_Take_projection_code"), "expressionbuilder-element-view-projection-code");
    }

    private IProjection getCurrentProjection() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewDoc = (ViewDocument)application.getActiveDocument(ViewDocument.class);
        if (viewDoc == null) {
            return null;
        }
        IProjection proj = viewDoc.getMapContext().getProjection();
        return proj;
    }

    private Object getProjectionCode(IProjection proj) {
        if (proj == null) {
            return 0;
        }
        String[] proj_s = proj.getAbrev().split(":");
        try {
            int code = Integer.parseInt(proj_s[1]);
            return code;
        }
        catch (Exception ex) {
            return proj_s[1];
        }
    }

    public Object getValue() {
        IProjection proj = this.getCurrentProjection();
        return this.getProjectionCode(proj);
    }

    public String getRenderedValue() {
        return Objects.toString(this.getValue(), "0");
    }

    public String getDescription() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        IProjection proj = this.getCurrentProjection();
        StringBuilder html = new StringBuilder();
        html.append("<html>\n");
        html.append("<b>").append(i18n.getTranslation("_Constant")).append("</b><br>\n<br>\n");
        if (proj == null) {
            html.append("<b>").append(i18n.getTranslation("_Value")).append("</b> NULL<br>\n");
        } else {
            ExpressionEvaluatorManager expressionManager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
            Object code = this.getProjectionCode(proj);
            html.append("<b>").append(i18n.getTranslation("_Value")).append("</b> ").append(expressionManager.getReprMethod((Object)proj).repr((Object)proj)).append("</b>");
            html.append(" (").append(proj.getAbrev()).append(")<br>\n");
            html.append("<b>").append(i18n.getTranslation("_Type")).append("</b> ").append(code.getClass().getSimpleName()).append("<br>\n");
        }
        html.append("</html>\n");
        return html.toString();
    }
}

