/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.expressionevaluator.viewcapturepoint;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.expressionevaluator.viewcapturepoint.ViewCapturePointPanelView;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class ViewCapturePointPanel
extends ViewCapturePointPanelView
implements Component {
    private Geometry geometry = null;
    private MapControl mapControl = null;
    private String previousTool = null;
    private Behavior tool = null;

    public ViewCapturePointPanel() {
        this.initComponents();
    }

    private void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtGeometry);
        this.btnToggleCapture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewCapturePointPanel.this.doToggleCapture();
            }
        });
        this.tool = new PointBehavior(new PointListener(){

            public void point(PointEvent event) throws BehaviorException {
                ViewCapturePointPanel.this.setGeometry((Geometry)event.getMapPoint());
            }

            public void pointDoubleClick(PointEvent event) throws BehaviorException {
                ViewCapturePointPanel.this.setGeometry((Geometry)event.getMapPoint());
            }

            public Image getImageCursor() {
                return IconThemeHelper.getImage((String)"cursor-select-by-point");
            }

            public boolean cancelDrawing() {
                return false;
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                ViewCapturePointPanel.this.doEndCapture();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ViewCapturePointPanel.this.doEndCapture();
            }
        });
        toolsSwingManager.translate(this.lblConstantPoint);
        toolsSwingManager.translate(this.lblValue);
        toolsSwingManager.translate(this.lblDescription);
        toolsSwingManager.translate(this.lblCaptureAPointFromCurrentView);
        toolsSwingManager.translate(this.lblUseWktOrWkb);
        toolsSwingManager.translate(this.lblUseGeometryOrText);
        toolsSwingManager.translate((AbstractButton)this.rdoInsertAsGeometry);
        toolsSwingManager.translate((AbstractButton)this.rdoInsertAsString);
        toolsSwingManager.translate((AbstractButton)this.rdoInsertAsWKB);
        toolsSwingManager.translate((AbstractButton)this.rdoInsertAsWKT);
        toolsSwingManager.translate((AbstractButton)this.btnToggleCapture);
    }

    public JComponent asJComponent() {
        return this;
    }

    private void setGeometry(Geometry geom) {
        this.geometry = geom;
        try {
            String wkt = geom.convertToWKT();
            this.txtGeometry.setText(wkt);
        }
        catch (Exception ex) {
            this.txtGeometry.setText("#########");
        }
        this.txtGeometry.setCaretPosition(0);
    }

    private void doToggleCapture() {
        if (this.mapControl == null) {
            this.doStartCapture();
        } else {
            this.doEndCapture();
        }
    }

    private void doStartCapture() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return;
        }
        this.mapControl = ((IView)viewdoc.getMainWindow()).getMapControl();
        this.previousTool = this.mapControl.getCurrentTool();
        this.mapControl.addBehavior("ElementViewPointCaptureTool", this.tool);
        this.mapControl.setTool("ElementViewPointCaptureTool");
        this.btnToggleCapture.setText(i18n.getTranslation("_End_capture"));
    }

    private void doEndCapture() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (this.mapControl == null) {
            return;
        }
        this.mapControl.setTool(this.previousTool);
        this.mapControl = null;
        this.btnToggleCapture.setText(i18n.getTranslation("_Start_capture"));
    }

    Geometry getGeometry() {
        return this.geometry;
    }

    boolean insertAsWKT() {
        return this.rdoInsertAsWKT.isSelected();
    }

    boolean insertAsGeometry() {
        return this.rdoInsertAsGeometry.isSelected();
    }
}

