/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.expressionevaluator.viewpastegeom;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.expressionevaluator.viewpastegeom.ViewPasteGeomPanel;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilderHelper;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.expressionevaluator.swing.spi.AbstractElement;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class ViewPasteGeomElement
extends AbstractElement
implements Element.SimpleElement,
Element.CalculatedElement {
    private ViewPasteGeomPanel aditionalPanel;

    public ViewPasteGeomElement() {
        super("ViewPasteGeometry", (Object)ToolsLocator.getI18nManager().getTranslation("_Paste_geometry"), "expressionbuilder-element-view-paste-geometry");
    }

    public Object getValue() {
        if (this.aditionalPanel == null) {
            return null;
        }
        try {
            ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
            String s = toolsSwingManager.getFromClipboard();
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            List geoms = GeometryUtils.extractFrom((String)s, (IProjection)this.getCurrentProjection());
            if (geoms == null || geoms.isEmpty()) {
                return null;
            }
            Geometry geom = GeometryUtils.toAggregate((List)geoms, null);
            GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
            if (this.aditionalPanel.insertAsWKT()) {
                if (this.aditionalPanel.insertAsGeometry()) {
                    builder.geometry_support_type(GeometryExpressionBuilderHelper.GeometrySupportType.WKT);
                    return builder.geometry(geom).toString();
                }
                String wkt = geom.convertToWKT();
                return "'" + wkt + "'";
            }
            if (this.aditionalPanel.insertAsGeometry()) {
                builder.geometry_support_type(GeometryExpressionBuilderHelper.GeometrySupportType.WKB);
                return builder.geometry(geom).toString();
            }
            byte[] wkb = geom.convertToWKB();
            return builder.bytearray_hex(wkb);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get geometry value.", (Throwable)ex);
            return null;
        }
    }

    public String getRenderedValue() {
        Object v = this.getValue();
        if (v == null) {
            return super.getRenderedValue();
        }
        return v.toString();
    }

    public Component getAditionalPanel(JExpressionBuilder expressionBuilder) {
        if (this.aditionalPanel == null) {
            this.aditionalPanel = new ViewPasteGeomPanel();
        }
        return this.aditionalPanel;
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        return !application.getUIManager().isModalDialogShowing();
    }

    private IProjection getCurrentProjection() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewDoc = (ViewDocument)application.getActiveDocument(ViewDocument.class);
        if (viewDoc == null) {
            return null;
        }
        IProjection proj = viewDoc.getMapContext().getProjection();
        return proj;
    }
}

