/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.edition.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.legend.edition.gui.PanelEditInterval;
import org.gvsig.fmap.mapcontext.rendering.legend.IInterval;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.FInterval;

public class IntervalCellEditor
extends JButton
implements TableCellEditor {
    private static final long serialVersionUID = 2020808901328629215L;
    private List listeners = new ArrayList();
    private IInterval interval;
    private PanelEditInterval editPanel;

    public IntervalCellEditor() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && IntervalCellEditor.this.interval instanceof IInterval) {
                    IntervalCellEditor.this.editPanel.setFInterval(IntervalCellEditor.this.interval);
                    PluginServices.getMDIManager().addWindow((IWindow)IntervalCellEditor.this.editPanel);
                    if (IntervalCellEditor.this.editPanel.isOK()) {
                        IntervalCellEditor.this.interval = (IInterval)IntervalCellEditor.this.editPanel.getFInterval();
                        IntervalCellEditor.this.setBackground(Color.white);
                        IntervalCellEditor.this.setText(IntervalCellEditor.this.interval.toString());
                        IntervalCellEditor.this.stopCellEditing();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    IntervalCellEditor.this.stopCellEditing();
                } else if (e.getKeyCode() == 27) {
                    IntervalCellEditor.this.cancelCellEditing();
                }
            }
        });
        this.editPanel = new PanelEditInterval();
        this.setBackground(Color.white);
    }

    public void setCurrentInterval(FInterval i) {
        this.interval = i;
        this.setText(i.toString());
    }

    @Override
    public Object getCellEditorValue() {
        return this.interval;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.interval = (IInterval)value;
        this.setText(this.interval.toString());
        this.editPanel.setFInterval(this.interval);
        return this;
    }

    @Override
    public void cancelCellEditing() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener l = (CellEditorListener)this.listeners.get(i);
            ChangeEvent evt = new ChangeEvent(this);
            l.editingCanceled(evt);
        }
    }

    @Override
    public boolean stopCellEditing() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener l = (CellEditorListener)this.listeners.get(i);
            ChangeEvent evt = new ChangeEvent(this);
            l.editingStopped(evt);
        }
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }
}

