/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.logger.FormsLogger;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class BackgroundPainter
extends JPanel {
    private Painter m_background_painter;
    private Rectangle m_painter_rect;
    private Dimension m_pref_size = new Dimension(10, 10);

    public BackgroundPainter() {
        this.setOpaque(false);
    }

    public Dimension getPreferredSize() {
        return this.m_pref_size;
    }

    public void paintComponent(Graphics g) {
        try {
            if (this.m_background_painter != null) {
                if (this.m_painter_rect == null) {
                    this.m_painter_rect = new Rectangle();
                }
                this.m_painter_rect.setBounds(0, 0, this.getWidth(), this.getHeight());
                this.m_background_painter.paint(this, g, this.m_painter_rect);
            }
        }
        catch (Exception e) {
            FormsLogger.severe(e);
        }
    }

    public void setBackgroundPainter(Painter p) {
        this.m_background_painter = p;
        this.m_painter_rect = null;
        this.repaint();
    }

    public void updateUI() {
        super.updateUI();
        if (this.m_background_painter != null) {
            this.repaint();
        }
    }
}

