/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.provider;

import java.io.IOException;
import java.nio.Buffer;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BandInfo;
import org.gvsig.raster.lib.buffer.api.BandTileManager;
import org.gvsig.raster.lib.buffer.api.TileStruct;
import org.gvsig.raster.tilecache.provider.TileStructImage;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;

public class TileCacheBandPageManager
extends AbstractDisposable
implements BandTileManager {
    private TileStructImage tileStructImage;
    private int bandNumber;
    private int zoomLevel;

    public TileCacheBandPageManager(TileStructImage tileStructImage, int zoomLevel, int band) {
        this.tileStructImage = tileStructImage;
        this.bandNumber = band;
        this.zoomLevel = zoomLevel;
    }

    public boolean isSupportedSave() {
        return false;
    }

    public Band load(int row, int col, int dataType) throws IOException {
        int tileRow = row / this.getRowsPerTile();
        int tileCol = col / this.getColumnsPerTile();
        return this.tileStructImage.fetchTile(this.bandNumber, this.zoomLevel, tileRow, tileCol);
    }

    public BandInfo getBandInfo() {
        return null;
    }

    public void save(Buffer buffer, int row, int rows, int col, int cols, int dataType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int getRowsPerTile() {
        return this.tileStructImage.getRowsPerTile();
    }

    public int getColumnsPerTile() {
        return this.tileStructImage.getColumnsPerTile();
    }

    public TileStruct getTileStruct() {
        return this.tileStructImage.getTileStruct();
    }

    protected void doDispose() throws BaseException {
        this.tileStructImage = null;
    }
}

