/*
 * Decompiled with CFR 0.152.
 */
package com.notification.manager;

import com.notification.Notification;
import com.notification.NotificationFactory;
import com.notification.manager.SimpleManager;
import com.utils.MathUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Timer;

public class QueueManager
extends SimpleManager {
    private Timer m_timer;
    private int m_verticalPadding = 20;
    private double m_snapFactor = 0.2;
    private ScrollDirection m_scroll = ScrollDirection.SOUTH;

    public QueueManager() {
        this.m_timer = new Timer(50, new MovementManager());
        this.m_timer.start();
    }

    public QueueManager(NotificationFactory.Location loc) {
        super(loc);
        this.m_timer = new Timer(50, new MovementManager());
        this.m_timer.start();
    }

    public int getVerticalPadding() {
        return this.m_verticalPadding;
    }

    public void setVerticalPadding(int verticalPadding) {
        this.m_verticalPadding = verticalPadding;
    }

    public double getSnapFactor() {
        return this.m_snapFactor;
    }

    public void setSnapFactor(double snapFactor) {
        this.m_snapFactor = MathUtils.clamp(snapFactor, 0.0, 1.0);
    }

    public ScrollDirection getScrollDirection() {
        return this.m_scroll;
    }

    public void setScrollDirection(ScrollDirection dir) {
        this.m_scroll = dir;
    }

    public void stop() {
        this.m_timer.stop();
    }

    private class MovementManager
    implements ActionListener {
        private MovementManager() {
        }

        private int getPreviousShownIndex(List<Notification> notes, int startIndex) {
            for (int i = startIndex; i < notes.size(); ++i) {
                if (!notes.get(i).isShown()) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Notification> notes = QueueManager.this.getNotifications();
            if (notes.size() == 0) {
                return;
            }
            NotificationFactory.Location loc = QueueManager.this.getLocation();
            int startx = QueueManager.this.getScreen().getX(loc, notes.get(0));
            int starty = QueueManager.this.getScreen().getY(loc, notes.get(0));
            for (int i = notes.size() - 1; i >= 0; --i) {
                Notification note = notes.get(i);
                int prevIndex = this.getPreviousShownIndex(notes, i + 1);
                int dif = 0;
                int desdif = 0;
                if (prevIndex == -1) {
                    dif = note.getY() - starty;
                    desdif = 0;
                } else {
                    Notification prev = notes.get(prevIndex);
                    dif = note.getY() - prev.getY();
                    desdif = prev.getHeight() + QueueManager.this.m_verticalPadding;
                    if (QueueManager.this.m_scroll == ScrollDirection.NORTH) {
                        desdif *= -1;
                    }
                }
                int delta = desdif - dif;
                double moveAmount = (double)delta * QueueManager.this.m_snapFactor;
                if (Math.abs(moveAmount) < 1.0) {
                    moveAmount = MathUtils.sign(moveAmount);
                }
                note.setLocation(startx, note.getY() + (int)moveAmount);
            }
        }
    }

    public static enum ScrollDirection {
        NORTH,
        SOUTH;

    }
}

