/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.spatialjoin;

import es.unex.sextante.core.Sextante;
import java.util.Iterator;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;

public class SpatiallyIndexedSpatialJoinOperation
extends GeometryOperation {
    private FeatureStore storeOverlay = null;
    private FeatureSelection featureSelection = null;
    static final int DEFAULT_NUM_NEIGBOURS = 1;
    int numOfNeighbours = 1;
    private SpatialIndex index = null;

    public SpatiallyIndexedSpatialJoinOperation(FlyrVectIVectorLayer targetLayer, SpatialIndex index, AbstractSextanteGeoProcess p) {
        super(p);
        this.index = index;
        this.storeOverlay = targetLayer.getFeatureStore();
    }

    public EditableFeature invoke(final Geometry g, Feature featureInput) {
        final MutableObject foundFeature = new MutableObject(null);
        boolean addedFeature = false;
        if (g == null) {
            return this.lastEditFeature;
        }
        try {
            final MutableDouble nearestDistance = new MutableDouble(Double.POSITIVE_INFINITY);
            this.index.query(g, new Visitor(){

                public void visit(Object obj) throws VisitCanceledException, BaseException {
                    FeatureReference ref = (FeatureReference)obj;
                    Feature feat = ref.getFeature();
                    Geometry g2 = feat.getDefaultGeometry();
                    double dist = g.distance(g2);
                    if (dist <= nearestDistance.getValue()) {
                        nearestDistance.setValue(dist);
                        foundFeature.setValue((Object)feat.getCopy());
                    }
                }
            });
            Iterator iterator = this.index.queryNearest(g);
            while (iterator.hasNext()) {
                FeatureReference ref = (FeatureReference)iterator.next();
                Feature feat = ref.getFeature();
                Geometry g2 = feat.getDefaultGeometry();
                double dist = g.distance(g2);
                if (!(dist <= nearestDistance.getValue())) continue;
                nearestDistance.setValue(dist);
                foundFeature.setValue((Object)feat.getCopy());
            }
            if (foundFeature != null) {
                this.buildFeature(featureInput, (Feature)foundFeature.getValue(), new Double(nearestDistance.getValue()), g);
                addedFeature = true;
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return this.lastEditFeature;
    }

    private void buildFeature(Feature feat1, Feature feat2, Object value, Geometry g) throws DataException {
        EditableFeature outFeat = this.persister.getOutputFeatureStore().createNewFeature();
        NamesTranslator namesTranslator = this.process.getNamesTranslator();
        if (namesTranslator != null) {
            Object fValue;
            Object translation;
            String attrName;
            for (FeatureAttributeDescriptor attr1 : feat1.getType().getAttributeDescriptors()) {
                attrName = attr1.getName();
                translation = namesTranslator.getTranslation(attrName);
                fValue = feat1.get(attrName);
                if (translation == null || ((String)translation).isEmpty()) continue;
                outFeat.set((String)translation, fValue);
            }
            for (FeatureAttributeDescriptor attr2 : feat2.getType().getAttributeDescriptors()) {
                attrName = attr2.getName();
                translation = namesTranslator.getAllTranslations(attrName);
                fValue = feat2.get(attrName);
                if (translation == null || translation.isEmpty()) continue;
                outFeat.set((String)translation.get(translation.size() - 1), fValue);
            }
            outFeat.set(namesTranslator.getTranslation("DIST"), value);
        } else {
            outFeat.copyFrom(feat2);
            outFeat.copyFrom(feat1);
            outFeat.set("DIST", value);
        }
        try {
            this.persister.addFeature((Feature)outFeat, g);
        }
        catch (CreateGeometryException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void invoke(Geometry g, EditableFeature featureInput) {
    }
}

