/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageFunction;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PropertySource;
import javax.media.jai.PropertySourceImpl;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import javax.media.jai.widget.ScrollingImagePanel;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.io.LineWriter;
import org.geotools.referencing.operation.GeneralMatrix;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;
import org.geotools.resources.gcs.Resources;
import org.geotools.resources.geometry.XAffineTransform;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.SimpleInternationalString;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.MetadataNameNotFoundException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.util.InternationalString;

public abstract class AbstractCoverage
extends PropertySourceImpl
implements Coverage {
    private static final String[] DIMENSION_NAMES = new String[]{"x", "y", "z", "t"};
    private static final String[] NO_PROPERTIES = new String[0];
    private static final int VISIBLE_BAND = 0;
    private final InternationalString name;
    protected final CoordinateReferenceSystem crs;
    static /* synthetic */ Class class$org$geotools$coverage$AbstractCoverage;

    protected AbstractCoverage(CharSequence name, CoordinateReferenceSystem crs, PropertySource source, Map properties) {
        super(properties, source);
        this.name = SimpleInternationalString.wrap(name);
        this.crs = crs;
    }

    protected AbstractCoverage(CharSequence name, Coverage coverage) {
        super(null, coverage instanceof PropertySource ? (PropertySource)coverage : null);
        AbstractInternationalString n = SimpleInternationalString.wrap(name);
        if (coverage instanceof AbstractCoverage) {
            AbstractCoverage source = (AbstractCoverage)coverage;
            this.name = n != null ? n : source.name;
            this.crs = source.crs;
        } else {
            this.name = n != null ? n : new SimpleInternationalString(coverage.toString());
            this.crs = coverage.getCoordinateReferenceSystem();
        }
    }

    public InternationalString getName() {
        return this.name;
    }

    public List getSources() {
        return Collections.EMPTY_LIST;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public Envelope getEnvelope() {
        return CRSUtilities.getEnvelope(this.crs);
    }

    public int getDimension() {
        return this.crs.getCoordinateSystem().getDimension();
    }

    public InternationalString[] getDimensionNames() {
        if (this.crs != null) {
            CoordinateSystem cs = this.crs.getCoordinateSystem();
            InternationalString[] names = new InternationalString[cs.getDimension()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = new SimpleInternationalString(cs.getAxis(i).getName().getCode());
            }
            return names;
        }
        InternationalString[] names = (InternationalString[])XArray.resize(DIMENSION_NAMES, this.getDimension());
        for (int i = DIMENSION_NAMES.length; i < names.length; ++i) {
            names[i] = new SimpleInternationalString("dim" + (i + 1));
        }
        return names;
    }

    public final String[] getDimensionNames(Locale locale) {
        InternationalString[] inter = this.getDimensionNames();
        String[] names = new String[inter.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = inter[i].toString(locale);
        }
        return names;
    }

    private static String formatErrorMessage(Object array) {
        String text = "<null>";
        if (array != null) {
            Class<?> type = array.getClass();
            if (type.isArray()) {
                type = type.getComponentType();
            }
            text = Utilities.getShortName(type);
        }
        return Resources.format(83, text);
    }

    public boolean[] evaluate(DirectPosition coord, boolean[] dest) throws CannotEvaluateException {
        Object array = this.evaluate(coord);
        try {
            int length = Array.getLength(array);
            if (dest == null) {
                dest = new boolean[length];
            }
            for (int i = 0; i < length; ++i) {
                dest[i] = Array.getBoolean(array, i);
            }
        }
        catch (IllegalArgumentException exception) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(array), (Throwable)exception);
        }
        return dest;
    }

    public byte[] evaluate(DirectPosition coord, byte[] dest) throws CannotEvaluateException {
        Object array = this.evaluate(coord);
        try {
            int length = Array.getLength(array);
            if (dest == null) {
                dest = new byte[length];
            }
            for (int i = 0; i < length; ++i) {
                dest[i] = Array.getByte(array, i);
            }
        }
        catch (IllegalArgumentException exception) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(array), (Throwable)exception);
        }
        return dest;
    }

    public int[] evaluate(DirectPosition coord, int[] dest) throws CannotEvaluateException {
        Object array = this.evaluate(coord);
        try {
            int length = Array.getLength(array);
            if (dest == null) {
                dest = new int[length];
            }
            for (int i = 0; i < length; ++i) {
                dest[i] = Array.getInt(array, i);
            }
        }
        catch (IllegalArgumentException exception) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(array), (Throwable)exception);
        }
        return dest;
    }

    public float[] evaluate(DirectPosition coord, float[] dest) throws CannotEvaluateException {
        Object array = this.evaluate(coord);
        try {
            int length = Array.getLength(array);
            if (dest == null) {
                dest = new float[length];
            }
            for (int i = 0; i < length; ++i) {
                dest[i] = Array.getFloat(array, i);
            }
        }
        catch (IllegalArgumentException exception) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(array), (Throwable)exception);
        }
        return dest;
    }

    public double[] evaluate(DirectPosition coord, double[] dest) throws CannotEvaluateException {
        Object array = this.evaluate(coord);
        try {
            int length = Array.getLength(array);
            if (dest == null) {
                dest = new double[length];
            }
            for (int i = 0; i < length; ++i) {
                dest[i] = Array.getDouble(array, i);
            }
        }
        catch (IllegalArgumentException exception) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(array), (Throwable)exception);
        }
        return dest;
    }

    public RenderableImage getRenderableImage(int xAxis, int yAxis) {
        return new Renderable(xAxis, yAxis);
    }

    public void show(int xAxis, int yAxis) {
        RenderedImage image = this.getRenderableImage(xAxis, yAxis).createDefaultRendering();
        final Frame frame = new Frame(String.valueOf(this.getName()));
        frame.add((Component)new ScrollingImagePanel(image, Math.max(Math.min(image.getWidth(), 640), 24), Math.max(Math.min(image.getHeight(), 640), 24)));
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                frame.dispose();
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    public void show() {
        this.show(0, 1);
    }

    public String[] getMetadataNames() {
        String[] list = this.getPropertyNames();
        return list != null ? list : NO_PROPERTIES;
    }

    public String getMetadataValue(String name) throws MetadataNameNotFoundException {
        Object value = this.getProperty(name);
        if (value == Image.UndefinedProperty) {
            throw new MetadataNameNotFoundException(Resources.format(73, name));
        }
        return value != null ? value.toString() : null;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public void dispose() {
    }

    public String toString() {
        StringWriter buffer = new StringWriter();
        buffer.write(Utilities.getShortClassName((Object)this));
        buffer.write("[\"");
        buffer.write(String.valueOf(this.getName()));
        buffer.write(34);
        Envelope envelope = this.getEnvelope();
        if (envelope != null) {
            buffer.write(", ");
            buffer.write(envelope.toString());
        }
        if (this.crs != null) {
            buffer.write(", ");
            buffer.write(Utilities.getShortClassName(this.crs));
            buffer.write("[\"");
            buffer.write(this.crs.getName().getCode());
            buffer.write("\"]");
        }
        buffer.write(93);
        String lineSeparator = System.getProperty("line.separator", "\n");
        LineWriter filter = new LineWriter(buffer, lineSeparator + "    ");
        int n = this.getNumSampleDimensions();
        try {
            filter.write(lineSeparator);
            for (int i = 0; i < n; ++i) {
                filter.write(this.getSampleDimension(i).toString());
            }
            filter.flush();
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
        return buffer.toString();
    }

    protected class Renderable
    extends PropertySourceImpl
    implements RenderableImage,
    ImageFunction {
        private final Rectangle2D bounds;
        protected final int xAxis;
        protected final int yAxis;
        protected final GeneralDirectPosition coordinate;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Renderable(int xAxis, int yAxis) {
            super(null, (PropertySource)AbstractCoverage.this);
            this.coordinate = new GeneralDirectPosition(AbstractCoverage.this.getDimension());
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            Envelope envelope = AbstractCoverage.this.getEnvelope();
            this.bounds = new Rectangle2D.Double(envelope.getMinimum(xAxis), envelope.getMinimum(yAxis), envelope.getLength(xAxis), envelope.getLength(yAxis));
        }

        public Vector getSources() {
            return null;
        }

        public boolean isDynamic() {
            return false;
        }

        public boolean isComplex() {
            return false;
        }

        public float getWidth() {
            return (float)this.bounds.getWidth();
        }

        public float getHeight() {
            return (float)this.bounds.getHeight();
        }

        public float getMinX() {
            return (float)this.bounds.getX();
        }

        public float getMinY() {
            return (float)this.bounds.getY();
        }

        public RenderedImage createDefaultRendering() {
            return this.createScaledRendering(512, 0, null);
        }

        public RenderedImage createScaledRendering(int width, int height, RenderingHints hints) {
            double boundsWidth = this.bounds.getWidth();
            double boundsHeight = this.bounds.getHeight();
            if (width <= 0) {
                if (height <= 0) {
                    throw new IllegalArgumentException(Resources.format(79));
                }
                width = (int)Math.round((double)height * (boundsWidth / boundsHeight));
            } else if (height <= 0) {
                height = (int)Math.round((double)width * (boundsHeight / boundsWidth));
            }
            return this.createRendering(this.createRenderContext(new Rectangle(0, 0, width, height), hints));
        }

        public RenderedImage createRendering(RenderContext context) {
            TiledImage image;
            AffineTransform crsToGrid = context.getTransform();
            Shape area = context.getAreaOfInterest();
            Rectangle2D bounds = XAffineTransform.transform(crsToGrid, area != null ? area.getBounds2D() : this.bounds, null);
            int xmin = (int)Math.round(bounds.getMinX());
            int ymin = (int)Math.round(bounds.getMinY());
            int xmax = (int)Math.round(bounds.getMaxX());
            int ymax = (int)Math.round(bounds.getMaxY());
            Rectangle gridBounds = new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
            Dimension tileSize = ImageUtilities.toTileSize(gridBounds.getSize());
            GridSampleDimension band = GridSampleDimension.wrap(AbstractCoverage.this.getSampleDimension(0));
            ColorModel colorModel = band.getColorModel(0, AbstractCoverage.this.getNumSampleDimensions());
            SampleModel sampleModel = colorModel.createCompatibleSampleModel(tileSize.width, tileSize.height);
            if ((area == null || area instanceof Rectangle2D) && crsToGrid.getShearX() == 0.0 && crsToGrid.getShearY() == 0.0) {
                image = JAI.create((String)"ImageFunction", (ParameterBlock)new ParameterBlock().add(this).add(gridBounds.width).add(gridBounds.height).add((float)(1.0 / crsToGrid.getScaleX())).add((float)(1.0 / crsToGrid.getScaleY())).add((float)crsToGrid.getTranslateX()).add((float)crsToGrid.getTranslateY()), (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout().setMinX(gridBounds.x).setMinY(gridBounds.y).setTileWidth(tileSize.width).setTileHeight(tileSize.height).setSampleModel(sampleModel).setColorModel(colorModel)));
            } else {
                GeneralDirectPosition coordinate = new GeneralDirectPosition(this.coordinate);
                TiledImage tiled = new TiledImage(gridBounds.x, gridBounds.y, gridBounds.width, gridBounds.height, 0, 0, sampleModel, colorModel);
                Point2D.Double point2D = new Point2D.Double();
                int numBands = tiled.getNumBands();
                double[] samples = new double[numBands];
                double[] padNaNs = new double[numBands];
                Arrays.fill(padNaNs, Double.NaN);
                WritableRectIter iterator = RectIterFactory.createWritable((WritableRenderedImage)tiled, (Rectangle)gridBounds);
                if (!iterator.finishedLines()) {
                    try {
                        int y = gridBounds.y;
                        do {
                            iterator.startPixels();
                            if (iterator.finishedPixels()) continue;
                            int x = gridBounds.x;
                            do {
                                point2D.x = x;
                                point2D.y = y;
                                crsToGrid.inverseTransform(point2D, point2D);
                                if (area == null || area.contains(point2D)) {
                                    coordinate.ordinates[this.xAxis] = point2D.x;
                                    coordinate.ordinates[this.yAxis] = point2D.y;
                                    iterator.setPixel(AbstractCoverage.this.evaluate((DirectPosition)coordinate, samples));
                                } else {
                                    iterator.setPixel(padNaNs);
                                }
                                ++x;
                            } while (!iterator.nextPixelDone());
                            if (!$assertionsDisabled && x != gridBounds.x + gridBounds.width) {
                                throw new AssertionError();
                            }
                            ++y;
                        } while (!iterator.nextLineDone());
                        if (!$assertionsDisabled && y != gridBounds.y + gridBounds.height) {
                            throw new AssertionError();
                        }
                    }
                    catch (NoninvertibleTransformException exception) {
                        IllegalArgumentException e = new IllegalArgumentException("RenderContext");
                        e.initCause(exception);
                        throw e;
                    }
                }
                image = tiled;
            }
            try {
                image.setProperty("gridToCoordinateSystem", (Object)crsToGrid.createInverse());
            }
            catch (NoninvertibleTransformException exception) {
                Utilities.unexpectedException("org.geotools.coverage", "AbstractCoverage.Renderable", "createRendering", exception);
            }
            return image;
        }

        protected RenderContext createRenderContext(Rectangle2D gridBounds, RenderingHints hints) {
            GeneralMatrix matrix;
            GeneralEnvelope srcEnvelope = new GeneralEnvelope(this.bounds);
            GeneralEnvelope dstEnvelope = new GeneralEnvelope(gridBounds);
            if (AbstractCoverage.this.crs != null) {
                CoordinateSystem cs = AbstractCoverage.this.crs.getCoordinateSystem();
                AxisDirection[] axis = new AxisDirection[]{cs.getAxis(this.xAxis).getDirection(), cs.getAxis(this.yAxis).getDirection()};
                AxisDirection[] normalized = (AxisDirection[])axis.clone();
                normalized[1] = normalized[1].opposite();
                matrix = new GeneralMatrix(srcEnvelope, axis, dstEnvelope, normalized);
            } else {
                matrix = new GeneralMatrix(srcEnvelope, dstEnvelope);
            }
            return new RenderContext(matrix.toAffineTransform2D(), hints);
        }

        public int getNumElements() {
            return AbstractCoverage.this.getNumSampleDimensions();
        }

        public void getElements(float startX, float startY, float deltaX, float deltaY, int countX, int countY, int element, float[] real, float[] imag) {
            int index = 0;
            float[] buffer = null;
            GeneralDirectPosition coordinate = new GeneralDirectPosition(this.coordinate);
            coordinate.ordinates[1] = startY;
            for (int j = 0; j < countY; ++j) {
                coordinate.ordinates[0] = startX;
                for (int i = 0; i < countX; ++i) {
                    buffer = AbstractCoverage.this.evaluate((DirectPosition)coordinate, buffer);
                    real[index++] = buffer[element];
                    coordinate.ordinates[0] = coordinate.ordinates[0] + (double)deltaX;
                }
                coordinate.ordinates[1] = coordinate.ordinates[1] + (double)deltaY;
            }
        }

        public void getElements(double startX, double startY, double deltaX, double deltaY, int countX, int countY, int element, double[] real, double[] imag) {
            int index = 0;
            double[] buffer = null;
            GeneralDirectPosition coordinate = new GeneralDirectPosition(this.coordinate);
            coordinate.ordinates[1] = startY;
            for (int j = 0; j < countY; ++j) {
                coordinate.ordinates[0] = startX;
                for (int i = 0; i < countX; ++i) {
                    buffer = AbstractCoverage.this.evaluate((DirectPosition)coordinate, buffer);
                    real[index++] = buffer[element];
                    coordinate.ordinates[0] = coordinate.ordinates[0] + deltaX;
                }
                coordinate.ordinates[1] = coordinate.ordinates[1] + deltaY;
            }
        }

        static {
            $assertionsDisabled = !(class$org$geotools$coverage$AbstractCoverage == null ? (class$org$geotools$coverage$AbstractCoverage = AbstractCoverage.class$("org.geotools.coverage.AbstractCoverage")) : class$org$geotools$coverage$AbstractCoverage).desiredAssertionStatus();
        }
    }
}

