/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.image.ColorModel;
import java.awt.image.RasterFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.media.jai.iterator.WritableRectIter;
import javax.units.Unit;
import org.geotools.coverage.Category;
import org.geotools.coverage.ColorModelFactory;
import org.geotools.coverage.GeophysicsCategoryList;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.GeneralMatrix;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.geotools.resources.Utilities;
import org.geotools.resources.gcs.Resources;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.NumberRange;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;
import org.opengis.util.InternationalString;

class CategoryList
extends AbstractList
implements MathTransform1D,
Comparator,
Serializable {
    private static final long serialVersionUID = 2647846361059903365L;
    final CategoryList inverse;
    private transient NumberRange range;
    private final double[] minimums;
    private final Category[] categories;
    private final Category main;
    final Category nodata;
    private final Category overflowFallback;
    private transient Category last;
    private final boolean hasGaps;
    private transient InternationalString name;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CategoryList(Category[] categories, Unit units) throws IllegalArgumentException {
        this(categories, units, false, null);
        if (!$assertionsDisabled && !this.isScaled(false)) {
            throw new AssertionError();
        }
    }

    CategoryList(Category[] categories, Unit units, boolean searchNearest, CategoryList inverse) throws IllegalArgumentException {
        boolean isGeophysics = this instanceof GeophysicsCategoryList;
        if (!$assertionsDisabled && inverse != null != isGeophysics) {
            throw new AssertionError();
        }
        categories = (Category[])categories.clone();
        this.categories = categories;
        for (int i = 0; i < categories.length; ++i) {
            categories[i] = categories[i].geophysics(isGeophysics);
        }
        Arrays.sort(categories, this);
        if (!$assertionsDisabled && !CategoryList.isSorted(categories)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.isScaled(isGeophysics)) {
            throw new AssertionError();
        }
        boolean hasGaps = false;
        this.minimums = new double[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            double minimum = this.minimums[i] = categories[i].minimum;
            if (i == 0) continue;
            if (!$assertionsDisabled && minimum < this.minimums[i - 1]) {
                throw new AssertionError(minimum);
            }
            Category previous = categories[i - 1];
            if (CategoryList.compare(minimum, previous.maximum) <= 0) {
                NumberRange range1 = categories[i - 1].getRange();
                NumberRange range2 = categories[i - 0].getRange();
                Comparable[] args = new Comparable[]{range1.getMinValue(), range1.getMaxValue(), range2.getMinValue(), range2.getMaxValue()};
                for (int j = 0; j < args.length; ++j) {
                    float value;
                    if (!(args[j] instanceof Number) || !Float.isNaN(value = ((Number)((Object)args[j])).floatValue())) continue;
                    String hex = Integer.toHexString(Float.floatToRawIntBits(value));
                    args[j] = "NaN(" + hex + ')';
                }
                throw new IllegalArgumentException(Resources.format(69, args));
            }
            if (Double.isNaN(minimum) || minimum == previous.getRange().getMaximum(false)) continue;
            hasGaps = true;
        }
        this.hasGaps = hasGaps;
        Category nodata = Category.NODATA;
        long nodataBits = Double.doubleToRawLongBits(Double.NaN);
        int i = categories.length;
        while (--i >= 0) {
            Category candidate = categories[i];
            double value = candidate.geophysics((boolean)true).minimum;
            if (!Double.isNaN(value)) continue;
            nodata = candidate;
            if (Double.doubleToRawLongBits(value) != nodataBits) continue;
            break;
        }
        this.nodata = nodata;
        double range = 0.0;
        Category main = null;
        int i2 = categories.length;
        while (--i2 >= 0) {
            Category candidate = categories[i2];
            if (!candidate.isQuantitative()) continue;
            Category candidatePeer = candidate.geophysics(false);
            double candidateRange = candidatePeer.maximum - candidatePeer.minimum;
            if (!(candidateRange >= range)) continue;
            range = candidateRange;
            main = candidate;
        }
        this.main = main;
        this.last = main;
        Category overflowFallback = null;
        if (searchNearest) {
            int i3 = categories.length;
            while (--i3 >= 0) {
                Category category = categories[i3];
                if (Double.isNaN(category.maximum)) continue;
                overflowFallback = category;
                break;
            }
        }
        this.overflowFallback = overflowFallback;
        if (inverse == null) {
            inverse = new GeophysicsCategoryList(categories, units, this);
        }
        this.inverse = inverse;
        if (!$assertionsDisabled && this instanceof GeophysicsCategoryList == inverse instanceof GeophysicsCategoryList) {
            throw new AssertionError();
        }
    }

    public final int compare(Object o1, Object o2) {
        return CategoryList.compare(((Category)o1).minimum, ((Category)o2).minimum);
    }

    private static int compare(double v1, double v2) {
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            long bits2;
            long bits1 = Double.doubleToRawLongBits(v1);
            if (bits1 < (bits2 = Double.doubleToRawLongBits(v2))) {
                return -1;
            }
            if (bits1 > bits2) {
                return 1;
            }
        }
        return Double.compare(v1, v2);
    }

    static boolean isSorted(Category[] categories) {
        for (int i = 1; i < categories.length; ++i) {
            Category c;
            if (!$assertionsDisabled) {
                Category category;
                c = categories[i - 0];
                if (category.minimum > c.maximum) {
                    throw new AssertionError(c);
                }
            }
            if (!$assertionsDisabled) {
                Category category;
                c = categories[i - 1];
                if (category.minimum > c.maximum) {
                    throw new AssertionError(c);
                }
            }
            if (CategoryList.compare(categories[i - 1].maximum, categories[i].minimum) <= 0) continue;
            return false;
        }
        return true;
    }

    static int binarySearch(double[] array, double key) {
        int low = 0;
        int high = array.length - 1;
        boolean keyIsNaN = Double.isNaN(key);
        while (low <= high) {
            boolean adjustLow;
            long keyRawBits;
            int mid = low + high >> 1;
            double midVal = array[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            long midRawBits = Double.doubleToRawLongBits(midVal);
            if (midRawBits == (keyRawBits = Double.doubleToRawLongBits(key))) {
                return mid;
            }
            boolean midIsNaN = Double.isNaN(midVal);
            if (keyIsNaN) {
                adjustLow = !midIsNaN || midRawBits < keyRawBits;
            } else {
                boolean bl = adjustLow = !midIsNaN && midRawBits < keyRawBits;
            }
            if (adjustLow) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    public CategoryList geophysics(boolean toGeophysics) {
        CategoryList scaled;
        CategoryList categoryList = scaled = toGeophysics ? this.inverse : this;
        if (!$assertionsDisabled && !scaled.isScaled(toGeophysics)) {
            throw new AssertionError();
        }
        return scaled;
    }

    final boolean isScaled(boolean toGeophysics) {
        return CategoryList.isScaled(this.categories, toGeophysics);
    }

    static boolean isScaled(Category[] categories, boolean toGeophysics) {
        for (int i = 0; i < categories.length; ++i) {
            Category c = categories[i];
            if (c.geophysics(toGeophysics) == c) continue;
            return false;
        }
        return true;
    }

    public final InternationalString getName() {
        if (this.name == null) {
            this.name = new Name();
        }
        return this.name;
    }

    public Unit getUnits() {
        return null;
    }

    public final NumberRange getRange() {
        if (this.range == null) {
            NumberRange range = null;
            for (int i = 0; i < this.categories.length; ++i) {
                NumberRange extent = this.categories[i].getRange();
                if (Double.isNaN(extent.getMinimum()) || Double.isNaN(extent.getMaximum())) continue;
                range = range != null ? NumberRange.wrap(range.union(extent)) : extent;
            }
            this.range = range;
        }
        return this.range;
    }

    private StringBuffer formatRange(StringBuffer buffer, Locale locale) {
        NumberRange range = this.getRange();
        buffer.append('[');
        if (range != null) {
            buffer = this.format(range.getMinimum(), false, locale, buffer);
            buffer.append("..");
            buffer = this.format(range.getMaximum(), true, locale, buffer);
        } else {
            Unit unit = this.getUnits();
            if (unit != null) {
                buffer.append(unit);
            }
        }
        buffer.append(']');
        return buffer;
    }

    StringBuffer format(double value, boolean writeUnits, Locale locale, StringBuffer buffer) {
        return buffer.append(value);
    }

    public final ColorModel getColorModel(int visibleBand, int numBands) {
        NumberRange range;
        Class rt;
        int type = 4;
        if (Byte.class.equals(rt = (range = this.getRange()).getElementClass()) || Short.class.equals(rt) || Integer.class.equals(rt)) {
            int min = ((Number)((Object)range.getMinValue())).intValue();
            int max = ((Number)((Object)range.getMaxValue())).intValue();
            type = min >= 0 ? (max < 256 ? 0 : (max < 65536 ? 1 : 3)) : (min >= Short.MIN_VALUE && max <= Short.MAX_VALUE ? 2 : 3);
        }
        return ColorModelFactory.getColorModel(this.categories, type, visibleBand, numBands);
    }

    public final ColorModel getColorModel(int visibleBand, int numBands, int type) {
        return ColorModelFactory.getColorModel(this.categories, type, visibleBand, numBands);
    }

    public final Category getCategory(double sample) {
        int i = CategoryList.binarySearch(this.minimums, sample);
        if (i >= 0) {
            if (!$assertionsDisabled && Double.doubleToRawLongBits(sample) != Double.doubleToRawLongBits(this.minimums[i])) {
                throw new AssertionError();
            }
            return this.categories[i];
        }
        if (Double.isNaN(sample)) {
            return null;
        }
        if (!$assertionsDisabled && i != Arrays.binarySearch(this.minimums, sample)) {
            throw new AssertionError(i);
        }
        if ((i = ~i - 1) >= 0) {
            Category category = this.categories[i];
            if (!$assertionsDisabled && !(sample > category.minimum)) {
                throw new AssertionError(sample);
            }
            if (sample <= category.maximum) {
                return category;
            }
            if (this.overflowFallback != null) {
                if (++i < this.categories.length) {
                    Category upper = this.categories[i];
                    if (!$assertionsDisabled && upper.minimum <= sample) {
                        throw new AssertionError(sample);
                    }
                    return upper.minimum - sample < sample - category.maximum ? upper : category;
                }
                return this.overflowFallback;
            }
        } else if (this.overflowFallback != null && this.categories.length != 0) {
            Category category = this.categories[0];
            if (!Double.isNaN(category.minimum)) {
                return category;
            }
        }
        return null;
    }

    public final String format(double value, Locale locale) {
        if (Double.isNaN(value)) {
            Category category = this.last;
            if (!(value >= category.minimum && value <= category.maximum || Double.doubleToRawLongBits(value) == Double.doubleToRawLongBits(category.minimum))) {
                category = this.getCategory(value);
                if (category == null) {
                    return Resources.getResources(locale).getString(31);
                }
                this.last = category;
            }
            return category.getName().toString(null);
        }
        return this.format(value, true, locale, new StringBuffer()).toString();
    }

    public final int size() {
        return this.categories.length;
    }

    public final Object get(int i) {
        return this.categories[i];
    }

    public final Object[] toArray() {
        return (Category[])this.categories.clone();
    }

    public final String toString() {
        return this.toString(this);
    }

    final String toString(Object owner) {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(owner));
        buffer = this.formatRange(buffer, null);
        if (this.hasGaps) {
            buffer.append(" with gaps");
        }
        buffer.append(lineSeparator);
        for (int i = 0; i < this.categories.length; ++i) {
            buffer.append("   ");
            buffer.append(this.categories[i] == this.main ? (char)'*' : ' ');
            buffer.append(this.categories[i]);
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof CategoryList) {
            CategoryList that = (CategoryList)object;
            if (Arrays.equals(this.categories, that.categories)) {
                if (!$assertionsDisabled && !Arrays.equals(this.minimums, that.minimums)) {
                    throw new AssertionError();
                }
                return Utilities.equals(this.overflowFallback, that.overflowFallback);
            }
            return false;
        }
        return this.overflowFallback == null && super.equals(object);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.last = this.main;
    }

    private Object readResolve() throws ObjectStreamException {
        return Category.pool.canonicalize(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return Category.pool.canonicalize(this);
    }

    public final int getDimSource() {
        return 1;
    }

    public final int getSourceDimensions() {
        return 1;
    }

    public final int getDimTarget() {
        return 1;
    }

    public final int getTargetDimensions() {
        return 1;
    }

    public boolean isIdentity() {
        return false;
    }

    public final MathTransform inverse() {
        return this.inverse;
    }

    private static void checkDimension(DirectPosition point) {
        int dim = point.getDimension();
        if (dim != 1) {
            throw new MismatchedDimensionException(org.geotools.resources.cts.Resources.format(98, new Integer(1), new Integer(dim)));
        }
    }

    public final DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        CategoryList.checkDimension(ptSrc);
        if (ptDst == null) {
            ptDst = new GeneralDirectPosition(1);
        } else {
            CategoryList.checkDimension(ptDst);
        }
        ptDst.setOrdinate(0, this.transform(ptSrc.getOrdinate(0)));
        return ptDst;
    }

    public final Matrix derivative(DirectPosition point) throws TransformException {
        CategoryList.checkDimension(point);
        return new GeneralMatrix(1, 1, new double[]{this.derivative(point.getOrdinate(0))});
    }

    public final double derivative(double value) throws TransformException {
        Category category = this.last;
        if (!(value >= category.minimum && value <= category.maximum || Double.doubleToRawLongBits(value) == Double.doubleToRawLongBits(category.minimum))) {
            category = this.getCategory(value);
            if (category == null) {
                throw new TransformException(Resources.format(61, new Double(value)));
            }
            this.last = category;
        }
        return category.transform.derivative(value);
    }

    public final double transform(double value) throws TransformException {
        Category category = this.last;
        if (!(value >= category.minimum && value <= category.maximum || Double.doubleToRawLongBits(value) == Double.doubleToRawLongBits(category.minimum))) {
            category = this.getCategory(value);
            if (category == null) {
                throw new TransformException(Resources.format(61, new Double(value)));
            }
            this.last = category;
        }
        value = category.transform.transform(value);
        if (this.overflowFallback != null) {
            if (value < category.inverse.minimum) {
                return category.inverse.minimum;
            }
            if (value > category.inverse.maximum) {
                return category.inverse.maximum;
            }
        }
        if (!$assertionsDisabled && category != this.inverse.getCategory((double)value).inverse) {
            throw new AssertionError(category);
        }
        return value;
    }

    private void transform(double[] srcPts, float[] srcFloat, int srcOff, double[] dstPts, float[] dstFloat, int dstOff, int numPts, boolean doublePrecision) throws TransformException {
        int direction;
        int srcToDst = dstOff - srcOff;
        Category category = this.last;
        double maximum = category.maximum;
        double minimum = category.minimum;
        long rawBits = Double.doubleToRawLongBits(minimum);
        if (srcPts != dstPts || srcOff >= dstOff) {
            direction = 1;
        } else {
            direction = -1;
            dstOff += numPts - 1;
            srcOff += numPts - 1;
        }
        int peekOff = srcOff;
        while (true) {
            double value = 0.0;
            if (doublePrecision) {
                while (--numPts >= 0 && ((value = srcPts[peekOff]) >= minimum && value <= maximum || Double.doubleToRawLongBits(value) == rawBits)) {
                    peekOff += direction;
                }
            } else {
                while (--numPts >= 0 && ((value = (double)srcFloat[peekOff]) >= minimum && value <= maximum || Double.doubleToRawLongBits(value) == rawBits)) {
                    peekOff += direction;
                }
            }
            if (!(this.overflowFallback != null && (value > maximum && category == this.overflowFallback || value < minimum && category == this.categories[0]))) {
                int count = peekOff - srcOff;
                if (count < 0) {
                    count = -count;
                    srcOff -= count - 1;
                }
                if (doublePrecision) {
                    category.transform.transform(srcPts, srcOff, dstPts, srcOff + srcToDst, count);
                    if (this.overflowFallback != null) {
                        dstOff = srcOff + srcToDst;
                        double min = category.inverse.minimum;
                        double max = category.inverse.maximum;
                        while (--count >= 0) {
                            double check = dstPts[dstOff];
                            if (check < min) {
                                dstPts[dstOff] = min;
                            } else if (check > max) {
                                dstPts[dstOff] = max;
                            }
                            ++dstOff;
                        }
                    }
                } else {
                    category.transform.transform(srcFloat, srcOff, dstFloat, srcOff + srcToDst, count);
                    if (this.overflowFallback != null) {
                        dstOff = srcOff + srcToDst;
                        float min = (float)category.inverse.minimum;
                        float max = (float)category.inverse.maximum;
                        while (--count >= 0) {
                            float check = dstFloat[dstOff];
                            if (check < min) {
                                dstFloat[dstOff] = min;
                            } else if (check > max) {
                                dstFloat[dstOff] = max;
                            }
                            ++dstOff;
                        }
                    }
                }
                if (numPts < 0) break;
                category = this.getCategory(value);
                if (category == null) {
                    throw new TransformException(Resources.format(61, new Double(value)));
                }
                maximum = category.maximum;
                minimum = category.minimum;
                rawBits = Double.doubleToRawLongBits(minimum);
                srcOff = peekOff;
            }
            peekOff += direction;
        }
        this.last = category;
    }

    public final void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.transform(srcPts, null, srcOff, dstPts, null, dstOff, numPts, true);
    }

    public final void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        this.transform(null, srcPts, srcOff, null, dstPts, dstOff, numPts, false);
    }

    public final void transform(WritableRectIter iterator) throws RasterFormatException {
        double minTr;
        double maxTr;
        Category categoryMin = null;
        Category categoryMax = null;
        int i = this.categories.length;
        while (--i >= 0) {
            if (Double.isNaN(this.categories[i].maximum)) continue;
            categoryMax = this.categories[i];
            categoryMin = this.categories[0];
            break;
        }
        Category category = this.main;
        if (this.main == null) {
            category = this.nodata;
        }
        double maximum = category.maximum;
        double minimum = category.minimum;
        long rawBits = Double.doubleToRawLongBits(minimum);
        MathTransform1D tr = category.transform;
        if (this.overflowFallback == null) {
            maxTr = Double.POSITIVE_INFINITY;
            minTr = Double.NEGATIVE_INFINITY;
        } else {
            maxTr = category.inverse.maximum;
            minTr = category.inverse.minimum;
        }
        try {
            iterator.startLines();
            if (!iterator.finishedLines()) {
                do {
                    iterator.startPixels();
                    if (iterator.finishedPixels()) continue;
                    do {
                        double value;
                        if (!((value = iterator.getSampleDouble()) >= minimum && value <= maximum || Double.doubleToRawLongBits(value) == rawBits)) {
                            category = this.getCategory(value);
                            if (category == null) {
                                category = this.nodata;
                            }
                            maximum = category != categoryMax ? category.maximum : Double.POSITIVE_INFINITY;
                            minimum = category != categoryMin ? category.minimum : Double.NEGATIVE_INFINITY;
                            rawBits = Double.doubleToRawLongBits(minimum);
                            tr = category.transform;
                            if (this.overflowFallback != null) {
                                maxTr = category.inverse.maximum;
                                minTr = category.inverse.minimum;
                            }
                        }
                        if (!($assertionsDisabled || this.hasGaps || category == this.nodata || (!Double.isNaN(value) ? value >= minimum && value <= maximum : Double.doubleToRawLongBits(value) == rawBits))) {
                            throw new AssertionError(value);
                        }
                        if ((value = tr.transform(value)) > maxTr) {
                            value = maxTr;
                        } else if (value < minTr) {
                            value = minTr;
                        }
                        iterator.setSample(value);
                    } while (!iterator.nextPixelDone());
                } while (!iterator.nextLineDone());
            }
        }
        catch (TransformException cause) {
            RasterFormatException exception = new RasterFormatException(Resources.format(44, Utilities.getShortClassName(tr)));
            exception.initCause(cause);
            throw exception;
        }
    }

    public String toWKT() throws UnsupportedOperationException {
        throw new UnformattableObjectException("Not yet implemented.");
    }

    static {
        $assertionsDisabled = !CategoryList.class.desiredAssertionStatus();
    }

    private final class Name
    extends AbstractInternationalString {
        private Name() {
        }

        public String toString(Locale locale) {
            StringBuffer buffer = new StringBuffer(30);
            if (CategoryList.this.main != null) {
                buffer.append(CategoryList.this.main.getName().toString(locale));
            } else {
                buffer.append('(');
                buffer.append(Resources.getResources(locale).getString(31));
                buffer.append(')');
            }
            buffer.append(' ');
            return String.valueOf(CategoryList.this.geophysics(true).formatRange(buffer, locale));
        }

        public String toString() {
            return this.toString(Locale.getDefault());
        }
    }
}

