/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.media.jai.JAI;
import javax.units.Unit;
import org.geotools.coverage.Category;
import org.geotools.coverage.CategoryList;
import org.geotools.coverage.SampleTranscoder;
import org.geotools.coverage.TypeMap;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.resources.ClassChanger;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;
import org.geotools.resources.XMath;
import org.geotools.resources.gcs.Resources;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.util.NumberRange;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.MetadataNameNotFoundException;
import org.opengis.coverage.PaletteInterpretation;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

public class GridSampleDimension
implements SampleDimension,
Serializable {
    private static final long serialVersionUID = 6026936545776852758L;
    private static final String[] EMPTY_METADATA = new String[0];
    private GridSampleDimension inverse;
    final CategoryList categories;
    private final boolean isGeophysics;
    private final boolean hasQualitative;
    private final boolean hasQuantitative;
    private final MathTransform1D sampleToGeophysics;

    public GridSampleDimension() {
        this((CategoryList)null);
    }

    public GridSampleDimension(CharSequence[] names) {
        this(GridSampleDimension.list(names));
    }

    private static CategoryList list(CharSequence[] names) {
        Color[] colors = new Color[names.length];
        double scale = 255.0 / (double)colors.length;
        for (int i = 0; i < colors.length; ++i) {
            int r = (int)Math.round(scale * (double)i);
            colors[i] = new Color(r, r, r);
        }
        return GridSampleDimension.list(names, colors);
    }

    public GridSampleDimension(CharSequence[] names, Color[] colors) {
        this(GridSampleDimension.list(names, colors));
    }

    private static CategoryList list(CharSequence[] names, Color[] colors) {
        if (names.length != colors.length) {
            throw new IllegalArgumentException(Resources.format(54));
        }
        Category[] categories = new Category[names.length];
        for (int i = 0; i < categories.length; ++i) {
            categories[i] = new Category(names[i], colors[i], i);
        }
        return GridSampleDimension.list(categories, null);
    }

    public GridSampleDimension(CharSequence description, SampleDimensionType type, ColorInterpretation color, Color[] palette, CharSequence[] categories, double[] nodata, double minimum, double maximum, double scale, double offset, Unit unit) {
        this(GridSampleDimension.list(description, type, color, palette, categories, nodata, minimum, maximum, scale, offset, unit));
    }

    private static CategoryList list(CharSequence description, SampleDimensionType type, ColorInterpretation color, Color[] palette, CharSequence[] categories, double[] nodata, double minimum, double maximum, double scale, double offset, Unit unit) {
        Color[] colors;
        NumberRange range;
        if (Double.isInfinite(minimum) || Double.isInfinite(maximum) || !(minimum < maximum)) {
            throw new IllegalArgumentException(Resources.format(43, new Double(minimum), new Double(maximum)));
        }
        if (Double.isNaN(scale) || Double.isInfinite(scale) || scale == 0.0) {
            throw new IllegalArgumentException(Resources.format(41, "scale", new Double(scale)));
        }
        if (Double.isNaN(offset) || Double.isInfinite(offset)) {
            throw new IllegalArgumentException(Resources.format(41, "offset", new Double(offset)));
        }
        if (type == null) {
            type = TypeMap.getSampleDimensionType(minimum, maximum);
        }
        if (color == null) {
            color = ColorInterpretation.PALETTE_INDEX;
        }
        int nameCount = categories != null ? categories.length : 0;
        int nodataCount = nodata != null ? nodata.length : 0;
        ArrayList<Category> categoryList = new ArrayList<Category>(nameCount + nodataCount + 2);
        for (int i = 0; i < nodataCount; ++i) {
            CharSequence name = null;
            double padValue = nodata[i];
            int intValue = (int)Math.floor(padValue);
            if (intValue >= 0 && intValue < nameCount) {
                if ((double)intValue == padValue) continue;
                name = categories[intValue];
            }
            Number value = TypeMap.wrapSample(padValue, type, false);
            if (name == null) {
                name = value.toString();
            }
            range = new NumberRange(value.getClass(), value, value);
            colors = ColorUtilities.subarray(palette, intValue, intValue + 1);
            categoryList.add(new Category(name, colors, range, (MathTransform1D)null));
        }
        if (nameCount != 0) {
            int lower = 0;
            for (int upper = 1; upper <= categories.length; ++upper) {
                Class<?> classe;
                Number max;
                if (upper != categories.length && ((Object)categories[lower]).toString().trim().equalsIgnoreCase(((Object)categories[upper]).toString().trim())) continue;
                CharSequence name = categories[lower];
                Number min = TypeMap.wrapSample(lower, type, false);
                if (min.equals(max = TypeMap.wrapSample(upper - 1, type, false))) {
                    min = max;
                    classe = max.getClass();
                } else {
                    classe = ClassChanger.getWidestClass(min, max);
                    min = ClassChanger.cast(min, classe);
                    max = ClassChanger.cast(max, classe);
                }
                range = new NumberRange(classe, min, max);
                colors = ColorUtilities.subarray(palette, lower, upper);
                categoryList.add(new Category(name, colors, range, (MathTransform1D)null));
                lower = upper;
            }
        }
        boolean needQuantitative = false;
        if (scale != 1.0 || offset != 0.0 || nodataCount != 0 || categoryList.size() <= 1) {
            needQuantitative = true;
            int i = categoryList.size();
            while (--i >= 0) {
                double xmax;
                double xmin;
                Comparable max;
                NumberRange range2;
                Comparable min;
                Category category = (Category)categoryList.get(i);
                if (category.isQuantitative() || (min = (range2 = category.getRange()).getMinValue()).compareTo(max = range2.getMaxValue()) == 0 || GridSampleDimension.rangeContains(xmin = ((Number)((Object)min)).doubleValue(), xmax = ((Number)((Object)max)).doubleValue(), nodata)) continue;
                InternationalString name = category.getName();
                Color[] colors2 = category.getColors();
                category = new Category((CharSequence)name, colors2, range2, scale, offset);
                categoryList.set(i, category);
                needQuantitative = false;
            }
        }
        if (needQuantitative) {
            boolean minIncluded = true;
            boolean maxIncluded = true;
            int i = categoryList.size();
            while (--i >= 0) {
                NumberRange range3 = ((Category)categoryList.get(i)).getRange();
                double min = range3.getMinimum();
                double max = range3.getMaximum();
                if (max - minimum < maximum - min) {
                    if (!(max >= minimum)) continue;
                    minimum = max;
                    minIncluded = !range3.isMaxIncluded();
                    continue;
                }
                if (!(min <= maximum)) continue;
                maximum = min;
                maxIncluded = !range3.isMinIncluded();
            }
            boolean bl = !minIncluded || !maxIncluded;
            if (maximum - minimum > (double)bl) {
                Number min = TypeMap.wrapSample(minimum, type, false);
                Number max = TypeMap.wrapSample(maximum, type, false);
                Class classe = ClassChanger.getWidestClass(min, max);
                min = ClassChanger.cast(min, classe);
                max = ClassChanger.cast(max, classe);
                NumberRange range4 = new NumberRange(classe, min, minIncluded, max, maxIncluded);
                Color[] colors3 = ColorUtilities.subarray(palette, (int)Math.ceil(minimum), (int)Math.floor(maximum));
                categoryList.add(new Category(description != null ? description : "(automatic)", colors3, range4, scale, offset));
                needQuantitative = false;
            }
        }
        Category[] cl = categoryList.toArray(new Category[categoryList.size()]);
        if (ColorInterpretation.PALETTE_INDEX.equals(color) || ColorInterpretation.GRAY_INDEX.equals(color)) {
            return GridSampleDimension.list(cl, unit);
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public GridSampleDimension(Category[] categories, Unit units) throws IllegalArgumentException {
        this(GridSampleDimension.list(categories, units));
    }

    private static CategoryList list(Category[] categories, Unit units) {
        if (categories == null) {
            return null;
        }
        CategoryList list = new CategoryList(categories, units);
        list = (CategoryList)Category.pool.canonicalize(list);
        if (CategoryList.isScaled(categories, false)) {
            return list;
        }
        if (CategoryList.isScaled(categories, true)) {
            return list.inverse;
        }
        throw new IllegalArgumentException(Resources.format(56));
    }

    private GridSampleDimension(CategoryList list) {
        MathTransform1D main = null;
        boolean isMainValid = true;
        boolean qualitative = false;
        if (list != null) {
            int i = list.size();
            while (--i >= 0) {
                MathTransform1D candidate = ((Category)list.get(i)).getSampleToGeophysics();
                if (candidate == null) {
                    qualitative = true;
                    continue;
                }
                if (main != null) {
                    isMainValid &= main.equals(candidate);
                }
                main = candidate;
            }
            this.isGeophysics = list.isScaled(true);
        } else {
            this.isGeophysics = false;
        }
        this.categories = list;
        this.hasQualitative = qualitative;
        this.hasQuantitative = main != null;
        this.sampleToGeophysics = isMainValid ? main : null;
    }

    protected GridSampleDimension(GridSampleDimension other) {
        if (other != null) {
            this.inverse = other.inverse;
            this.categories = other.categories;
            this.isGeophysics = other.isGeophysics;
            this.hasQualitative = other.hasQualitative;
            this.hasQuantitative = other.hasQuantitative;
            this.sampleToGeophysics = other.sampleToGeophysics;
        } else {
            this.categories = null;
            this.isGeophysics = false;
            this.hasQualitative = false;
            this.hasQuantitative = false;
            this.sampleToGeophysics = null;
        }
    }

    public static GridSampleDimension wrap(SampleDimension sd) {
        Color[] colors;
        if (sd instanceof GridSampleDimension) {
            return (GridSampleDimension)sd;
        }
        int[][] palette = sd.getPalette();
        if (palette != null) {
            colors = new Color[palette.length];
            for (int i = 0; i < colors.length; ++i) {
                int[] color = palette[i];
                colors[i] = new Color(color[0], color[1], color[2]);
            }
        } else {
            colors = null;
        }
        return new GridSampleDimension((CharSequence)sd.getDescription(), sd.getSampleDimensionType(), sd.getColorInterpretation(), colors, (CharSequence[])sd.getCategoryNames(), sd.getNoDataValues(), sd.getMinimumValue(), sd.getMaximumValue(), sd.getScale(), sd.getOffset(), sd.getUnits());
    }

    public SampleDimensionType getSampleDimensionType() {
        NumberRange range = this.getRange();
        if (range == null) {
            return SampleDimensionType.REAL_32BITS;
        }
        return TypeMap.getSampleDimensionType(range);
    }

    public InternationalString getDescription() {
        return this.categories != null ? this.categories.getName() : null;
    }

    public String getDescription(Locale locale) {
        return this.categories != null ? this.categories.getName().toString(locale) : null;
    }

    public InternationalString[] getCategoryNames() throws IllegalStateException {
        if (this.categories == null) {
            return null;
        }
        if (this.categories.isEmpty()) {
            return new InternationalString[0];
        }
        Object[] names = null;
        int i = this.categories.size();
        while (--i >= 0) {
            Category category = (Category)this.categories.get(i);
            int lower = (int)category.minimum;
            int upper = (int)category.maximum;
            if ((double)lower != category.minimum || lower < 0 || (double)upper != category.maximum || upper < 0) {
                throw new IllegalStateException(Resources.format(58));
            }
            if (names == null) {
                names = new InternationalString[upper + 1];
            }
            Arrays.fill(names, lower, upper + 1, category.getName());
        }
        return names;
    }

    public final String[] getCategoryNames(Locale locale) throws IllegalStateException {
        InternationalString[] inter = this.getCategoryNames();
        String[] names = new String[inter.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = inter[i].toString(locale);
        }
        return names;
    }

    public List getCategories() {
        return this.categories;
    }

    public Category getCategory(double sample) {
        return this.categories != null ? this.categories.getCategory(sample) : null;
    }

    public Category getBackground() {
        return this.categories != null ? this.categories.nodata : Category.NODATA;
    }

    public double[] getNoDataValues() throws IllegalStateException {
        if (!this.hasQuantitative) {
            return null;
        }
        int count = 0;
        double[] padValues = null;
        int size = this.categories.size();
        for (int i = 0; i < size; ++i) {
            Category category = (Category)this.categories.get(i);
            if (category.isQuantitative()) continue;
            double min = category.minimum;
            double max = category.maximum;
            if (Double.isNaN(min) && Double.isNaN(max)) continue;
            if (padValues == null) {
                padValues = new double[size - i];
            }
            if (count >= padValues.length) {
                padValues = XArray.resize(padValues, count * 2);
            }
            padValues[count++] = min;
            if (max == min) continue;
            int lower = (int)min;
            int upper = (int)max;
            if ((double)lower != min || (double)upper != max || !XMath.isInteger(category.getRange().getElementClass())) {
                throw new IllegalStateException(Resources.format(58));
            }
            int requiredLength = count + (upper - lower);
            if (requiredLength > padValues.length) {
                padValues = XArray.resize(padValues, requiredLength * 2);
            }
            while (++lower <= upper) {
                padValues[count++] = lower;
            }
        }
        if (padValues != null) {
            padValues = XArray.resize(padValues, count);
        }
        return padValues;
    }

    public double getMinimumValue() {
        double value;
        if (this.categories != null && !this.categories.isEmpty() && !Double.isNaN(value = ((Category)this.categories.get((int)0)).minimum)) {
            return value;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getMaximumValue() {
        if (this.categories != null) {
            int i = this.categories.size();
            while (--i >= 0) {
                double value = ((Category)this.categories.get((int)i)).maximum;
                if (Double.isNaN(value)) continue;
                return value;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public NumberRange getRange() {
        return this.categories != null ? this.categories.getRange() : null;
    }

    private static boolean rangeContains(double lower, double upper, double[] values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                double v = values[i];
                if (!(v >= lower) || !(v < upper)) continue;
                return true;
            }
        }
        return false;
    }

    public String getLabel(double value, Locale locale) {
        if (this.categories != null) {
            if (this.isGeophysics) {
                return this.categories.format(value, locale);
            }
            try {
                return this.categories.inverse.format(this.categories.transform(value), locale);
            }
            catch (TransformException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Unit getUnits() {
        return this.categories != null ? this.categories.geophysics(true).getUnits() : null;
    }

    public double getOffset() throws IllegalStateException {
        return this.getCoefficient(0);
    }

    public double getScale() {
        return this.getCoefficient(1);
    }

    private double getCoefficient(int order) throws IllegalStateException {
        if (!this.hasQuantitative) {
            return order;
        }
        TransformException cause = null;
        if (this.sampleToGeophysics != null) {
            try {
                double value;
                switch (order) {
                    case 0: {
                        value = this.sampleToGeophysics.transform(0.0);
                        break;
                    }
                    case 1: {
                        value = this.sampleToGeophysics.derivative(Double.NaN);
                        break;
                    }
                    default: {
                        throw new AssertionError(order);
                    }
                }
                if (!Double.isNaN(value)) {
                    return value;
                }
            }
            catch (TransformException exception) {
                cause = exception;
            }
        }
        IllegalStateException exception = new IllegalStateException(Resources.format(59));
        exception.initCause(cause);
        throw exception;
    }

    public MathTransform1D getSampleToGeophysics() {
        if (this.isGeophysics) {
            return LinearTransform1D.IDENTITY;
        }
        if (!this.hasQualitative && this.sampleToGeophysics != null) {
            return this.sampleToGeophysics;
        }
        return this.categories;
    }

    public GridSampleDimension geophysics(boolean geo) {
        if (geo == this.isGeophysics) {
            return this;
        }
        if (this.inverse == null) {
            if (this.categories != null) {
                this.inverse = new GridSampleDimension(this.categories.inverse);
                this.inverse.inverse = this;
            } else {
                this.inverse = this;
            }
        }
        return this.inverse;
    }

    public int[][] getPalette() {
        ColorModel color = this.getColorModel();
        if (color instanceof IndexColorModel) {
            IndexColorModel cm = (IndexColorModel)color;
            int[][] colors = new int[cm.getMapSize()][];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = new int[]{cm.getRed(i), cm.getGreen(i), cm.getBlue(i)};
            }
            return colors;
        }
        return null;
    }

    public PaletteInterpretation getPaletteInterpretation() {
        return PaletteInterpretation.RGB;
    }

    public ColorInterpretation getColorInterpretation() {
        boolean band = false;
        boolean numBands = true;
        return TypeMap.getColorInterpretation(this.getColorModel(0, 1), 0);
    }

    public ColorModel getColorModel() {
        boolean band = false;
        boolean numBands = true;
        return this.getColorModel(0, 1);
    }

    public ColorModel getColorModel(int visibleBand, int numBands) {
        if (this.categories != null) {
            return this.categories.getColorModel(visibleBand, numBands);
        }
        return null;
    }

    public ColorModel getColorModel(int visibleBand, int numBands, int type) {
        if (this.categories != null) {
            return this.categories.getColorModel(visibleBand, numBands, type);
        }
        return null;
    }

    public GridSampleDimension rescale(double scale, double offset) {
        MathTransform1D sampleToGeophysics = Category.createLinearTransform(scale, offset);
        Object[] categories = (Category[])this.getCategories().toArray();
        Object[] reference = (Category[])categories.clone();
        for (int i = 0; i < categories.length; ++i) {
            if (categories[i].isQuantitative()) {
                categories[i] = ((Category)categories[i]).rescale(sampleToGeophysics);
            }
            categories[i] = ((Category)categories[i]).geophysics(this.isGeophysics);
        }
        if (Arrays.equals(categories, reference)) {
            return this;
        }
        return new GridSampleDimension((Category[])categories, this.getUnits());
    }

    public String[] getMetaDataNames() {
        return EMPTY_METADATA;
    }

    public String getMetadataValue(String name) throws MetadataNameNotFoundException {
        throw new MetadataNameNotFoundException();
    }

    public int hashCode() {
        return this.categories != null ? this.categories.hashCode() : 23491;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GridSampleDimension) {
            GridSampleDimension that = (GridSampleDimension)object;
            return Utilities.equals(this.categories, that.categories);
        }
        return false;
    }

    public String toString() {
        if (this.categories != null) {
            return this.categories.toString(this);
        }
        return Utilities.getShortClassName(this);
    }

    static {
        SampleTranscoder.register(JAI.getDefaultInstance());
    }
}

