/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.referencing.operation.transform.DimensionFilter;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.gcs.Resources;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.grid.GridRange;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;

public class GridGeometry2D
extends GeneralGridGeometry {
    private static final long serialVersionUID = -1703923198093773095L;
    public final int gridDimensionX;
    public final int gridDimensionY;
    public final int axisDimensionX;
    public final int axisDimensionY;
    private final MathTransform2D gridToCoordinateSystem2D;
    private final MathTransform2D gridFromCoordinateSystem2D;

    public GridGeometry2D(GridRange gridRange, MathTransform gridToCoordinateSystem) throws IllegalArgumentException {
        super(gridRange, gridToCoordinateSystem);
        int[] dimensions = new int[4];
        this.gridToCoordinateSystem2D = GridGeometry2D.getMathTransform2D(gridToCoordinateSystem, gridRange, dimensions);
        this.gridFromCoordinateSystem2D = GridGeometry2D.inverse(this.gridToCoordinateSystem2D);
        this.gridDimensionX = dimensions[0];
        this.gridDimensionY = dimensions[1];
        this.axisDimensionX = dimensions[2];
        this.axisDimensionY = dimensions[3];
    }

    public GridGeometry2D(GridRange gridRange, Envelope userRange, boolean[] reverse) throws IllegalArgumentException {
        super(gridRange, userRange, reverse);
        int[] dimensions = new int[4];
        this.gridToCoordinateSystem2D = GridGeometry2D.getMathTransform2D(this.gridToCoordinateSystem, gridRange, dimensions);
        this.gridFromCoordinateSystem2D = GridGeometry2D.inverse(this.gridToCoordinateSystem2D);
        this.gridDimensionX = dimensions[0];
        this.gridDimensionY = dimensions[1];
        this.axisDimensionX = dimensions[2];
        this.axisDimensionY = dimensions[3];
    }

    public GridGeometry2D(Rectangle gridRange, Rectangle2D userRange) {
        this(new GeneralGridRange(gridRange), GridGeometry2D.getMathTransform(gridRange, userRange));
    }

    private static MathTransform getMathTransform(Rectangle gridRange, Rectangle2D userRange) {
        double scaleX = userRange.getWidth() / gridRange.getWidth();
        double scaleY = userRange.getHeight() / gridRange.getHeight();
        double transX = userRange.getMinX() - (double)gridRange.x * scaleX;
        double transY = userRange.getMaxY() + (double)gridRange.y * scaleY;
        AffineTransform tr = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, transX, transY);
        tr.translate(0.5, 0.5);
        return ProjectiveTransform.create(tr);
    }

    private static MathTransform2D getMathTransform2D(MathTransform transform, GridRange gridRange, int[] axis) throws IllegalArgumentException {
        axis[3] = 1;
        axis[1] = 1;
        if (transform == null || transform instanceof MathTransform2D) {
            return (MathTransform2D)transform;
        }
        DimensionFilter filter = new DimensionFilter();
        if (gridRange != null) {
            int dimension = gridRange.getDimension();
            for (int i = 0; i < dimension; ++i) {
                if (gridRange.getLength(i) <= 1) continue;
                filter.addSourceDimension(i);
            }
        } else {
            filter.addSourceDimensionRange(0, 2);
        }
        Throwable cause = null;
        int[] dimensions = filter.getSourceDimensions();
        if (dimensions.length == 2) {
            System.arraycopy(dimensions, 0, axis, 0, 2);
            try {
                MathTransform candidate = filter.separate(transform);
                if (candidate.getTargetDimensions() != 2) {
                    filter.clear();
                    filter.addSourceDimensions(dimensions);
                    filter.addTargetDimensions(dimensions);
                    candidate = filter.separate(transform);
                }
                dimensions = filter.getTargetDimensions();
                System.arraycopy(dimensions, 0, axis, 2, 2);
                try {
                    return (MathTransform2D)candidate;
                }
                catch (ClassCastException exception) {
                    cause = exception;
                }
            }
            catch (FactoryException exception) {
                cause = exception;
            }
        }
        IllegalArgumentException e = new IllegalArgumentException(Resources.format(64));
        e.initCause(cause);
        throw e;
    }

    private static MathTransform2D inverse(MathTransform2D gridToCoordinateSystem2D) throws IllegalArgumentException {
        if (gridToCoordinateSystem2D == null) {
            return null;
        }
        try {
            return (MathTransform2D)gridToCoordinateSystem2D.inverse();
        }
        catch (NoninvertibleTransformException exception) {
            IllegalArgumentException e = new IllegalArgumentException(Resources.format(44, Utilities.getShortClassName(gridToCoordinateSystem2D)));
            e.initCause(exception);
            throw e;
        }
    }

    public Rectangle getGridRange2D() {
        return new Rectangle(this.gridRange.getLower(this.gridDimensionX), this.gridRange.getLower(this.gridDimensionY), this.gridRange.getLength(this.gridDimensionX), this.gridRange.getLength(this.gridDimensionY));
    }

    public MathTransform2D getGridToCoordinateSystem2D() throws InvalidGridGeometryException {
        if (this.gridToCoordinateSystem2D != null) {
            return this.gridToCoordinateSystem2D;
        }
        throw new InvalidGridGeometryException(Resources.format(64));
    }

    final Point2D inverseTransform(Point2D point) throws InvalidGridGeometryException {
        if (this.gridFromCoordinateSystem2D != null) {
            try {
                return this.gridFromCoordinateSystem2D.transform(point, null);
            }
            catch (TransformException exception) {
                throw new CannotEvaluateException(Resources.format(45, AbstractGridCoverage.toString(point, Locale.getDefault()), (Object)exception));
            }
        }
        throw new InvalidGridGeometryException(Resources.format(64));
    }

    final Rectangle inverseTransform(Rectangle2D bounds) {
        if (bounds != null && this.gridFromCoordinateSystem2D != null) {
            try {
                bounds = CRSUtilities.transform(this.gridFromCoordinateSystem2D, bounds, null);
                int xmin = (int)Math.floor(bounds.getMinX() - 0.5);
                int ymin = (int)Math.floor(bounds.getMinY() - 0.5);
                int xmax = (int)Math.ceil(bounds.getMaxX() - 0.5);
                int ymax = (int)Math.ceil(bounds.getMaxY() - 0.5);
                return new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            GridGeometry2D that = (GridGeometry2D)object;
            return this.gridDimensionX == that.gridDimensionX && this.gridDimensionY == that.gridDimensionY && this.axisDimensionX == that.axisDimensionX && this.axisDimensionY == that.axisDimensionY;
        }
        return false;
    }
}

