/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.Color;
import java.io.Writer;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.Interpolation;
import javax.media.jai.KernelJAI;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.parameter.ParameterWriter;
import org.geotools.resources.image.ImageUtilities;

final class CoverageParameterWriter
extends ParameterWriter {
    public CoverageParameterWriter(Writer out) {
        super(out);
    }

    protected String formatValue(Object value) {
        if (KernelJAI.GRADIENT_MASK_SOBEL_HORIZONTAL.equals(value)) {
            return "GRADIENT_MASK_SOBEL_HORIZONTAL";
        }
        if (KernelJAI.GRADIENT_MASK_SOBEL_VERTICAL.equals(value)) {
            return "GRADIENT_MASK_SOBEL_VERTICAL";
        }
        if (value instanceof AbstractCoverage) {
            return ((AbstractCoverage)((Object)value)).getName().toString(this.getLocale());
        }
        if (value instanceof Interpolation) {
            return ImageUtilities.getInterpolationName((Interpolation)value);
        }
        if (value instanceof EnumeratedParameter) {
            return ((EnumeratedParameter)value).getName();
        }
        if (value instanceof Color) {
            Color c = (Color)value;
            return "RGB[" + c.getRed() + ',' + c.getGreen() + ',' + c.getBlue() + ']';
        }
        return super.formatValue(value);
    }
}

