/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.TypeEntry;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.geometry.JTS;
import org.geotools.util.SimpleInternationalString;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class DefaultTypeEntry
implements TypeEntry {
    private final DataStore store;
    private final URI namespace;
    private final String typeName;
    private Map metadata;
    private InternationalString displayName;
    private InternationalString description;
    FeatureSource source;
    int count;
    Envelope bounds;

    public DefaultTypeEntry(DataStore store, URI namespace, String typeName) {
        this.store = store;
        this.namespace = namespace;
        this.typeName = typeName;
        this.displayName = new SimpleInternationalString(typeName.substring(0, 1).toUpperCase() + typeName.substring(1).toLowerCase());
        this.description = new SimpleInternationalString("Feature type " + typeName);
        try {
            this.source = store.getFeatureSource(typeName);
            this.source.addFeatureListener(new FeatureListener(){

                public void changed(FeatureEvent featureEvent) {
                    DefaultTypeEntry.this.reset();
                }
            });
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public Object resource() {
        try {
            return this.getFeatureSource();
        }
        catch (IOException e) {
            return null;
        }
    }

    public FeatureSource getFeatureSource() throws IOException {
        return this.store.getFeatureSource(this.typeName);
    }

    public FeatureType getFeatureType() throws IOException {
        return this.store.getSchema(this.typeName);
    }

    public synchronized Map metadata() {
        if (this.metadata == null) {
            this.metadata = this.createMetadata();
        }
        return Collections.unmodifiableMap(this.metadata);
    }

    protected Map createMetadata() {
        return Collections.EMPTY_MAP;
    }

    public String[] getMetadataNames() {
        return this.metadata.keySet().toArray(new String[this.metadata().size()]);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultTypeEntry)) {
            return false;
        }
        DefaultTypeEntry entry = (DefaultTypeEntry)obj;
        return this.typeName.equals(entry.typeName) && this.namespace.equals(entry.namespace) && this.store == entry.store;
    }

    public int hashCode() {
        return this.typeName.hashCode() ^ this.namespace.hashCode() << 3 ^ this.store.hashCode() << 6;
    }

    public synchronized void reset() {
        this.count = -1;
        this.bounds = null;
    }

    public InternationalString getDisplayName() {
        return this.displayName;
    }

    public String getDataName() {
        return this.namespace + ":" + this.typeName;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public URI getNamespace() {
        return this.namespace;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public synchronized Envelope getBounds() {
        if (this.bounds == null) {
            this.bounds = this.createBounds();
        }
        return this.bounds;
    }

    protected Envelope createBounds() {
        Envelope bbox;
        try {
            bbox = this.source.getBounds();
            if (bbox == null) {
                bbox = this.source.getFeatures().getBounds();
            }
            try {
                CoordinateReferenceSystem cs = this.source.getSchema().getDefaultGeometry().getCoordinateSystem();
                bbox = JTS.toGeographic(bbox, cs);
            }
            catch (Throwable badRepoject) {
                badRepoject.printStackTrace();
            }
        }
        catch (Exception e) {
            bbox = new Envelope();
        }
        return bbox;
    }

    public synchronized int getCount() {
        if (this.count != -1) {
            return this.count;
        }
        try {
            this.count = this.source.getCount(Query.ALL);
            if (this.count == -1) {
                this.count = this.source.getFeatures().getCount();
            }
        }
        catch (IOException e) {
            this.bounds = new Envelope();
        }
        return this.count;
    }

    public void fireAdded(Feature newFeature, Transaction transaction) {
    }

    public void fireChanged(Feature before, Feature after, Transaction transaction) {
    }

    public void fireRemoved(Feature removedFeature, Transaction transaction) {
    }
}

