/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.LockingManager;
import org.geotools.data.Repository;
import org.geotools.data.Transaction;
import org.geotools.feature.FeatureType;

public class FeatureSourceRepository
implements Repository {
    protected SortedMap featuresources = new TreeMap();

    public SortedMap getFeatureSources() {
        return Collections.unmodifiableSortedMap(this.featuresources);
    }

    public Set getPrefixes() throws IOException {
        HashSet<String> prefix = new HashSet<String>();
        Iterator i = this.featuresources.values().iterator();
        while (i.hasNext()) {
            FeatureSource fs = (FeatureSource)i.next();
            FeatureType schema = fs.getSchema();
            prefix.add(schema.getNamespace().toString());
        }
        return prefix;
    }

    private SortedSet typeNames() throws IOException {
        TreeSet<String> typeNames = new TreeSet<String>();
        Iterator i = this.featuresources.values().iterator();
        while (i.hasNext()) {
            FeatureSource fs = (FeatureSource)i.next();
            FeatureType schema = fs.getSchema();
            typeNames.add(schema.getTypeName());
        }
        return typeNames;
    }

    private Map dataStores() {
        TreeMap<String, DataStore> dataStores = new TreeMap<String, DataStore>();
        Iterator i = this.featuresources.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            String dataStoreId = key.split(":")[0];
            FeatureSource fs = (FeatureSource)entry.getValue();
            dataStores.put(dataStoreId, fs.getDataStore());
        }
        return dataStores;
    }

    private SortedMap types(DataStore ds) throws IOException {
        TreeMap<String, FeatureType> map = new TreeMap<String, FeatureType>();
        String[] typeNames = ds.getTypeNames();
        for (int i = 0; i < typeNames.length; ++i) {
            try {
                map.put(typeNames[i], ds.getSchema(typeNames[i]));
                continue;
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return map;
    }

    public SortedMap types() {
        return new TreeMap(this.featuresources);
    }

    public boolean lockExists(String lockID) {
        if (lockID == null) {
            return false;
        }
        Iterator i = this.dataStores().values().iterator();
        while (i.hasNext()) {
            DataStore store = (DataStore)i.next();
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.exists(lockID)) continue;
            return true;
        }
        return false;
    }

    public boolean lockRefresh(String lockID, Transaction transaction) throws IOException {
        if (lockID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + lockID + ")");
        }
        boolean refresh = false;
        Iterator i = this.dataStores().values().iterator();
        while (i.hasNext()) {
            DataStore store = (DataStore)i.next();
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.release(lockID, transaction)) continue;
            refresh = true;
        }
        return refresh;
    }

    public boolean lockRelease(String lockID, Transaction transaction) throws IOException {
        if (lockID == null) {
            throw new IllegalArgumentException("lockID required");
        }
        if (transaction == null || transaction == Transaction.AUTO_COMMIT) {
            throw new IllegalArgumentException("Tansaction required (with authorization for " + lockID + ")");
        }
        boolean release = false;
        Iterator i = this.dataStores().values().iterator();
        while (i.hasNext()) {
            DataStore store = (DataStore)i.next();
            LockingManager lockManager = store.getLockingManager();
            if (lockManager == null || !lockManager.release(lockID, transaction)) continue;
            release = true;
        }
        return release;
    }

    public void register(String id, FeatureSource featureSource) throws IOException {
        this.featuresources.put(id + ":" + featureSource.getSchema().getTypeName(), featureSource);
    }

    public DataStore datastore(String id) {
        HashSet prefix = new HashSet();
        Iterator i = this.featuresources.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            String dataStoreId = key.split(":")[0];
            if (!id.equals(dataStoreId)) continue;
            FeatureSource fs = (FeatureSource)entry.getValue();
            return fs.getDataStore();
        }
        return null;
    }

    public Map getDataStores() {
        return Collections.unmodifiableMap(this.dataStores());
    }

    public FeatureSource source(String dataStoreId, String typeName) throws IOException {
        String typeRef = dataStoreId + ":" + typeName;
        return (FeatureSource)this.featuresources.get(typeRef);
    }
}

