/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ForceCoordinateSystemFeatureResults
extends DataFeatureCollection {
    FeatureResults results;
    FeatureType schema;

    public ForceCoordinateSystemFeatureResults(FeatureResults results, CoordinateReferenceSystem forcedCS) throws IOException, SchemaException {
        if (forcedCS == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        FeatureType type = results.getSchema();
        CoordinateReferenceSystem originalCs = type.getDefaultGeometry().getCoordinateSystem();
        if (forcedCS.equals(originalCs)) {
            throw new IllegalArgumentException("CoordinateSystem " + forcedCS + " already used (check before using wrapper)");
        }
        this.schema = FeatureTypes.transform(type, forcedCS);
        this.results = results;
        if (results instanceof ForceCoordinateSystemFeatureResults) {
            ForceCoordinateSystemFeatureResults forced = (ForceCoordinateSystemFeatureResults)results;
            this.results = forced.getOrigin();
        }
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    public FeatureReader reader() throws IOException {
        return new ForceCoordinateSystemFeatureReader(this.results.reader(), this.schema);
    }

    public Envelope getBounds() {
        return this.results.getBounds();
    }

    public int getCount() throws IOException {
        return this.results.getCount();
    }

    public FeatureCollection collection() throws IOException {
        FeatureCollection collection = FeatureCollections.newCollection();
        try {
            FeatureReader reader = this.reader();
            while (reader.hasNext()) {
                collection.add(reader.next());
            }
        }
        catch (NoSuchElementException e) {
            throw new DataSourceException("This should not happen", e);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("This should not happen", e);
        }
        return collection;
    }

    public FeatureResults getOrigin() {
        return this.results;
    }
}

