/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.MutableFIDFeature;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;

public class JDBCFeatureWriter
implements FeatureWriter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    protected QueryData queryData;
    protected FeatureReader reader;
    protected Feature live;
    protected Feature current;
    protected FeatureListenerManager listenerManager = new FeatureListenerManager();
    protected boolean closed;
    protected Object[] fidAttributes;

    public JDBCFeatureWriter(FeatureReader reader, QueryData queryData) {
        this.reader = reader;
        this.queryData = queryData;
    }

    public FeatureType getFeatureType() {
        return this.reader.getFeatureType();
    }

    public Feature next() throws IOException {
        if (this.reader == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        FeatureType featureType = this.getFeatureType();
        if (this.hasNext()) {
            try {
                this.live = this.reader.next();
                this.current = featureType.duplicate(this.live);
                LOGGER.finer("Calling next on writer");
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("Unable to edit " + this.live.getID() + " of " + featureType.getTypeName(), e);
            }
        }
        this.live = null;
        try {
            Feature temp = DataUtilities.template(featureType);
            this.current = new MutableFIDFeature((DefaultFeatureType)featureType, temp.getAttributes(new Object[temp.getNumberOfAttributes()]), null);
            if (this.useQueryDataForInsert()) {
                this.queryData.startInsert();
            }
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Unable to add additional Features of " + featureType.getTypeName(), e);
        }
        catch (SQLException e) {
            throw new DataSourceException("Unable to move to insert row. " + e.getMessage(), e);
        }
        return this.current;
    }

    protected boolean useQueryDataForInsert() {
        return true;
    }

    public void remove() throws IOException {
        if (this.closed) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.current == null) {
            throw new IOException("No feature available to remove");
        }
        if (this.live != null) {
            LOGGER.fine("Removing " + this.live);
            Envelope bounds = this.live.getBounds();
            this.live = null;
            this.current = null;
            try {
                this.queryData.deleteCurrentRow();
                this.listenerManager.fireFeaturesRemoved(this.getFeatureType().getTypeName(), this.queryData.getTransaction(), bounds, false);
            }
            catch (SQLException sqle) {
                String message = "problem deleting row";
                if (this.queryData.getTransaction() != Transaction.AUTO_COMMIT) {
                    this.queryData.getTransaction().rollback();
                    message = message + "(transaction canceled)";
                }
                throw new DataSourceException(message, sqle);
            }
        } else {
            this.current = null;
        }
    }

    public void write() throws IOException {
        if (this.closed) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.current == null) {
            throw new IOException("No feature available to write");
        }
        LOGGER.fine("write called, live is " + this.live + " and cur is " + this.current);
        if (this.live != null) {
            if (this.live.equals(this.current)) {
                this.live = null;
                this.current = null;
            } else {
                try {
                    this.doUpdate(this.live, this.current);
                }
                catch (SQLException sqlException) {
                    this.queryData.close(sqlException);
                    throw new DataSourceException("Error updating row", sqlException);
                }
                Envelope bounds = new Envelope();
                bounds.expandToInclude(this.live.getBounds());
                bounds.expandToInclude(this.current.getBounds());
                this.listenerManager.fireFeaturesChanged(this.getFeatureType().getTypeName(), this.queryData.getTransaction(), bounds, false);
                this.live = null;
                this.current = null;
            }
        } else {
            LOGGER.fine("doing insert in jdbc featurewriter");
            try {
                this.doInsert((MutableFIDFeature)this.current);
            }
            catch (SQLException e) {
                throw new DataSourceException("Row adding failed.", e);
            }
            this.listenerManager.fireFeaturesAdded(this.getFeatureType().getTypeName(), this.queryData.getTransaction(), this.current.getBounds(), false);
            this.current = null;
        }
    }

    protected void doUpdate(Feature live, Feature current) throws IOException, SQLException {
        try {
            for (int i = 0; i < current.getNumberOfAttributes(); ++i) {
                Object currAtt = current.getAttribute(i);
                Object liveAtt = live.getAttribute(i);
                if (live != null && DataUtilities.attributesEqual(currAtt, liveAtt)) continue;
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("modifying att# " + i + " to " + currAtt);
                }
                this.queryData.write(i, currAtt);
            }
        }
        catch (IOException ioe) {
            String message = "problem modifying row";
            if (this.queryData.getTransaction() != Transaction.AUTO_COMMIT) {
                this.queryData.getTransaction().rollback();
                message = message + "(transaction canceled)";
            }
            throw ioe;
        }
        this.queryData.updateRow();
    }

    protected void doInsert(MutableFIDFeature mutable) throws IOException, SQLException {
        int i;
        this.queryData.startInsert();
        FIDMapper mapper = this.queryData.getMapper();
        if (mapper.getColumnCount() > 0 && !mapper.returnFIDColumnsAsAttributes()) {
            String ID2 = mapper.createID(this.queryData.getConnection(), mutable, null);
            this.fidAttributes = mapper.getPKAttributes(ID2);
            if (this.fidAttributes != null) {
                mutable.setID(ID2);
                for (int i2 = 0; i2 < this.fidAttributes.length; ++i2) {
                    Object fidAttribute = this.fidAttributes[i2];
                    if (mapper.isAutoIncrement(i2)) continue;
                    this.queryData.writeFidColumn(i2, fidAttribute);
                }
            }
        }
        for (i = 0; i < this.current.getNumberOfAttributes(); ++i) {
            Object currAtt = this.current.getAttribute(i);
            this.queryData.write(i, currAtt);
        }
        this.queryData.doInsert();
        if (mapper.getColumnCount() > 0 && mapper.hasAutoIncrementColumns()) {
            this.fidAttributes = new Object[mapper.getColumnCount()];
            for (i = 0; i < this.fidAttributes.length; ++i) {
                this.fidAttributes[i] = this.queryData.readFidColumn(i);
            }
            mutable.setID(mapper.getID(this.fidAttributes));
        }
    }

    public boolean hasNext() throws IOException {
        if (this.queryData.isClosed()) {
            throw new IOException("Feature writer is closed");
        }
        return this.reader.hasNext();
    }

    public void close() throws IOException {
        if (this.queryData.isClosed()) {
            LOGGER.warning("Feature writer calling close when queryData is  already closed");
        } else {
            this.reader.close();
        }
    }
}

