/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.factory.OptionalFactory;
import org.geotools.resources.Utilities;

public class FactoryRegistry
extends ServiceRegistry {
    private static final ServiceRegistry.Filter FILTER = new ServiceRegistry.Filter(){

        public boolean filter(Object provider) {
            return !(provider instanceof OptionalFactory) || ((OptionalFactory)provider).isReady();
        }
    };

    public FactoryRegistry(Collection categories) {
        super(categories.iterator());
    }

    public Iterator getServiceProviders(Class category) {
        Iterator iterator = this.getServiceProviders(category, FILTER, true);
        if (!iterator.hasNext()) {
            Iterator it = this.getClassLoaders().iterator();
            while (it.hasNext()) {
                this.scanForPlugins((ClassLoader)it.next(), category);
            }
            iterator = this.getServiceProviders(category, FILTER, true);
        }
        return iterator;
    }

    public Object getServiceProvider(Class category, ServiceRegistry.Filter filter, Hints hints, Hints.Key key) throws FactoryRegistryException {
        Object candidate;
        Class implementation = null;
        if (key != null) {
            if (!category.isAssignableFrom(key.getValueClass())) {
                throw new IllegalArgumentException("Illegal hint key: " + key);
            }
            if (hints != null && !hints.isEmpty()) {
                Object hint = hints.get(key);
                if (category.isInstance(hint)) {
                    return hint;
                }
                if (hint instanceof Class[]) {
                    Class[] types = (Class[])hint;
                    for (int i = 0; i < types.length - 1; ++i) {
                        Object candidate2 = this.getServiceProvider(category, types[i], filter, hints);
                        if (candidate2 == null) continue;
                        return candidate2;
                    }
                    if (types.length != 0) {
                        implementation = types[types.length - 1];
                    }
                } else {
                    implementation = (Class)hint;
                }
            }
        }
        if ((candidate = this.getServiceProvider(category, implementation, filter, hints)) != null) {
            return candidate;
        }
        String message = implementation == null ? "No factory found for category \"" + Utilities.getShortName(category) + "\"." : "No factory found for implementation \"" + Utilities.getShortName(implementation) + "\".";
        throw new FactoryNotFoundException(message);
    }

    private Object getServiceProvider(Class category, Class implementation, ServiceRegistry.Filter filter, Hints hints) {
        Iterator it = this.getServiceProviders(category);
        while (it.hasNext()) {
            Object candidate = it.next();
            if (filter != null && !filter.filter(candidate) || implementation != null && !implementation.isInstance(candidate) || hints != null && (candidate instanceof Factory && !this.isAcceptable((Factory)candidate, category, hints, null) || !this.isAcceptable(candidate, category, hints))) continue;
            return candidate;
        }
        return null;
    }

    private boolean isAcceptable(Factory factory, Class category, Hints hints, Set alreadyDone) {
        Iterator it = factory.getImplementationHints().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            Object expected = hints.get(entry.getKey());
            if (expected != null) {
                if (expected instanceof Class) {
                    if (!((Class)expected).isInstance(value)) {
                        return false;
                    }
                } else if (expected instanceof Class[]) {
                    Class[] types = (Class[])expected;
                    int i = 0;
                    do {
                        if (i < types.length) continue;
                        return false;
                    } while (!types[i++].isInstance(value));
                } else if (!expected.equals(value)) {
                    return false;
                }
            }
            if (!this.isAcceptable(value, category, hints)) {
                return false;
            }
            if (!(value instanceof Factory)) continue;
            if (alreadyDone == null) {
                alreadyDone = new HashSet<Factory>();
            }
            if (alreadyDone.contains(value)) continue;
            alreadyDone.add(factory);
            if (this.isAcceptable((Factory)value, category, hints, alreadyDone)) continue;
            return false;
        }
        return true;
    }

    protected boolean isAcceptable(Object provider, Class category, Hints hints) {
        return true;
    }

    public final Set getClassLoaders() {
        HashSet<ClassLoader> loaders = new HashSet<ClassLoader>();
        for (int i = 0; i < 4; ++i) {
            ClassLoader loader;
            try {
                switch (i) {
                    case 0: {
                        loader = this.getClass().getClassLoader();
                        break;
                    }
                    case 1: {
                        loader = (class$org$geotools$factory$FactoryRegistry == null ? FactoryRegistry.class$("org.geotools.factory.FactoryRegistry") : class$org$geotools$factory$FactoryRegistry).getClassLoader();
                        break;
                    }
                    case 2: {
                        loader = Thread.currentThread().getContextClassLoader();
                        break;
                    }
                    case 3: {
                        loader = ClassLoader.getSystemClassLoader();
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
            }
            catch (SecurityException exception) {
                continue;
            }
            loaders.add(loader);
        }
        ClassLoader[] asArray = loaders.toArray(new ClassLoader[loaders.size()]);
        for (int i = 0; i < asArray.length; ++i) {
            ClassLoader loader = asArray[i];
            try {
                while ((loader = loader.getParent()) != null) {
                    loaders.remove(loader);
                }
                continue;
            }
            catch (SecurityException exception) {
                // empty catch block
            }
        }
        if (loaders.isEmpty()) {
            Logger.getLogger("org.geotools.factory").warning("No class loaders available");
        }
        return loaders;
    }

    public void scanForPlugins() {
        Set loaders = this.getClassLoaders();
        Iterator<Class<?>> categories = this.getCategories();
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            Iterator it = loaders.iterator();
            while (it.hasNext()) {
                ClassLoader loader = (ClassLoader)it.next();
                this.scanForPlugins(loader, category);
            }
        }
    }

    private void scanForPlugins(ClassLoader loader, Class category) {
        boolean newServices;
        StringBuffer message;
        block13: {
            Class<?> factoryClass;
            Iterator factories = ServiceRegistry.lookupProviders(category, loader);
            String lineSeparator = System.getProperty("line.separator", "\n");
            message = new StringBuffer();
            message.append("Scan for '");
            message.append(Utilities.getShortName(category));
            message.append("' implementations:");
            newServices = false;
            while (factories.hasNext()) {
                Object factory = factories.next();
                factoryClass = factory.getClass();
                Object replacement = this.getServiceProviderByClass(factoryClass);
                if (replacement != null) {
                    factory = replacement;
                }
                if (!this.registerServiceProvider(factory, category)) continue;
                message.append(lineSeparator);
                message.append("  Register ");
                message.append(factoryClass.getName());
                newServices = true;
            }
            try {
                String classname = System.getProperty(category.getName());
                if (classname == null) break block13;
                try {
                    factoryClass = loader.loadClass(classname);
                    Object factory = this.getServiceProviderByClass(factoryClass);
                    if (factory == null) {
                        try {
                            factory = factoryClass.newInstance();
                            if (this.registerServiceProvider(factory, category)) {
                                message.append(lineSeparator);
                                message.append("  Register ");
                                message.append(factoryClass.getName());
                                message.append(" from system property");
                                newServices = true;
                            }
                        }
                        catch (IllegalAccessException exception) {
                            throw new FactoryRegistryException("Can't create factory for the \"" + classname + "\" system property.", exception);
                        }
                        catch (InstantiationException exception) {
                            throw new FactoryRegistryException("Can't create factory for the \"" + classname + "\" system property.", exception);
                        }
                    }
                    Iterator it = this.getServiceProviders(category, false);
                    while (it.hasNext()) {
                        Object other = it.next();
                        if (other == factory) continue;
                        this.setOrdering(category, factory, other);
                    }
                }
                catch (ClassNotFoundException exception) {
                }
            }
            catch (SecurityException exception) {
                // empty catch block
            }
        }
        if (newServices) {
            LogRecord record = new LogRecord(Level.CONFIG, message.toString());
            record.setSourceClassName(FactoryRegistry.class.getName());
            record.setSourceMethodName("scanForPlugins");
            Logger.getLogger("org.opengis.factory").log(record);
        }
    }

    public boolean setOrdering(Class category, Comparator comparator) {
        boolean set = false;
        ArrayList previous = new ArrayList();
        Iterator it = this.getServiceProviders(category, false);
        while (it.hasNext()) {
            Object f1 = it.next();
            int i = previous.size();
            while (--i >= 0) {
                int c;
                Object f2 = previous.get(i);
                try {
                    c = comparator.compare(f1, f2);
                }
                catch (ClassCastException exception) {
                    continue;
                }
                if (c > 0) {
                    set |= this.setOrdering(category, f1, f2);
                    continue;
                }
                if (c >= 0) continue;
                set |= this.setOrdering(category, f2, f1);
            }
            previous.add(f1);
        }
        return set;
    }

    public boolean setOrdering(Class base, boolean set, ServiceRegistry.Filter service1, ServiceRegistry.Filter service2) {
        boolean done = false;
        Iterator<Class<?>> categories = this.getCategories();
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            if (!base.isAssignableFrom(category)) continue;
            Object impl1 = null;
            Object impl2 = null;
            Iterator it = this.getServiceProviders(category);
            while (it.hasNext()) {
                Object factory = it.next();
                if (service1.filter(factory)) {
                    impl1 = factory;
                }
                if (service2.filter(factory)) {
                    impl2 = factory;
                }
                if (impl1 == null || impl2 == null || impl1 == impl2) continue;
                if (set) {
                    done |= this.setOrdering(category, impl1, impl2);
                    continue;
                }
                done |= this.unsetOrdering(category, impl1, impl2);
            }
        }
        return done;
    }
}

