/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Date;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultAttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.type.FeatureAttributeType;
import org.geotools.feature.type.GeometricAttributeType;
import org.geotools.feature.type.NumericAttributeType;
import org.geotools.feature.type.TemporalAttributeType;
import org.geotools.feature.type.TextualAttributeType;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LengthFunction;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultAttributeTypeFactory
extends AttributeTypeFactory {
    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, int fieldLength) {
        return this.createAttributeType(name, clazz, isNillable, fieldLength, null);
    }

    protected AttributeType createAttributeType(String name, FeatureType type, boolean isNillable) {
        return new FeatureAttributeType(name, type, isNillable, 1, 1);
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, int fieldLength, Object defaultValue) {
        FilterFactory ff = FilterFactory.createFilterFactory();
        LengthFunction length = (LengthFunction)ff.createFunctionExpression("LengthFunction");
        length.setArgs(new Expression[]{null});
        CompareFilter cf = null;
        try {
            cf = ff.createCompareFilter((short)17);
            cf.addLeftValue(length);
            cf.addRightValue(ff.createLiteralExpression(fieldLength));
        }
        catch (IllegalFilterException e) {
            // empty catch block
        }
        Filter f = cf == null ? Filter.ALL : cf;
        if (Number.class.isAssignableFrom(clazz)) {
            return new NumericAttributeType(name, clazz, isNillable, 1, 1, defaultValue, f);
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return new TextualAttributeType(name, isNillable, 1, 1, defaultValue, f);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new TemporalAttributeType(name, isNillable, 1, 1, defaultValue, f);
        }
        if (Geometry.class.isAssignableFrom(clazz)) {
            return new GeometricAttributeType(name, clazz, isNillable, 1, 1, defaultValue, null, f);
        }
        return new DefaultAttributeType(name, clazz, isNillable, 1, 1, defaultValue, cf);
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, Filter filter, Object defaultValue, Object metadata) {
        FilterFactory ff = FilterFactory.createFilterFactory();
        LengthFunction length = (LengthFunction)ff.createFunctionExpression("LengthFunction");
        length.setArgs(new Expression[]{null});
        if (Number.class.isAssignableFrom(clazz)) {
            return new NumericAttributeType(name, clazz, isNillable, 1, 1, defaultValue, filter);
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return new TextualAttributeType(name, isNillable, 1, 1, defaultValue, filter);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new TemporalAttributeType(name, isNillable, 1, 1, defaultValue, filter);
        }
        if (Geometry.class.isAssignableFrom(clazz)) {
            return new GeometricAttributeType(name, clazz, isNillable, 1, 1, defaultValue, null, filter);
        }
        return new DefaultAttributeType(name, clazz, isNillable, 1, 1, defaultValue, filter);
    }

    protected AttributeType createAttributeType(String name, Class clazz, boolean isNillable, int fieldLength, Object defaultValue, Object metaData) {
        if (Geometry.class.isAssignableFrom(clazz) && metaData instanceof CoordinateReferenceSystem) {
            FilterFactory ff = FilterFactory.createFilterFactory();
            LengthFunction length = (LengthFunction)ff.createFunctionExpression("LengthFunction");
            length.setArgs(new Expression[]{null});
            CompareFilter cf = null;
            try {
                cf = ff.createCompareFilter((short)17);
                cf.addLeftValue(length);
                cf.addRightValue(ff.createLiteralExpression(fieldLength));
            }
            catch (IllegalFilterException e) {
                // empty catch block
            }
            Filter f = cf == null ? Filter.ALL : cf;
            return new GeometricAttributeType(name, clazz, isNillable, 1, 1, defaultValue, (CoordinateReferenceSystem)metaData, f);
        }
        return this.createAttributeType(name, clazz, isNillable, fieldLength, defaultValue);
    }
}

